/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.extend;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.SingleValueExtendOperationExecutor;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;

public class IterateOverChildren
implements ISearchOperation {
    private final int position;
    private int sourcePosition;
    private final boolean transitive;

    public IterateOverChildren(int position, int sourcePosition, boolean transitive) {
        this.position = position;
        this.sourcePosition = sourcePosition;
        this.transitive = transitive;
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    @Override
    public String toString(Function<Integer, String> variableMapping) {
        return "extend    containment +" + variableMapping.apply(this.sourcePosition) + " <>--> -" + variableMapping.apply(this.position) + (this.transitive ? " transitively" : " directly");
    }

    @Override
    public ISearchOperation.ISearchOperationExecutor createExecutor() {
        return new Executor(this.position);
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Arrays.asList(this.position, this.sourcePosition);
    }

    private class Executor
    extends SingleValueExtendOperationExecutor<EObject> {
        public Executor(int position) {
            super(position);
        }

        @Override
        public Iterator<EObject> getIterator(MatchingFrame frame, ISearchContext context) {
            Preconditions.checkState((boolean)(frame.get(IterateOverChildren.this.sourcePosition) instanceof EObject), (String)"Only children of EObject elements are supported.");
            EObject source = (EObject)frame.get(IterateOverChildren.this.sourcePosition);
            if (IterateOverChildren.this.transitive) {
                return source.eAllContents();
            }
            return source.eContents().iterator();
        }

        @Override
        public ISearchOperation getOperation() {
            return IterateOverChildren.this;
        }
    }
}

