/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.nls.ui;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.presentation.IObjectPresentation;
import org.eclipse.wb.internal.core.nls.Messages;
import org.eclipse.wb.internal.core.nls.edit.IEditableSource;
import org.eclipse.wb.internal.core.nls.edit.IEditableSourceListener;
import org.eclipse.wb.internal.core.nls.model.LocaleInfo;
import org.eclipse.wb.internal.core.nls.ui.AddKeyValueDialog;
import org.eclipse.wb.internal.core.nls.ui.LocaleUtils;
import org.eclipse.wb.internal.core.nls.ui.NewLocaleDialog;
import org.eclipse.wb.internal.core.nls.ui.TableTextCellEditor;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;
import org.eclipse.wb.internal.core.utils.ui.PixelConverter;
import org.eclipse.wb.internal.core.utils.ui.UiUtils;

public final class SourceComposite
extends Composite {
    private final IEditableSource m_source;
    private LocaleInfo[] m_locales;
    private final List<String> m_keys = Lists.newArrayList();
    private final PixelConverter m_pixelConverter = new PixelConverter((Control)this);
    private final TableViewer m_viewer;
    private final Table m_table;
    private final Button m_currentStringsButton;

    public SourceComposite(Composite parent, int style, IEditableSource source) throws Exception {
        super(parent, style);
        this.m_source = source;
        this.m_source.addListener(new IEditableSourceListener(){

            @Override
            public void keyAdded(String key, Object o) {
                SourceComposite.this.m_keys.add(key);
                SourceComposite.this.m_viewer.add((Object)key);
            }

            @Override
            public void keyRemoved(String key) {
                SourceComposite.this.m_keys.remove(key);
                SourceComposite.this.m_viewer.remove((Object)key);
            }

            @Override
            public void keyRenamed(String oldKey, String newKey) {
                if (SourceComposite.this.m_keys.contains(newKey)) {
                    SourceComposite.this.m_viewer.remove((Object)oldKey);
                } else {
                    int index = SourceComposite.this.m_keys.indexOf(oldKey);
                    SourceComposite.this.m_keys.set(index, newKey);
                    SourceComposite.this.m_viewer.remove((Object)oldKey);
                    SourceComposite.this.m_viewer.insert((Object)newKey, index);
                }
                SourceComposite.this.m_viewer.setSelection((ISelection)new StructuredSelection((Object)newKey));
            }
        });
        this.m_keys.addAll(this.m_source.getKeys());
        Collections.sort(this.m_keys);
        GridLayoutFactory.create((Composite)this).columns(2);
        Label stringsLabel = new Label((Composite)this, 0);
        GridDataFactory.create((Control)stringsLabel).spanH(2).fillH();
        stringsLabel.setText(Messages.SourceComposite_stringsLabel);
        this.m_viewer = new TableViewer((Composite)this, 67584);
        this.m_viewer.setContentProvider((IContentProvider)new StringsContentProvider());
        this.m_viewer.setLabelProvider((IBaseLabelProvider)new StringsLabelProvider());
        this.m_viewer.setCellModifier((ICellModifier)new StringsCellModifier());
        this.m_table = this.m_viewer.getTable();
        this.m_table.setHeaderVisible(true);
        this.m_table.setLinesVisible(true);
        GridDataFactory.create((Control)this.m_table).spanH(2).grab().fill();
        this.setViewerMenu();
        this.setTooltipProvider();
        TableColumn keyColumn = new TableColumn(this.m_table, 0);
        keyColumn.setText(Messages.SourceComposite_keyColumn);
        keyColumn.setWidth(this.m_pixelConverter.convertWidthInCharsToPixels(60));
        this.createLocaleColumns();
        Label hintLabel = new Label((Composite)this, 64);
        GridDataFactory.create((Control)hintLabel).spanH(2);
        hintLabel.setText(Messages.SourceComposite_hint);
        this.m_currentStringsButton = new Button((Composite)this, 32);
        this.m_currentStringsButton.setText(Messages.SourceComposite_onlyCurrentFormFlag);
        this.m_currentStringsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SourceComposite.this.m_viewer.refresh();
            }
        });
        Button newLocaleButton = new Button((Composite)this, 0);
        GridDataFactory.create((Control)newLocaleButton).alignHR();
        newLocaleButton.setText(Messages.SourceComposite_newLocaleButton);
        newLocaleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SourceComposite.this.addNewLocale();
            }
        });
        this.m_viewer.setInput((Object)this);
    }

    private void createLocaleColumns() {
        TableColumn column;
        this.m_locales = this.m_source.getLocales();
        LocaleUtils.sortByTitle(this.m_locales);
        TableColumn[] columns = this.m_table.getColumns();
        int i = 1;
        while (i < columns.length) {
            column = columns[i];
            column.dispose();
            ++i;
        }
        int i2 = 0;
        while (i2 < this.m_locales.length) {
            LocaleInfo localeInfo = this.m_locales[i2];
            column = new TableColumn(this.m_table, 0);
            column.setText(localeInfo.getTitle());
            column.setImage(LocaleUtils.getImage(localeInfo));
            column.setWidth(this.m_pixelConverter.convertWidthInCharsToPixels(30));
            ++i2;
        }
        String[] columnProperties = new String[1 + this.m_locales.length];
        columnProperties[0] = "key";
        i = 0;
        while (i < this.m_locales.length) {
            columnProperties[1 + i] = Integer.toString(i);
            ++i;
        }
        this.m_viewer.setColumnProperties(columnProperties);
        CellEditor[] columnEditors = new CellEditor[1 + this.m_locales.length];
        i = 0;
        while (i < columnEditors.length) {
            TableTextCellEditor editor = new TableTextCellEditor(this.m_viewer, i);
            columnEditors[i] = editor;
            final int column2 = i++;
            editor.getText().addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    switch (e.detail) {
                        case 16: {
                            SourceComposite.this.editColumnOrNextPossible(column2);
                            e.detail = 0;
                            break;
                        }
                        case 8: {
                            SourceComposite.this.editColumnOrPrevPossible(column2);
                            e.detail = 0;
                        }
                    }
                }
            });
        }
        this.m_viewer.setCellEditors(columnEditors);
    }

    private String getSelectedKey() {
        return (String)((IStructuredSelection)this.m_viewer.getSelection()).getFirstElement();
    }

    private void editColumnOrNextPossible(int column) {
        String selectedKey = this.getSelectedKey();
        int nextColumn = this.getNextColumn(column);
        this.m_viewer.editElement((Object)selectedKey, nextColumn);
    }

    private void editColumnOrPrevPossible(int column) {
        String selectedKey = this.getSelectedKey();
        int prevColumn = this.getPrevColumn(column);
        this.m_viewer.editElement((Object)selectedKey, prevColumn);
    }

    private int getNextColumn(int column) {
        return column >= this.m_table.getColumnCount() - 1 ? 0 : column + 1;
    }

    private int getPrevColumn(int column) {
        return column <= 0 ? this.m_table.getColumnCount() - 1 : column - 1;
    }

    private void addKeyValue() {
        AddKeyValueDialog newLocaleDialog = new AddKeyValueDialog(this.getShell());
        if (newLocaleDialog.open() == 0) {
            String key = newLocaleDialog.getKey();
            String value = newLocaleDialog.getValue();
            this.m_source.addKey(key, value);
            this.m_viewer.refresh();
        }
    }

    private void addNewLocale() {
        NewLocaleDialog newLocaleDialog = new NewLocaleDialog(this.getShell(), this.m_source.getLocales());
        if (newLocaleDialog.open() == 0) {
            LocaleInfo localeInfo = newLocaleDialog.getSelectedLocale();
            LocaleInfo baseLocaleInfo = newLocaleDialog.getBaseLocale();
            this.m_source.addLocale(localeInfo, baseLocaleInfo);
            this.createLocaleColumns();
            this.m_viewer.refresh();
        }
    }

    private void setViewerMenu() {
        MenuManager menuManager = new MenuManager(null);
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IStructuredSelection selection = (IStructuredSelection)SourceComposite.this.m_viewer.getSelection();
                if (!selection.isEmpty()) {
                    final String key = (String)selection.getFirstElement();
                    if (SourceComposite.this.m_source.getFormKeys().contains(key)) {
                        manager.add((IAction)new Action(Messages.SourceComposite_internalizeKeyAction){

                            public void run() {
                                if (!MessageDialog.openConfirm((Shell)SourceComposite.this.getShell(), (String)Messages.SourceComposite_internalizeTitle, (String)MessageFormat.format(Messages.SourceComposite_internalizeMessage, key))) {
                                    return;
                                }
                                ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

                                    public void run() throws Exception {
                                        SourceComposite.this.m_source.internalizeKey(key);
                                    }
                                });
                            }
                        });
                    }
                }
                manager.add((IAction)new Action(Messages.SourceComposite_addKeyValueAction){

                    public void run() {
                        SourceComposite.this.addKeyValue();
                    }
                });
                manager.add((IAction)new Action(Messages.SourceComposite_addLocaleAction){

                    public void run() {
                        SourceComposite.this.addNewLocale();
                    }
                });
                final int column = UiUtils.getColumnUnderCursor((Table)SourceComposite.this.m_table);
                Action action = new Action(Messages.SourceComposite_removeLocaleAction){

                    public void run() {
                        final LocaleInfo locale = SourceComposite.this.m_locales[column - 1];
                        if (!MessageDialog.openConfirm((Shell)SourceComposite.this.getShell(), (String)Messages.SourceComposite_removeLocaleTitle, (String)MessageFormat.format(Messages.SourceComposite_removeLocaleMessage, locale.getTitle()))) {
                            return;
                        }
                        ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

                            public void run() throws Exception {
                                SourceComposite.this.m_source.removeLocale(locale);
                                SourceComposite.this.createLocaleColumns();
                                SourceComposite.this.m_viewer.refresh();
                            }
                        });
                    }
                };
                action.setEnabled(column > 1 && column < SourceComposite.this.m_table.getColumnCount());
                manager.add((IAction)action);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)this.m_table);
        this.m_table.setMenu(menu);
    }

    private void setTooltipProvider() {
        UiUtils.installTableTooltipProvider((Table)this.m_table, (UiUtils.ITableTooltipProvider)this.createTooltipProvider());
    }

    private UiUtils.ITableTooltipProvider createTooltipProvider() {
        return new UiUtils.ITableTooltipProvider(){

            public Control createTooltipControl(TableItem item, Composite parent, int column) {
                if (column == 0) {
                    String key = (String)item.getData();
                    Set<JavaInfo> components = SourceComposite.this.m_source.getComponentsByKey(key);
                    if (!components.isEmpty()) {
                        Composite composite = new Composite(parent, 0);
                        this.setColors((Control)composite);
                        composite.setLayout((Layout)new FillLayout(512));
                        for (final JavaInfo component : components) {
                            final CLabel label = new CLabel(composite, 0);
                            this.setColors((Control)label);
                            ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

                                public void run() throws Exception {
                                    IObjectPresentation presentation = component.getPresentation();
                                    label.setImage(presentation.getIcon());
                                    label.setText(presentation.getText());
                                }
                            });
                        }
                        return composite;
                    }
                }
                return null;
            }

            private void setColors(Control control) {
                control.setBackground(Display.getCurrent().getSystemColor(29));
                control.setForeground(Display.getCurrent().getSystemColor(28));
            }
        };
    }

    private class StringsCellModifier
    implements ICellModifier {
        private StringsCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            String key = (String)element;
            if (property.equals("key")) {
                return key;
            }
            LocaleInfo locale = this.getLocaleForProperty(property);
            String value = SourceComposite.this.m_source.getValue(locale, key);
            if (value == null) {
                return "";
            }
            return value;
        }

        public void modify(Object element, String property, Object value) {
            final String stringValue = (String)value;
            if (element instanceof Item) {
                element = ((Item)element).getData();
            }
            final String key = (String)element;
            if (property.equals("key")) {
                ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

                    public void run() throws Exception {
                        SourceComposite.this.m_source.renameKey(key, stringValue);
                    }
                });
            } else {
                LocaleInfo locale = this.getLocaleForProperty(property);
                SourceComposite.this.m_source.setValue(locale, key, stringValue);
                SourceComposite.this.m_viewer.update((Object)key, new String[]{property});
            }
        }

        private LocaleInfo getLocaleForProperty(String property) {
            int localeIndex = Integer.parseInt(property);
            return SourceComposite.this.m_locales[localeIndex];
        }
    }

    private class StringsContentProvider
    implements IStructuredContentProvider {
        private StringsContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (SourceComposite.this.m_currentStringsButton.getSelection()) {
                ArrayList elements = Lists.newArrayList();
                Set<String> formKeys = SourceComposite.this.m_source.getFormKeys();
                for (String key : SourceComposite.this.m_keys) {
                    if (!formKeys.contains(key)) continue;
                    elements.add(key);
                }
                return elements.toArray();
            }
            return SourceComposite.this.m_keys.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class StringsLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private StringsLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            String key = (String)element;
            if (columnIndex == 0) {
                return key;
            }
            LocaleInfo locale = SourceComposite.this.m_locales[columnIndex - 1];
            return SourceComposite.this.m_source.getValue(locale, key);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                String key = (String)element;
                Set<JavaInfo> components = SourceComposite.this.m_source.getComponentsByKey(key);
                if (!components.isEmpty()) {
                    final JavaInfo component = components.iterator().next();
                    return (Image)ExecutionUtils.runObjectLog((RunnableObjectEx)new RunnableObjectEx<Image>(){

                        public Image runObject() throws Exception {
                            return component.getPresentation().getIcon();
                        }
                    }, null);
                }
            }
            return null;
        }
    }
}

