import RAL from './ral';
import { Message } from './messages';
import { Event } from './events';
import { ContentEncoder, ContentTypeEncoder } from './encoding';
export interface MessageWriter {
    readonly onError: Event<[Error, Message | undefined, number | undefined]>;
    readonly onClose: Event<void>;
    write(msg: Message): Promise<void>;
    dispose(): void;
}
export declare namespace MessageWriter {
    function is(value: any): value is MessageWriter;
}
export declare abstract class AbstractMessageWriter {
    private errorEmitter;
    private closeEmitter;
    constructor();
    dispose(): void;
    get onError(): Event<[Error, Message | undefined, number | undefined]>;
    protected fireError(error: any, message?: Message, count?: number): void;
    get onClose(): Event<void>;
    protected fireClose(): void;
    private asError;
}
export interface MessageWriterOptions {
    charset?: RAL.MessageBufferEncoding;
    contentEncoder?: ContentEncoder;
    contentTypeEncoder?: ContentTypeEncoder;
}
export declare class WriteableStreamMessageWriter extends AbstractMessageWriter implements MessageWriter {
    private writable;
    private options;
    private errorCount;
    private writeSemaphore;
    constructor(writable: RAL.WritableStream, options?: RAL.MessageBufferEncoding | MessageWriterOptions);
    write(msg: Message): Promise<void>;
    private doWrite;
    private handleError;
}
