/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.structure;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jpt.common.ui.JptCommonUiImages;
import org.eclipse.jpt.common.ui.internal.jface.ModelItemExtendedLabelProvider;
import org.eclipse.jpt.common.ui.internal.jface.NullItemExtendedLabelProvider;
import org.eclipse.jpt.common.ui.internal.jface.StaticItemExtendedLabelProvider;
import org.eclipse.jpt.common.ui.jface.ItemExtendedLabelProvider;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.model.value.CompositePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.StaticPropertyValueModel;
import org.eclipse.jpt.common.utility.model.Model;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.persistence.ClassRef;
import org.eclipse.jpt.jpa.core.context.persistence.JarFileRef;
import org.eclipse.jpt.jpa.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.ui.JptJpaUiImages;
import org.eclipse.jpt.jpa.ui.JptJpaUiMessages;

public class PersistenceStructureItemLabelProviderFactory
implements ItemExtendedLabelProvider.Factory {
    private static final ItemExtendedLabelProvider.Factory INSTANCE = new PersistenceStructureItemLabelProviderFactory();

    public static ItemExtendedLabelProvider.Factory instance() {
        return INSTANCE;
    }

    protected PersistenceStructureItemLabelProviderFactory() {
    }

    public ItemExtendedLabelProvider buildProvider(Object item, ItemExtendedLabelProvider.Manager manager) {
        if (item instanceof Persistence) {
            return this.buildPersistenceProvider((Persistence)item, manager);
        }
        if (item instanceof PersistenceUnit) {
            return PersistenceStructureItemLabelProviderFactory.buildPersistenceUnitProvider((PersistenceUnit)item, manager);
        }
        if (item instanceof MappingFileRef) {
            return this.buildMappingFileRefProvider((MappingFileRef)item, manager);
        }
        if (item instanceof ClassRef) {
            return this.buildClassRefProvider((ClassRef)item, manager);
        }
        if (item instanceof JarFileRef) {
            return this.buildJarFileRefProvider((JarFileRef)item, manager);
        }
        return NullItemExtendedLabelProvider.instance();
    }

    protected ItemExtendedLabelProvider buildPersistenceProvider(Persistence item, ItemExtendedLabelProvider.Manager manager) {
        return new StaticItemExtendedLabelProvider(JptJpaUiImages.PERSISTENCE, JptJpaUiMessages.PERSISTENCE_ITEM_LABEL_PROVIDER_FACTORY_PERSISTENCE_LABEL, this.buildPersistenceDescription(item), manager);
    }

    protected String buildPersistenceDescription(Persistence item) {
        StringBuilder sb = new StringBuilder();
        sb.append(JptJpaUiMessages.PERSISTENCE_ITEM_LABEL_PROVIDER_FACTORY_PERSISTENCE_LABEL);
        sb.append(" - ");
        sb.append(item.getResource().getFullPath().makeRelative());
        return sb.toString();
    }

    public static ItemExtendedLabelProvider buildPersistenceUnitProvider(PersistenceUnit persistenceUnit, ItemExtendedLabelProvider.Manager manager) {
        return new ModelItemExtendedLabelProvider((Object)persistenceUnit, manager, PersistenceStructureItemLabelProviderFactory.buildPersistenceUnitImageDescriptorModel(persistenceUnit), PersistenceStructureItemLabelProviderFactory.buildPersistenceUnitTextModel(persistenceUnit), PersistenceStructureItemLabelProviderFactory.buildPersistenceUnitDescriptionModel(persistenceUnit));
    }

    protected static PropertyValueModel<ImageDescriptor> buildPersistenceUnitImageDescriptorModel(PersistenceUnit persistenceUnit) {
        return new StaticPropertyValueModel((Object)JptJpaUiImages.PERSISTENCE_UNIT);
    }

    protected static PropertyValueModel<String> buildPersistenceUnitTextModel(PersistenceUnit persistenceUnit) {
        return new PersistenceUnitTextModel(persistenceUnit);
    }

    protected static PropertyValueModel<String> buildPersistenceUnitDescriptionModel(PersistenceUnit persistenceUnit) {
        return new PersistenceUnitDescriptionModel(persistenceUnit);
    }

    protected ItemExtendedLabelProvider buildMappingFileRefProvider(MappingFileRef mappingFileRef, ItemExtendedLabelProvider.Manager manager) {
        return new ModelItemExtendedLabelProvider((Object)mappingFileRef, manager, this.buildMappingFileRefImageDescriptorModel(mappingFileRef), this.buildMappingFileRefTextModel(mappingFileRef), this.buildMappingFileRefDescriptionModel(mappingFileRef));
    }

    protected PropertyValueModel<ImageDescriptor> buildMappingFileRefImageDescriptorModel(MappingFileRef mappingFileRef) {
        return new StaticPropertyValueModel((Object)JptCommonUiImages.gray((ImageDescriptor)JptJpaUiImages.MAPPING_FILE_REF, (boolean)mappingFileRef.isDefault()));
    }

    protected PropertyValueModel<String> buildMappingFileRefTextModel(MappingFileRef mappingFileRef) {
        return new MappingFileRefTextModel(mappingFileRef);
    }

    protected PropertyValueModel<String> buildMappingFileRefDescriptionModel(MappingFileRef mappingFileRef) {
        return PersistenceStructureItemLabelProviderFactory.buildQuotedComponentDescriptionModel((JpaContextModel)mappingFileRef, this.buildMappingFileRefTextModel(mappingFileRef));
    }

    protected ItemExtendedLabelProvider buildClassRefProvider(ClassRef classRef, ItemExtendedLabelProvider.Manager manager) {
        return new ModelItemExtendedLabelProvider((Object)classRef, manager, this.buildClassRefImageDescriptorModel(classRef), this.buildClassRefTextModel(classRef), this.buildClassRefDescriptionModel(classRef));
    }

    protected PropertyValueModel<ImageDescriptor> buildClassRefImageDescriptorModel(ClassRef classRef) {
        return new StaticPropertyValueModel((Object)JptJpaUiImages.CLASS_REF);
    }

    protected PropertyValueModel<String> buildClassRefTextModel(ClassRef classRef) {
        return new ClassRefTextModel(classRef);
    }

    protected PropertyValueModel<String> buildClassRefDescriptionModel(ClassRef classRef) {
        return PersistenceStructureItemLabelProviderFactory.buildQuotedComponentDescriptionModel((JpaContextModel)classRef, this.buildClassRefTextModel(classRef));
    }

    protected ItemExtendedLabelProvider buildJarFileRefProvider(JarFileRef jarFileRef, ItemExtendedLabelProvider.Manager manager) {
        return new ModelItemExtendedLabelProvider((Object)jarFileRef, manager, this.buildJarFileRefImageDescriptorModel(jarFileRef), this.buildJarFileRefTextModel(jarFileRef), this.buildJarFileRefDescriptionModel(jarFileRef));
    }

    protected PropertyValueModel<ImageDescriptor> buildJarFileRefImageDescriptorModel(JarFileRef jarFileRef) {
        return new StaticPropertyValueModel((Object)JptJpaUiImages.JAR_FILE_REF);
    }

    protected PropertyValueModel<String> buildJarFileRefTextModel(JarFileRef jarFileRef) {
        return new JarFileRefTextModel(jarFileRef);
    }

    protected PropertyValueModel<String> buildJarFileRefDescriptionModel(JarFileRef jarFileRef) {
        return PersistenceStructureItemLabelProviderFactory.buildQuotedComponentDescriptionModel((JpaContextModel)jarFileRef, this.buildJarFileRefTextModel(jarFileRef));
    }

    public String toString() {
        return ObjectTools.singletonToString((Object)this);
    }

    public static PropertyValueModel<String> buildQuotedComponentDescriptionModel(JpaContextModel node, PropertyValueModel<String> nodeTextModel) {
        return PersistenceStructureItemLabelProviderFactory.buildComponentDescriptionModel(node, true, nodeTextModel);
    }

    public static PropertyValueModel<String> buildNonQuotedComponentDescriptionModel(JpaContextModel node, PropertyValueModel<String> ... nodeTextModels) {
        return PersistenceStructureItemLabelProviderFactory.buildComponentDescriptionModel(node, false, nodeTextModels);
    }

    protected static PropertyValueModel<String> buildComponentDescriptionModel(JpaContextModel node, boolean quote, PropertyValueModel<String> ... nodeTextModels) {
        IResource nodeResource = node.getResource();
        String nodePath = nodeResource == null ? null : nodeResource.getFullPath().makeRelative().toString();
        return new ComponentDescriptionModel(nodeTextModels, (PropertyValueModel<String>)new PersistenceUnitTextModel(node.getPersistenceUnit()), nodePath, quote);
    }

    public static class ClassRefTextModel
    extends PropertyAspectAdapter<ClassRef, String> {
        public ClassRefTextModel(ClassRef subject) {
            super("className", (Model)subject);
        }

        protected String buildValue_() {
            return ((ClassRef)this.subject).getClassName();
        }
    }

    public static class ComponentDescriptionModel
    extends CompositePropertyValueModel<String, Object> {
        protected final PropertyValueModel<String>[] nodeTextModels;
        protected final PropertyValueModel<String> persistenceUnitNameModel;
        protected final String path;
        protected final boolean quote;

        ComponentDescriptionModel(PropertyValueModel<String> nodeTextModel, PropertyValueModel<String> persistenceUnitNameModel, String path, boolean quote) {
            this(new PropertyValueModel[]{nodeTextModel}, persistenceUnitNameModel, path, quote);
        }

        ComponentDescriptionModel(PropertyValueModel<String>[] nodeTextModels, PropertyValueModel<String> persistenceUnitNameModel, String path, boolean quote) {
            super((PropertyValueModel[])ArrayTools.add((Object[])nodeTextModels, persistenceUnitNameModel));
            if (nodeTextModels.length < 1) {
                throw new IllegalArgumentException();
            }
            this.nodeTextModels = nodeTextModels;
            this.persistenceUnitNameModel = persistenceUnitNameModel;
            this.path = path;
            this.quote = quote;
        }

        protected String buildValue() {
            StringBuilder sb = new StringBuilder();
            sb.append((String)this.persistenceUnitNameModel.getValue());
            sb.append('/');
            if (this.quote) {
                sb.append('\"');
            }
            sb.append((String)this.nodeTextModels[0].getValue());
            int i = 1;
            while (i < this.nodeTextModels.length) {
                sb.append('/');
                sb.append((String)this.nodeTextModels[i].getValue());
                ++i;
            }
            if (this.quote) {
                sb.append('\"');
            }
            if (this.path != null) {
                sb.append(" - ");
                sb.append(this.path);
            }
            return sb.toString();
        }
    }

    public static class JarFileRefTextModel
    extends PropertyAspectAdapter<JarFileRef, String> {
        public JarFileRefTextModel(JarFileRef subject) {
            super("fileName", (Model)subject);
        }

        protected String buildValue_() {
            return ((JarFileRef)this.subject).getFileName();
        }
    }

    public static class MappingFileRefTextModel
    extends PropertyAspectAdapter<MappingFileRef, String> {
        public MappingFileRefTextModel(MappingFileRef subject) {
            super("fileName", (Model)subject);
        }

        protected String buildValue_() {
            return ((MappingFileRef)this.subject).getFileName();
        }
    }

    public static class PersistenceUnitDescriptionModel
    extends PersistenceUnitTextModel {
        public PersistenceUnitDescriptionModel(PersistenceUnit subject) {
            super(subject);
        }

        @Override
        protected String buildValue_() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.buildValue_());
            sb.append(" - ");
            sb.append(((PersistenceUnit)this.subject).getResource().getFullPath().makeRelative());
            return sb.toString();
        }
    }

    public static class PersistenceUnitTextModel
    extends PropertyAspectAdapter<PersistenceUnit, String> {
        public PersistenceUnitTextModel(PersistenceUnit subject) {
            super("name", (Model)subject);
        }

        protected String buildValue_() {
            return ((PersistenceUnit)this.subject).getName();
        }
    }
}

