/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.graphing.ui.wizards.filter;

import java.util.Arrays;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.linuxtools.internal.systemtap.graphing.ui.Localization;
import org.eclipse.linuxtools.internal.systemtap.graphing.ui.wizards.filter.AvailableFilterTypes;
import org.eclipse.linuxtools.internal.systemtap.graphing.ui.wizards.filter.FilterWizardPage;
import org.eclipse.linuxtools.internal.systemtap.graphing.ui.wizards.filter.SelectFilterWizardPage;
import org.eclipse.linuxtools.systemtap.graphing.core.filters.IDataSetFilter;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class SelectFilterWizard
extends Wizard
implements INewWizard {
    private SelectFilterWizardPage selectFilterPage;
    private FilterWizardPage[] filterOptionsPages;
    public String[] series;
    private IDataSetFilter filter = null;

    public SelectFilterWizard(String[] series) {
        this.series = Arrays.copyOf(series, series.length);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.setWindowTitle(Localization.getString("SelectFilterWizard.CreateFilter"));
        this.selectFilterPage = new SelectFilterWizardPage();
        this.addPage((IWizardPage)this.selectFilterPage);
        this.filterOptionsPages = new FilterWizardPage[AvailableFilterTypes.FILTER_IDS.length];
        int i = 0;
        while (i < AvailableFilterTypes.FILTER_IDS.length) {
            this.filterOptionsPages[i] = AvailableFilterTypes.getFilterWizardPage(AvailableFilterTypes.FILTER_IDS[i]);
            this.addPage((IWizardPage)this.filterOptionsPages[i]);
            ++i;
        }
    }

    public boolean canFinish() {
        return this.getCurrentFilter() != null;
    }

    private IDataSetFilter getCurrentFilter() {
        IWizardPage page = this.getContainer().getCurrentPage();
        return page instanceof FilterWizardPage ? ((FilterWizardPage)page).getFilter() : null;
    }

    public boolean performFinish() {
        this.filter = this.getCurrentFilter();
        return true;
    }

    public IDataSetFilter getFilter() {
        return this.filter;
    }

    public void dispose() {
        if (this.selectFilterPage != null) {
            this.selectFilterPage.dispose();
        }
        this.selectFilterPage = null;
        if (this.filterOptionsPages != null) {
            int i = 0;
            while (i < this.filterOptionsPages.length) {
                this.filterOptionsPages[i].dispose();
                this.filterOptionsPages[i] = null;
                ++i;
            }
        }
        this.filterOptionsPages = null;
        this.series = null;
        super.dispose();
    }
}

