/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.browser.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.modisco.infra.browser.MoDiscoBrowserPlugin;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EditingSupportUtil {
    private EditingSupportUtil() {
    }

    public static Collection<?> getNewChildDescriptors(List<EReference> eAllReferences, ResourceSet resourceSet) {
        ArrayList<CommandParameter> parameters = new ArrayList<CommandParameter>();
        for (EReference reference : eAllReferences) {
            if (!reference.isContainment()) continue;
            EditingSupportUtil.createCommandParameters(parameters, reference, resourceSet);
        }
        return parameters;
    }

    public static void createCommandParameters(List<CommandParameter> parameters, EReference feature, ResourceSet resourceSet) {
        EClass featureClass = feature.getEReferenceType();
        if (!featureClass.isInterface() && !featureClass.isAbstract()) {
            parameters.add(new CommandParameter(null, (Object)feature, (Object)featureClass.getEPackage().getEFactoryInstance().create(featureClass)));
        }
        Collection<EClass> eclasses = EditingSupportUtil.allSubClasses(feature.getEReferenceType(), resourceSet);
        for (EClass eclass : eclasses) {
            if (eclass.isAbstract()) continue;
            parameters.add(new CommandParameter(null, (Object)feature, (Object)eclass.getEPackage().getEFactoryInstance().create(eclass)));
        }
    }

    public static Collection<EClass> allSubClasses(EClass context, ResourceSet resourceSet) {
        ArrayList<EClass> result = new ArrayList<EClass>();
        ArrayList uris = new ArrayList(EPackage.Registry.INSTANCE.keySet());
        for (String ePackageURI : uris) {
            try {
                EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(ePackageURI);
                EList eClassifiers = ePackage.getEClassifiers();
                for (EClassifier eClassifier : eClassifiers) {
                    EClass eClass;
                    if (!(eClassifier instanceof EClass) || !EditingSupportUtil.isSuperTypeOf(context, eClass = (EClass)eClassifier)) continue;
                    result.add(eClass);
                }
            }
            catch (Exception e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)MoDiscoBrowserPlugin.getPlugin());
            }
        }
        return result;
    }

    public static boolean isSuperTypeOf(EClass self, EClass typeDeclaration) {
        return typeDeclaration.getEAllSuperTypes().contains((Object)self);
    }
}

