/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.editor.cheatsheet.comp;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.AbstractModel;
import org.eclipse.pde.internal.core.util.PDETextHelper;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCS;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSModel;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSObject;
import org.eclipse.pde.internal.ua.ui.PDEUserAssistanceUIPlugin;
import org.eclipse.pde.internal.ua.ui.PDEUserAssistanceUIPluginImages;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.comp.CompCSBlock;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.comp.Messages;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDEMasterDetailsBlock;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class CompCSPage
extends PDEFormPage
implements IModelChangedListener {
    public static final String PAGE_ID = "compCSPage";
    private CompCSBlock fBlock = new CompCSBlock(this);

    public CompCSPage(FormEditor editor) {
        super(editor, PAGE_ID, Messages.CompCSPage_definition);
    }

    protected String getHelpResource() {
        return "org.eclipse.pde.doc.user.composite_cs_editor";
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        ICompCSModel model = (ICompCSModel)this.getModel();
        if (model == null || !model.isLoaded()) {
            Exception e = null;
            if (model instanceof AbstractModel) {
                e = ((AbstractModel)model).getException();
            }
            this.createFormErrorContent(managedForm, Messages.CompCSPage_loadFailure, Messages.CompCSPage_error, e);
            return;
        }
        super.createFormContent(managedForm);
        form.setImage(PDEUserAssistanceUIPlugin.getDefault().getLabelProvider().get(PDEUserAssistanceUIPluginImages.DESC_CHEATSHEET_OBJ));
        String title = PDETextHelper.translateReadText((String)model.getCompCS().getFieldName());
        if (title.length() > 0) {
            form.setText(title);
        } else {
            form.setText(Messages.CompCSPage_definition);
        }
        this.fBlock.createContent(managedForm);
        this.fBlock.getMastersSection().fireSelection();
        model.addModelChangedListener((IModelChangedListener)this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form.getBody(), "org.eclipse.pde.doc.user.composite_cs_editor");
    }

    public void dispose() {
        ICompCSModel compCSModel = (ICompCSModel)this.getModel();
        if (compCSModel != null) {
            compCSModel.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 3) {
            String changeProperty;
            Object[] objects = event.getChangedObjects();
            ICompCSObject object = (ICompCSObject)objects[0];
            if (object != null && object.getType() == 0 && (changeProperty = event.getChangedProperty()) != null && changeProperty.equals("name")) {
                this.getManagedForm().getForm().setText(PDETextHelper.translateReadText((String)((String)event.getNewValue())));
            }
        } else if (event.getChangeType() == 99) {
            this.handleModelEventWorldChanged(event);
        }
        this.fBlock.modelChanged(event);
    }

    public ISelection getSelection() {
        return this.fBlock.getSelection();
    }

    private void handleModelEventWorldChanged(IModelChangedEvent event) {
        Object[] objects = event.getChangedObjects();
        ICompCSObject object = (ICompCSObject)objects[0];
        if (object == null) {
            return;
        }
        if (object.getType() == 0) {
            String newValue = ((ICompCS)object).getFieldName();
            this.getManagedForm().getForm().setText(PDETextHelper.translateReadText((String)newValue));
        }
    }

    public PDEMasterDetailsBlock getBlock() {
        return this.fBlock;
    }
}

