/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.refactor.processors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dltk.core.DLTKContentTypeManager;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.corext.refactoring.reorg.RefactoringModifications;
import org.eclipse.dltk.internal.corext.refactoring.util.ModelElementUtil;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.DeleteArguments;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.php.internal.ui.refactor.processors.Messages;

public class DeleteModifications
extends RefactoringModifications {
    private List<IAdaptable> fDelete = new ArrayList<IAdaptable>();
    private List<IModelElement> fPackagesToDelete = new ArrayList<IModelElement>();

    public void delete(IResource resource) {
        this.fDelete.add((IAdaptable)resource);
    }

    public void delete(IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            this.delete(resources[i]);
            ++i;
        }
    }

    public void delete(IModelElement[] elements) throws CoreException {
        int i = 0;
        while (i < elements.length) {
            this.delete(elements[i]);
            ++i;
        }
    }

    public void delete(IModelElement element) throws CoreException {
        switch (element.getElementType()) {
            case 1: {
                return;
            }
            case 2: {
                this.fDelete.add((IAdaptable)element);
                if (element.getResource() != null) {
                    this.getResourceModifications().addDelete(element.getResource());
                }
                return;
            }
            case 3: {
                this.fDelete.add((IAdaptable)element);
                IResource resource = element.getResource();
                if (resource != null) {
                    this.getResourceModifications().addDelete(resource);
                }
                return;
            }
            case 4: {
                this.fDelete.add((IAdaptable)element);
                this.fPackagesToDelete.add(element);
                return;
            }
            case 5: {
                this.fDelete.add((IAdaptable)element);
                try {
                    IType[] types = ((ISourceModule)element).getTypes();
                    this.fDelete.addAll(Arrays.asList(types));
                }
                catch (ModelException e) {
                    DLTKUIPlugin.log((Throwable)e);
                }
                if (element.getResource() != null) {
                    this.getResourceModifications().addDelete(element.getResource());
                }
                return;
            }
            case 7: {
                this.fDelete.add((IAdaptable)element);
                IType type = (IType)element;
                ISourceModule unit = type.getSourceModule();
                if (type.getDeclaringType() == null && unit.getElementName().endsWith(type.getElementName()) && unit.getTypes().length == 1) {
                    this.fDelete.add((IAdaptable)unit);
                    if (unit.getResource() != null) {
                        this.getResourceModifications().addDelete(unit.getResource());
                    }
                }
                return;
            }
        }
        this.fDelete.add((IAdaptable)element);
    }

    public List<IResource> postProcess() throws CoreException {
        ArrayList<IResource> resourcesCollector = new ArrayList<IResource>();
        for (IScriptFolder iScriptFolder : this.fPackagesToDelete) {
            this.handleScriptFolderDelete(iScriptFolder, resourcesCollector);
        }
        return resourcesCollector;
    }

    public void buildDelta(IResourceChangeDescriptionFactory deltaFactory) {
        for (IAdaptable element : this.fDelete) {
            if (!(element instanceof IResource)) continue;
            deltaFactory.delete((IResource)element);
        }
        this.getResourceModifications().buildDelta(deltaFactory);
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, RefactoringProcessor owner, String[] natures, SharableParticipants shared) {
        ArrayList<Object> result = new ArrayList<Object>();
        Iterator<IAdaptable> iter = this.fDelete.iterator();
        while (iter.hasNext()) {
            result.addAll(Arrays.asList(ParticipantManager.loadDeleteParticipants((RefactoringStatus)status, (RefactoringProcessor)owner, (Object)iter.next(), (DeleteArguments)new DeleteArguments(), (String[])natures, (SharableParticipants)shared)));
        }
        result.addAll(Arrays.asList(this.getResourceModifications().getParticipants(status, owner, natures, shared)));
        return result.toArray(new RefactoringParticipant[result.size()]);
    }

    private void handleScriptFolderDelete(IScriptFolder pack, ArrayList<IResource> resourcesCollector) throws CoreException {
        block12: {
            IResource[] members;
            block11: {
                IContainer container = (IContainer)pack.getResource();
                if (container == null) {
                    return;
                }
                members = container.members();
                if (pack.isRootFolder() || !this.canRemoveCompletely(pack)) break block11;
                boolean parentIsMarked = false;
                IScriptFolder parent = ModelElementUtil.getParentSubpackage((IScriptFolder)pack);
                parentIsMarked = parent == null ? false : this.fPackagesToDelete.contains(parent);
                if (parentIsMarked) {
                    if (!this.canRemoveCompletely(parent)) {
                        resourcesCollector.add((IResource)container);
                        this.getResourceModifications().addDelete((IResource)container);
                    }
                } else {
                    resourcesCollector.add((IResource)container);
                    this.getResourceModifications().addDelete((IResource)container);
                }
                break block12;
            }
            int m = 0;
            while (m < members.length) {
                block14: {
                    IScriptFolder frag;
                    IResource member;
                    block13: {
                        member = members[m];
                        if (!(member instanceof IFile)) break block13;
                        IFile file = (IFile)member;
                        if ("class".equals(file.getFileExtension()) && file.isDerived()) break block14;
                        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)pack);
                        if (DLTKCore.DEBUG) {
                            System.err.println(Messages.DeleteModifications_1);
                        }
                        if (pack.isRootFolder() && (toolkit == null || toolkit != null && !DLTKContentTypeManager.isValidResourceForContentType((IDLTKLanguageToolkit)toolkit, (IResource)file))) break block14;
                        resourcesCollector.add(member);
                        this.getResourceModifications().addDelete(member);
                    }
                    if (!pack.isRootFolder() && member instanceof IFolder && (frag = (IScriptFolder)DLTKCore.create((IResource)member)) == null) {
                        resourcesCollector.add(member);
                        this.getResourceModifications().addDelete(member);
                    }
                }
                ++m;
            }
        }
    }

    private boolean canRemoveCompletely(IScriptFolder pack) throws ModelException {
        IScriptFolder[] subPackages = ModelElementUtil.getPackageAndSubpackages((IScriptFolder)pack);
        int i = 0;
        while (i < subPackages.length) {
            if (!subPackages[i].equals(pack) && !this.fPackagesToDelete.contains(subPackages[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

