/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.ptp.debug.core.IPDebugger;
import org.eclipse.ptp.debug.core.IPSession;
import org.eclipse.ptp.debug.core.TaskSet;
import org.eclipse.ptp.debug.core.launch.IPLaunch;
import org.eclipse.ptp.debug.core.model.IPAddressBreakpoint;
import org.eclipse.ptp.debug.core.model.IPBreakpoint;
import org.eclipse.ptp.debug.core.model.IPDebugTarget;
import org.eclipse.ptp.debug.core.model.IPFunctionBreakpoint;
import org.eclipse.ptp.debug.core.model.IPLineBreakpoint;
import org.eclipse.ptp.debug.core.model.IPWatchpoint;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.model.IPDITarget;
import org.eclipse.ptp.internal.debug.core.PSession;
import org.eclipse.ptp.internal.debug.core.PSessionManager;
import org.eclipse.ptp.internal.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.internal.debug.core.breakpoint.PAddressBreakpoint;
import org.eclipse.ptp.internal.debug.core.breakpoint.PFunctionBreakpoint;
import org.eclipse.ptp.internal.debug.core.breakpoint.PLineBreakpoint;
import org.eclipse.ptp.internal.debug.core.breakpoint.PWatchpoint;
import org.eclipse.ptp.internal.debug.core.event.PDebugEvent;
import org.eclipse.ptp.internal.debug.core.event.PDebugRegisterInfo;
import org.eclipse.ptp.internal.debug.core.messages.Messages;
import org.eclipse.ptp.internal.debug.core.model.PDebugTarget;

public class PDebugModel {
    private final PSessionManager sessionMgr = new PSessionManager();

    public static IPAddressBreakpoint createAddressBreakpoint(String module, String sourceHandle, IResource resource, int lineNumber, BigInteger address, boolean enabled, int ignoreCount, String condition, boolean register, String setId, String jobId, String jobName) throws CoreException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        attributes.put("org.eclipse.debug.core.id", PDebugModel.getPluginIdentifier());
        attributes.put("charStart", new Integer(-1));
        attributes.put("charEnd", new Integer(-1));
        attributes.put("lineNumber", new Integer(lineNumber));
        attributes.put("org.eclipse.debug.core.enabled", enabled);
        attributes.put("org.eclipse.ptp.debug.core.address", address.toString(10));
        attributes.put("org.eclipse.ptp.debug.core.sourceHandle", sourceHandle);
        attributes.put("org.eclipse.ptp.debug.core.ignoreCount", new Integer(ignoreCount));
        attributes.put("org.eclipse.ptp.debug.core.condition", condition);
        attributes.put("org.eclipse.ptp.debug.core.cursetid", setId);
        attributes.put("org.eclipse.ptp.debug.core.jobname", jobName);
        return new PAddressBreakpoint(resource, attributes, jobId, setId, register);
    }

    public static IPFunctionBreakpoint createFunctionBreakpoint(String sourceHandle, IResource resource, String function, int charStart, int charEnd, int lineNumber, boolean enabled, int ignoreCount, String condition, boolean register, String setId, String jobId, String jobName) throws CoreException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        attributes.put("org.eclipse.debug.core.id", PDebugModel.getPluginIdentifier());
        attributes.put("charStart", new Integer(charStart));
        attributes.put("charEnd", new Integer(charEnd));
        attributes.put("lineNumber", new Integer(lineNumber));
        attributes.put("org.eclipse.debug.core.enabled", enabled);
        attributes.put("org.eclipse.ptp.debug.core.function", function);
        attributes.put("org.eclipse.ptp.debug.core.sourceHandle", sourceHandle);
        attributes.put("org.eclipse.ptp.debug.core.ignoreCount", new Integer(ignoreCount));
        attributes.put("org.eclipse.ptp.debug.core.condition", condition);
        return new PFunctionBreakpoint(resource, attributes, jobId, setId, register);
    }

    public static IPLineBreakpoint createLineBreakpoint(String sourceHandle, IResource resource, int lineNumber, boolean enabled, int ignoreCount, String condition, boolean register, String setId, String jobId) throws CoreException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        attributes.put("org.eclipse.debug.core.id", PDebugModel.getPluginIdentifier());
        attributes.put("lineNumber", new Integer(lineNumber));
        attributes.put("org.eclipse.debug.core.enabled", new Boolean(enabled));
        attributes.put("org.eclipse.ptp.debug.core.sourceHandle", sourceHandle);
        attributes.put("org.eclipse.ptp.debug.core.ignoreCount", new Integer(ignoreCount));
        attributes.put("org.eclipse.ptp.debug.core.condition", condition);
        attributes.put("org.eclipse.ptp.debug.core.cursetid", setId);
        attributes.put("org.eclipse.ptp.debug.core.jobname", jobId);
        return new PLineBreakpoint(resource, attributes, jobId, setId, register);
    }

    public static IPWatchpoint createWatchpoint(String sourceHandle, IResource resource, boolean writeAccess, boolean readAccess, String expression, boolean enabled, int ignoreCount, String condition, boolean register, String setId, String jobId, String jobName) throws CoreException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        attributes.put("org.eclipse.debug.core.id", PDebugModel.getPluginIdentifier());
        attributes.put("org.eclipse.debug.core.enabled", enabled);
        attributes.put("org.eclipse.ptp.debug.core.sourceHandle", sourceHandle);
        attributes.put("org.eclipse.ptp.debug.core.ignoreCount", new Integer(ignoreCount));
        attributes.put("org.eclipse.ptp.debug.core.condition", condition);
        attributes.put("org.eclipse.ptp.debug.core.expression", expression);
        attributes.put("org.eclipse.ptp.debug.core.read", readAccess);
        attributes.put("org.eclipse.ptp.debug.core.write", writeAccess);
        return new PWatchpoint(resource, attributes, jobId, setId, register);
    }

    public static IPFunctionBreakpoint[] functionBreakpointExists(String sourceHandle, IResource resource, String function) throws CoreException {
        IBreakpoint[] breakpoints = PDebugModel.getBreakpoints();
        ArrayList<IPFunctionBreakpoint> foundBreakpoints = new ArrayList<IPFunctionBreakpoint>();
        String markerType = PFunctionBreakpoint.getMarkerType();
        IBreakpoint[] iBreakpointArray = breakpoints;
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IPFunctionBreakpoint funcBP;
            IBreakpoint breakpoint = iBreakpointArray[n2];
            if (breakpoint instanceof IPFunctionBreakpoint && (funcBP = (IPFunctionBreakpoint)breakpoint).getMarker().getType().equals(markerType) && PDebugModel.sameSourceHandle(sourceHandle, funcBP.getSourceHandle()) && funcBP.getMarker().getResource().equals((Object)resource) && funcBP.getFunction() != null && funcBP.getFunction().equals(function)) {
                foundBreakpoints.add(funcBP);
            }
            ++n2;
        }
        return foundBreakpoints.toArray(new IPFunctionBreakpoint[0]);
    }

    public static IBreakpoint[] getBreakpoints() {
        return DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(PDebugModel.getPluginIdentifier());
    }

    public static String getPluginIdentifier() {
        return PTPDebugCorePlugin.getUniqueIdentifier();
    }

    public static IPLineBreakpoint lineBreakpointExists(IPLineBreakpoint[] breakpoints, String jid) throws CoreException {
        IPLineBreakpoint[] iPLineBreakpointArray = breakpoints;
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IPLineBreakpoint breakpoint = iPLineBreakpointArray[n2];
            String jobId = breakpoint.getJobId();
            if (jobId.equals(IPBreakpoint.GLOBAL) || jobId.equals(jid)) {
                return breakpoint;
            }
            ++n2;
        }
        return null;
    }

    public static IPLineBreakpoint[] lineBreakpointsExists(String sourceHandle, IResource resource, int lineNumber) throws CoreException {
        IBreakpoint[] breakpoints = PDebugModel.getBreakpoints();
        ArrayList<IPLineBreakpoint> foundBreakpoints = new ArrayList<IPLineBreakpoint>();
        IBreakpoint[] iBreakpointArray = breakpoints;
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IPLineBreakpoint lineBP;
            IBreakpoint breakpoint = iBreakpointArray[n2];
            if (breakpoint instanceof IPLineBreakpoint && PDebugModel.sameSourceHandle(sourceHandle, (lineBP = (IPLineBreakpoint)breakpoint).getSourceHandle()) && lineBP.getMarker().getResource().equals((Object)resource) && lineBP.getLineNumber() == lineNumber) {
                foundBreakpoints.add(lineBP);
            }
            ++n2;
        }
        return foundBreakpoints.toArray(new IPLineBreakpoint[0]);
    }

    public static void updateBreakpoints(String setId, IProgressMonitor monitor) throws CoreException {
        try {
            IBreakpoint[] breakpoints = PDebugModel.getBreakpoints();
            monitor.beginTask(Messages.PDebugModel_0, breakpoints.length);
            IBreakpoint[] iBreakpointArray = breakpoints;
            int n = breakpoints.length;
            int n2 = 0;
            while (n2 < n) {
                IBreakpoint bpt = iBreakpointArray[n2];
                if (bpt instanceof IPBreakpoint) {
                    ((IPBreakpoint)bpt).setCurSetId(setId);
                    monitor.worked(1);
                }
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    public static IPWatchpoint[] watchpointExists(String sourceHandle, IResource resource, String expression) throws CoreException {
        ArrayList<IPWatchpoint> foundBreakpoints = new ArrayList<IPWatchpoint>();
        String markerType = PWatchpoint.getMarkerType();
        IBreakpoint[] iBreakpointArray = PDebugModel.getBreakpoints();
        int n = iBreakpointArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPWatchpoint wp;
            IBreakpoint breakpoint = iBreakpointArray[n2];
            if (breakpoint instanceof IPWatchpoint && (wp = (IPWatchpoint)breakpoint).getMarker().getType().equals(markerType) && PDebugModel.sameSourceHandle(sourceHandle, wp.getSourceHandle()) && wp.getMarker().getResource().equals((Object)resource) && wp.getExpression().equals(expression)) {
                foundBreakpoints.add(wp);
            }
            ++n2;
        }
        return foundBreakpoints.toArray(new IPWatchpoint[0]);
    }

    private static void deleteBreakpoint(String jobId) throws CoreException {
        IBreakpoint[] breakpoints = PDebugModel.findBreakpoints(jobId, false);
        if (breakpoints.length > 0) {
            DebugPlugin.getDefault().getBreakpointManager().removeBreakpoints(breakpoints, true);
        }
    }

    private static void deleteBreakpoint(String jobId, String setId) throws CoreException {
        IBreakpoint[] breakpoints = PDebugModel.findBreakpoints(jobId, setId);
        if (breakpoints.length > 0) {
            DebugPlugin.getDefault().getBreakpointManager().removeBreakpoints(breakpoints, true);
        }
    }

    private static IPBreakpoint[] findBreakpoints(String jobId, boolean includeGlobal) throws CoreException {
        IBreakpoint[] breakpoints;
        ArrayList<IPBreakpoint> bptList = new ArrayList<IPBreakpoint>();
        IBreakpoint[] iBreakpointArray = breakpoints = PDebugModel.getBreakpoints();
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IPBreakpoint breakpoint;
            String bpJobId;
            IBreakpoint bpt = iBreakpointArray[n2];
            if (bpt instanceof IPBreakpoint && ((bpJobId = (breakpoint = (IPBreakpoint)bpt).getJobId()).equals(jobId) || includeGlobal && bpJobId.equals(IPBreakpoint.GLOBAL))) {
                bptList.add(breakpoint);
            }
            ++n2;
        }
        return bptList.toArray(new IPBreakpoint[bptList.size()]);
    }

    private static IPBreakpoint[] findBreakpoints(String jobId, String setId) throws CoreException {
        IBreakpoint[] breakpoints;
        ArrayList<IPBreakpoint> bptList = new ArrayList<IPBreakpoint>();
        IBreakpoint[] iBreakpointArray = breakpoints = PDebugModel.getBreakpoints();
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IPBreakpoint breakpoint;
            IBreakpoint bpt = iBreakpointArray[n2];
            if (bpt instanceof IPBreakpoint && (breakpoint = (IPBreakpoint)bpt).getJobId().equals(jobId) && breakpoint.getSetId().equals(setId)) {
                bptList.add(breakpoint);
            }
            ++n2;
        }
        return bptList.toArray(new IPBreakpoint[0]);
    }

    private static boolean sameSourceHandle(String handle1, String handle2) {
        if (handle1 == null || handle2 == null) {
            return false;
        }
        Path path1 = new Path(handle1);
        Path path2 = new Path(handle2);
        if (path1.isValidPath(handle1) && path2.isValidPath(handle2)) {
            return path1.equals((Object)path2);
        }
        return handle1.equals(handle2);
    }

    public void addNewDebugTargets(final IPLaunch launch, final TaskSet tasks, final IPDITarget[] pdiTargets, final boolean refresh, final boolean resumeTarget) {
        WorkspaceJob aJob = new WorkspaceJob(Messages.PDebugModel_1){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                boolean allowTerminate = true;
                boolean allowDisconnect = false;
                IPSession session = PDebugModel.this.getSession(launch.getJobId());
                if (session == null) {
                    return Status.CANCEL_STATUS;
                }
                IPDITarget[] iPDITargetArray = pdiTargets;
                int n = pdiTargets.length;
                int n2 = 0;
                while (n2 < n) {
                    IPDITarget pdiTarget = iPDITargetArray[n2];
                    PDebugTarget target = new PDebugTarget(session, launch.getProcesses()[0], pdiTarget, allowTerminate, allowDisconnect);
                    if (resumeTarget) {
                        try {
                            session.getPDISession().resume(target.getTasks(), false);
                        }
                        catch (PDIException e) {
                            PTPDebugCorePlugin.log(e);
                        }
                    }
                    launch.addDebugTarget(target);
                    ++n2;
                }
                PDebugModel.this.fireRegisterEvent(launch, tasks, refresh);
                return Status.OK_STATUS;
            }
        };
        aJob.setSystem(true);
        aJob.schedule();
    }

    public void addTasks(IPSession session, String setId, TaskSet tasks) {
        TaskSet curSetTasks = this.getTasks(session, setId);
        session.getSetManager().addTasks(setId, tasks);
        tasks.andNot(curSetTasks);
        try {
            IPBreakpoint[] breakpoints = PDebugModel.findBreakpoints(session.getLaunch().getJobId(), setId);
            session.getBreakpointManager().addSetBreakpoints(tasks, breakpoints);
        }
        catch (CoreException e) {
            PTPDebugCorePlugin.log(e);
        }
    }

    public IPSession createDebugSession(IPDebugger debugger, IPLaunch launch, IProject project, IProgressMonitor monitor) throws CoreException {
        long timeout = PTPDebugCorePlugin.getDefault().getCommandTimeout();
        IPDISession pdiSession = debugger.createDebugSession(timeout, launch, monitor);
        PSession session = new PSession(pdiSession, launch, project);
        this.sessionMgr.addSession(launch.getJobId(), session);
        return session;
    }

    public void createSet(IPSession session, String setId, TaskSet tasks) {
        session.getSetManager().createSet(setId, tasks);
    }

    public void deleteSet(IPSession session, String setId) {
        try {
            PDebugModel.deleteBreakpoint(session.getLaunch().getJobId(), setId);
        }
        catch (CoreException e) {
            PTPDebugCorePlugin.log(e);
        }
        session.getSetManager().deleteSets(setId);
    }

    public IPSession getSession(String jobId) {
        return this.sessionMgr.getSession(jobId);
    }

    public TaskSet getTasks(IPSession session, String setId) {
        TaskSet tasks = session.getSetManager().getTasks(setId);
        if (tasks != null) {
            return tasks.copy();
        }
        return null;
    }

    public void removeDebugTarget(final IPLaunch launch, final TaskSet tasks, final boolean refresh) {
        WorkspaceJob aJob = new WorkspaceJob(Messages.PDebugModel_2){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                int[] taskArray;
                int[] nArray = taskArray = tasks.toArray();
                int n = taskArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int task = nArray[n2];
                    IPDebugTarget target = launch.getDebugTarget(task);
                    if (target != null) {
                        target.dispose();
                        launch.removeDebugTarget(target);
                    }
                    ++n2;
                }
                PDebugModel.this.fireUnregisterEvent(launch, tasks, refresh);
                return Status.OK_STATUS;
            }
        };
        aJob.setSystem(true);
        aJob.schedule();
    }

    public void removeTasks(IPSession session, String setId, TaskSet tasks) {
        TaskSet curSetTasks = this.getTasks(session, setId);
        session.getSetManager().removeTasks(setId, tasks);
        tasks.and(curSetTasks);
        try {
            IPBreakpoint[] breakpoints = PDebugModel.findBreakpoints(session.getLaunch().getJobId(), setId);
            session.getBreakpointManager().deleteSetBreakpoints(tasks, breakpoints);
        }
        catch (CoreException e) {
            PTPDebugCorePlugin.log(e);
        }
    }

    public void shutdown() {
        IPSession[] iPSessionArray = this.sessionMgr.getSessions();
        int n = iPSessionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPSession session = iPSessionArray[n2];
            this.shutdownSession(session);
            ++n2;
        }
        this.sessionMgr.shutdown();
    }

    public void shutdownSession(String jobId) {
        if (jobId != null) {
            this.shutdownSession(this.getSession(jobId));
        }
    }

    private void fireRegisterEvent(IPLaunch launch, TaskSet tasks, boolean refresh) {
        IPSession session;
        if (!tasks.isEmpty() && (session = this.getSession(launch.getJobId())) != null) {
            PDebugRegisterInfo info = new PDebugRegisterInfo(launch, tasks, null, null, refresh);
            PTPDebugCorePlugin.getDefault().fireDebugEvent(new PDebugEvent(session, 4, 2048, info));
        }
    }

    private void fireUnregisterEvent(IPLaunch launch, TaskSet tasks, boolean refresh) {
        IPSession session;
        if (!tasks.isEmpty() && (session = this.getSession(launch.getJobId())) != null) {
            PDebugRegisterInfo info = new PDebugRegisterInfo(launch, tasks, null, null, refresh);
            PTPDebugCorePlugin.getDefault().fireDebugEvent(new PDebugEvent(session, 8, 2048, info));
        }
    }

    private void shutdownSession(IPSession session) {
        if (session != null) {
            try {
                PDebugModel.deleteBreakpoint(session.getLaunch().getJobId());
            }
            catch (CoreException e) {
                PTPDebugCorePlugin.log(e);
            }
            session.dispose();
        }
    }
}

