/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.menu.legend;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.extensions.core.SeriesListUI;
import org.eclipse.swtchart.extensions.internal.support.MappingsSupport;
import org.eclipse.swtchart.extensions.menu.legend.AbstractMenuListener;

public class HideInLegendAction
extends AbstractMenuListener {
    public HideInLegendAction(SeriesListUI seriesListUI) {
        super(seriesListUI);
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        menuManager.add((IAction)new Action(){

            public String getText() {
                return "Hide In Legend";
            }

            public String getToolTipText() {
                return "Hide the selected series in the embedded chart legend.";
            }

            public void run() {
                List<ISeries<?>> selectedSeries = HideInLegendAction.this.getSelectedSeries();
                for (ISeries<?> series : selectedSeries) {
                    MappingsSupport.mapSettings(series, "Visible In Legend", false, HideInLegendAction.this.getScrollableChart());
                }
                HideInLegendAction.this.refresh();
            }
        });
    }
}

