/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.websocket;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Random;
import org.eclipse.wst.jsdt.chromium.ConnectionLogger;
import org.eclipse.wst.jsdt.chromium.internal.transport.SocketWrapper;
import org.eclipse.wst.jsdt.chromium.internal.websocket.AbstractWsConnection;
import org.eclipse.wst.jsdt.chromium.internal.websocket.Hybi00Handshake;
import org.eclipse.wst.jsdt.chromium.internal.websocket.WsConnection;

public class Hybi00WsConnection
extends AbstractWsConnection<SocketWrapper.LoggableInputStream, SocketWrapper.LoggableOutputStream> {
    private static final Random HANDSHAKE_RANDOM = new Random();

    public static Hybi00WsConnection connect(InetSocketAddress endpoint, int timeout, String resourceId, String origin, ConnectionLogger connectionLogger) throws IOException {
        SocketWrapper socketWrapper = new SocketWrapper((SocketAddress)endpoint, timeout, connectionLogger, LOGGER_CHARSET);
        boolean handshakeDone = false;
        Exception handshakeException = null;
        try {
            try {
                Hybi00Handshake.performHandshake(socketWrapper, endpoint, resourceId, origin, HANDSHAKE_RANDOM);
                handshakeDone = true;
            }
            catch (RuntimeException e) {
                handshakeException = e;
                throw e;
            }
            catch (IOException e) {
                handshakeException = e;
                throw e;
            }
        }
        finally {
            if (!handshakeDone) {
                socketWrapper.getShutdownRelay().sendSignal(null, handshakeException);
            }
        }
        return new Hybi00WsConnection(socketWrapper, connectionLogger);
    }

    private Hybi00WsConnection(SocketWrapper socketWrapper, ConnectionLogger connectionLogger) {
        super(socketWrapper, connectionLogger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendTextualMessage(String message) throws IOException {
        byte[] bytes = message.getBytes(UTF_8_CHARSET);
        SocketWrapper.LoggableOutputStream loggableWriter = (SocketWrapper.LoggableOutputStream)this.getSocketWrapper().getLoggableOutput();
        OutputStream output = loggableWriter.getOutputStream();
        Hybi00WsConnection hybi00WsConnection = this;
        synchronized (hybi00WsConnection) {
            output.write(0);
            output.write(bytes);
            output.write(-1);
            output.flush();
        }
        loggableWriter.markSeparatorForLog();
    }

    @Override
    protected AbstractWsConnection.CloseReason runListenLoop(SocketWrapper.LoggableInputStream loggableReader) throws IOException, InterruptedException {
        BufferedInputStream input = new BufferedInputStream(loggableReader.getInputStream());
        while (true) {
            int lengthByte;
            int firstByte;
            loggableReader.markSeparatorForLog();
            try {
                firstByte = input.read();
            }
            catch (IOException e) {
                if (this.isClosingGracefully()) {
                    return AbstractWsConnection.CloseReason.USER_REQUEST;
                }
                throw e;
            }
            if (firstByte == -1) {
                if (this.isClosingGracefully()) {
                    return AbstractWsConnection.CloseReason.USER_REQUEST;
                }
                throw new IOException("Unexpected end of stream");
            }
            if ((firstByte & 0x80) == 0) {
                ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
                while (true) {
                    int i;
                    if ((i = input.read()) == -1) {
                        throw new IOException("End of stream");
                    }
                    byte b = (byte)i;
                    if (b == -1) break;
                    byteBuffer.write(b);
                }
                byte[] messageBytes = byteBuffer.toByteArray();
                final String text = new String(messageBytes, UTF_8_CHARSET);
                this.getDispatchQueue().put(new AbstractWsConnection.MessageDispatcher(){

                    @Override
                    public boolean dispatch(WsConnection.Listener userListener) {
                        userListener.textMessageRecieved(text);
                        return false;
                    }
                });
                continue;
            }
            long len = 0L;
            do {
                if ((lengthByte = input.read()) == -1) {
                    throw new IOException("End of stream");
                }
                if ((len = len * 10L + (long)(lengthByte & 0x7F)) <= Integer.MAX_VALUE) continue;
                throw new IOException("Message too long");
            } while ((lengthByte & 0x80) != 0);
            long needSkip = len;
            while (needSkip > 0L) {
                long skipped = input.skip(needSkip);
                needSkip -= skipped;
            }
            if (firstByte == -1 && len == 0L) {
                return AbstractWsConnection.CloseReason.REMOTE_CLOSE_REQUEST;
            }
            final long finalLen = len;
            this.getDispatchQueue().put(new AbstractWsConnection.MessageDispatcher(){

                @Override
                public boolean dispatch(WsConnection.Listener userListener) {
                    userListener.errorMessage(new Exception("Unexpected binary message of length " + finalLen));
                    return false;
                }
            });
        }
    }
}

