/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.view.servers;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.view.servers.AbstractServerAction;

public class PublishAction
extends AbstractServerAction {
    public PublishAction(Shell shell, ISelectionProvider selectionProvider) {
        super(shell, selectionProvider, Messages.actionPublish);
        this.setToolTipText(Messages.actionPublishToolTip);
        this.setImageDescriptor(ImageResource.getImageDescriptor("IMG_ELCL_PUBLISH"));
        this.setHoverImageDescriptor(ImageResource.getImageDescriptor("IMG_CLCL_PUBLISH"));
        this.setDisabledImageDescriptor(ImageResource.getImageDescriptor("IMG_DLCL_PUBLISH"));
        this.setActionDefinitionId("org.eclipse.wst.server.publish");
        try {
            this.selectionChanged((IStructuredSelection)selectionProvider.getSelection());
        }
        catch (Exception exception) {}
    }

    @Override
    public boolean accept(IServer server) {
        return server.canPublish().isOK();
    }

    @Override
    public void perform(IServer server) {
        PublishAction.publish(server, this.shell);
    }

    public static void publish(IServer server, final Shell shell) {
        if (shell != null && !ServerUIPlugin.promptIfDirty(shell, server)) {
            return;
        }
        if (!ServerUIPlugin.saveEditors()) {
            return;
        }
        IAdaptable info = new IAdaptable(){

            public Object getAdapter(Class adapter) {
                if (Shell.class.equals((Object)adapter)) {
                    return shell;
                }
                if (String.class.equals((Object)adapter)) {
                    return "user";
                }
                return null;
            }
        };
        server.publish(1, null, info, null);
    }
}

