/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.participant;

import java.util.List;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.di.ParticipantBandKind;
import org.eclipse.bpmn2.modeler.core.features.choreography.ChoreographyUtil;
import org.eclipse.bpmn2.modeler.core.features.containers.MoveContainerFeature;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.Tuple;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class MoveParticipantFeature
extends MoveContainerFeature {
    public MoveParticipantFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canMoveShape(IMoveShapeContext context) {
        if (context.getSourceContainer() != context.getTargetContainer()) {
            return false;
        }
        return super.canMoveShape(context);
    }

    protected void postMoveShape(IMoveShapeContext context) {
        super.postMoveShape(context);
        if (ChoreographyUtil.isChoreographyParticipantBand((PictogramElement)context.getShape())) {
            ParticipantBandKind bandKind;
            ContainerShape container = context.getTargetContainer();
            ContainerShape shape = (ContainerShape)context.getShape();
            List bands = FeatureSupport.getParticipantBandContainerShapes((ContainerShape)container);
            Tuple topAndBottom = FeatureSupport.getTopAndBottomBands((List)bands);
            List top = (List)topAndBottom.getFirst();
            List bottom = (List)topAndBottom.getSecond();
            BPMNShape bpmnShape = (BPMNShape)BusinessObjectUtil.getFirstElementOfType((PictogramElement)shape, BPMNShape.class);
            int height = container.getGraphicsAlgorithm().getHeight();
            container.getGraphicsAlgorithm().getWidth();
            for (ContainerShape cs : bottom) {
                if (cs != shape) continue;
                bottom.remove(cs);
                break;
            }
            for (ContainerShape cs : top) {
                if (cs != shape) continue;
                top.remove(cs);
                break;
            }
            if (context.getY() < height / 2) {
                top.add(shape);
            } else {
                bottom.add(0, shape);
            }
            int i = 0;
            while (i < bottom.size()) {
                bpmnShape = (BPMNShape)BusinessObjectUtil.getFirstElementOfType((PictogramElement)((PictogramElement)bottom.get(i)), BPMNShape.class);
                bandKind = bpmnShape.getParticipantBandKind();
                bandKind = i == bottom.size() - 1 ? (this.isInitiating(bandKind) ? ParticipantBandKind.BOTTOM_INITIATING : ParticipantBandKind.BOTTOM_NON_INITIATING) : (this.isInitiating(bandKind) ? ParticipantBandKind.MIDDLE_INITIATING : ParticipantBandKind.MIDDLE_NON_INITIATING);
                bpmnShape.setParticipantBandKind(bandKind);
                ++i;
            }
            i = 0;
            while (i < top.size()) {
                bpmnShape = (BPMNShape)BusinessObjectUtil.getFirstElementOfType((PictogramElement)((PictogramElement)top.get(i)), BPMNShape.class);
                bandKind = bpmnShape.getParticipantBandKind();
                bandKind = i == 0 ? (this.isInitiating(bandKind) ? ParticipantBandKind.TOP_INITIATING : ParticipantBandKind.TOP_NON_INITIATING) : (this.isInitiating(bandKind) ? ParticipantBandKind.MIDDLE_INITIATING : ParticipantBandKind.MIDDLE_NON_INITIATING);
                bpmnShape.setParticipantBandKind(bandKind);
                ++i;
            }
            ChoreographyUtil.updateParticipantBands((IFeatureProvider)this.getFeatureProvider(), (PictogramElement)context.getPictogramElement());
        }
    }

    boolean isInitiating(ParticipantBandKind bandKind) {
        return bandKind == ParticipantBandKind.TOP_INITIATING || bandKind == ParticipantBandKind.BOTTOM_INITIATING || bandKind == ParticipantBandKind.MIDDLE_INITIATING;
    }
}

