/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core;

import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;

public class ManagedCommandLineGenerator
implements IManagedCommandLineGenerator {
    private static final String DOUBLE_QUOTE = "\"";
    private static final String WHITESPACE = " ";
    private static final String CMD_LINE_PRM_NAME = "COMMAND";
    private static final String FLAGS_PRM_NAME = "FLAGS";
    private static final String OUTPUT_FLAG_PRM_NAME = "OUTPUT_FLAG";
    private static final String OUTPUT_PREFIX_PRM_NAME = "OUTPUT_PREFIX";
    private static final String OUTPUT_PRM_NAME = "OUTPUT";
    private static final String INPUTS_PRM_NAME = "INPUTS";

    private String makeVariable(String variableName) {
        return "${" + variableName + "}";
    }

    @Override
    public IManagedCommandLineInfo generateCommandLineInfo(ITool tool, String commandName, String[] flags, String outputFlag, String outputPrefix, String outputName, String[] inputResources, String commandLinePattern) {
        if (commandLinePattern == null || commandLinePattern.length() <= 0) {
            commandLinePattern = "${COMMAND} ${FLAGS} ${OUTPUT_FLAG} ${OUTPUT_PREFIX}${OUTPUT} ${INPUTS}";
        }
        if (outputName.length() > 0 && outputName.indexOf("$(") != 0) {
            outputName = DOUBLE_QUOTE + outputName + DOUBLE_QUOTE;
        }
        String inputsStr = "";
        if (inputResources != null) {
            String[] stringArray = inputResources;
            int n = inputResources.length;
            int n2 = 0;
            while (n2 < n) {
                String inp = stringArray[n2];
                if (inp != null && !inp.isEmpty()) {
                    if (inp.indexOf("$(") != 0) {
                        inp = DOUBLE_QUOTE + inp + DOUBLE_QUOTE;
                    }
                    inputsStr = String.valueOf(inputsStr) + inp + WHITESPACE;
                }
                ++n2;
            }
            inputsStr = inputsStr.trim();
        }
        String flagsStr = this.stringArrayToString(flags);
        String command = commandLinePattern;
        command = command.replace(this.makeVariable(CMD_LINE_PRM_NAME), commandName);
        command = command.replace(this.makeVariable(FLAGS_PRM_NAME), flagsStr);
        command = command.replace(this.makeVariable(OUTPUT_FLAG_PRM_NAME), outputFlag);
        command = command.replace(this.makeVariable(OUTPUT_PREFIX_PRM_NAME), outputPrefix);
        command = command.replace(this.makeVariable(OUTPUT_PRM_NAME), outputName);
        command = command.replace(this.makeVariable(INPUTS_PRM_NAME), inputsStr);
        command = command.replace(this.makeVariable(CMD_LINE_PRM_NAME.toLowerCase()), commandName);
        command = command.replace(this.makeVariable(FLAGS_PRM_NAME.toLowerCase()), flagsStr);
        command = command.replace(this.makeVariable(OUTPUT_FLAG_PRM_NAME.toLowerCase()), outputFlag);
        command = command.replace(this.makeVariable(OUTPUT_PREFIX_PRM_NAME.toLowerCase()), outputPrefix);
        command = command.replace(this.makeVariable(OUTPUT_PRM_NAME.toLowerCase()), outputName);
        command = command.replace(this.makeVariable(INPUTS_PRM_NAME.toLowerCase()), inputsStr);
        return this.toManagedCommandLineInfo(tool, command.trim(), commandLinePattern, commandName, flags, outputFlag, outputPrefix, outputName, inputResources);
    }

    @Deprecated(since="9.2", forRemoval=true)
    protected IManagedCommandLineInfo toManagedCommandLineInfo(String commandLine, String commandLinePattern, String commandName, String[] flags, String outputFlag, String outputPrefix, String outputName, String[] inputResources) {
        throw new UnsupportedOperationException();
    }

    protected IManagedCommandLineInfo toManagedCommandLineInfo(ITool tool, final String commandLine, final String commandLinePattern, final String commandName, String[] flags, final String outputFlag, final String outputPrefix, final String outputName, String[] inputResources) {
        final String flagsStr = this.stringArrayToString(flags);
        final String inputResourcesStr = this.stringArrayToString(inputResources);
        return new IManagedCommandLineInfo(){

            @Override
            public String getCommandLine() {
                return commandLine;
            }

            @Override
            public String getCommandLinePattern() {
                return commandLinePattern;
            }

            @Override
            public String getCommandName() {
                return commandName;
            }

            @Override
            public String getFlags() {
                return flagsStr;
            }

            @Override
            public String getOutputFlag() {
                return outputFlag;
            }

            @Override
            public String getOutputPrefix() {
                return outputPrefix;
            }

            @Override
            public String getOutput() {
                return outputName;
            }

            @Override
            public String getInputs() {
                return inputResourcesStr;
            }
        };
    }

    private String stringArrayToString(String[] array) {
        if (array == null) {
            return "";
        }
        return String.join((CharSequence)WHITESPACE, array);
    }
}

