/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.harness;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.harness.FussyProgressMonitor;
import org.osgi.framework.Bundle;

public class CoreTest
extends TestCase {
    private static Boolean canCreateSymLinks;
    protected static int nextLocationCounter;
    public static final String PI_HARNESS = "org.eclipse.core.tests.harness";

    static {
        nextLocationCounter = 0;
    }

    public static void debug(String message) {
        String id = "org.eclipse.core.tests.harness/debug";
        String option = Platform.getDebugOption((String)id);
        if (Boolean.TRUE.toString().equalsIgnoreCase(option)) {
            System.out.println(message);
        }
    }

    public static void fail(String message, Throwable e) {
        if (e instanceof CoreException) {
            IStatus status = ((CoreException)e).getStatus();
            if (status.getException() == null) {
                e.printStackTrace();
            }
            CoreTest.write(status, 0);
        } else {
            e.printStackTrace();
        }
        AssertionFailedError assertFail = new AssertionFailedError(String.valueOf(message) + ": " + e);
        assertFail.initCause(e);
        throw assertFail;
    }

    private static void indent(OutputStream output, int indent) {
        int i = 0;
        while (i < indent) {
            try {
                output.write("\t".getBytes());
            }
            catch (IOException iOException) {}
            ++i;
        }
    }

    public static void log(String pluginID, IStatus status) {
        Platform.getLog((Bundle)Platform.getBundle((String)pluginID)).log(status);
    }

    public static void log(String pluginID, Throwable e) {
        CoreTest.log(pluginID, (IStatus)new Status(4, pluginID, 4, "Error", e));
    }

    private static void write(IStatus status, int indent) {
        PrintStream output = System.out;
        CoreTest.indent(output, indent);
        output.println("Severity: " + status.getSeverity());
        CoreTest.indent(output, indent);
        output.println("Plugin ID: " + status.getPlugin());
        CoreTest.indent(output, indent);
        output.println("Code: " + status.getCode());
        CoreTest.indent(output, indent);
        output.println("Message: " + status.getMessage());
        if (status.getException() != null) {
            CoreTest.indent(output, indent);
            output.print("Exception: ");
            status.getException().printStackTrace(output);
        }
        if (status.isMultiStatus()) {
            IStatus[] children;
            IStatus[] iStatusArray = children = status.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus element = iStatusArray[n2];
                CoreTest.write(element, indent + 1);
                ++n2;
            }
        }
    }

    public CoreTest() {
    }

    public CoreTest(String name) {
        super(name);
    }

    protected void assertClose(InputStream stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException e) {
            CoreTest.fail("Failed close in assertClose", e);
        }
    }

    protected void assertClose(OutputStream stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException e) {
            CoreTest.fail("Failed close in assertClose", e);
        }
    }

    protected void assertEquals(String message, Object[] expected, Object[] actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            CoreTest.fail((String)message);
        }
        if (expected.length != actual.length) {
            CoreTest.fail((String)message);
        }
        int i = 0;
        while (i < expected.length) {
            CoreTest.assertEquals((String)message, (Object)expected[i], (Object)actual[i]);
            ++i;
        }
    }

    protected void assertEquals(String message, Object[] expected, Object[] actual, boolean orderImportant) {
        if (orderImportant) {
            this.assertEquals(message, expected, actual);
            return;
        }
        if (expected == null && actual == null) {
            return;
        }
        if (expected == actual) {
            return;
        }
        if (expected == null || actual == null) {
            CoreTest.assertTrue((String)(String.valueOf(message) + ".1"), (boolean)false);
        }
        if (expected.length != actual.length) {
            CoreTest.assertTrue((String)(String.valueOf(message) + ".2"), (boolean)false);
        }
        boolean[] found = new boolean[expected.length];
        Object[] objectArray = expected;
        int n = expected.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            int j = 0;
            while (j < expected.length) {
                if (!found[j] && element.equals(actual[j])) {
                    found[j] = true;
                }
                ++j;
            }
            ++n2;
        }
        int i = 0;
        while (i < found.length) {
            if (!found[i]) {
                CoreTest.assertTrue((String)(String.valueOf(message) + ".3." + i), (boolean)false);
            }
            ++i;
        }
    }

    public void createFileInFileSystem(File file, InputStream contents) throws IOException {
        file.getParentFile().mkdirs();
        FileOutputStream output = new FileOutputStream(file);
        this.transferData(contents, output);
    }

    protected void createSymLink(File basedir, String linkName, String linkTarget, boolean isDir) {
        String[] envp = new String[]{};
        try {
            Process p;
            String[] cmd;
            if (Platform.getOS().equals("win32")) {
                if (isDir) {
                    cmd = new String[]{"cmd", "/c", "mklink", "/d", linkName, linkTarget};
                    p = Runtime.getRuntime().exec(cmd, envp, basedir);
                } else {
                    cmd = new String[]{"cmd", "/c", "mklink", linkName, linkTarget};
                    p = Runtime.getRuntime().exec(cmd, envp, basedir);
                }
            } else {
                cmd = new String[]{"ln", "-s", linkTarget, linkName};
                p = Runtime.getRuntime().exec(cmd, envp, basedir);
            }
            int exitcode = p.waitFor();
            if (exitcode != 0) {
                String result = new BufferedReader(new InputStreamReader(p.getErrorStream())).readLine();
                CoreTest.assertEquals((String)("createSymLink: " + result + ", exitcode"), (int)0, (int)exitcode);
            }
        }
        catch (IOException | InterruptedException e) {
            CoreTest.fail("createSymLink", e);
        }
    }

    protected boolean canCreateSymLinks() {
        if (canCreateSymLinks == null) {
            if (Platform.getOS().equals("win32")) {
                IPath tempDir = this.getTempDir();
                String linkName = FileSystemHelper.getRandomLocation(tempDir).lastSegment();
                try {
                    this.createSymLink(tempDir.toFile(), linkName, "testTarget", false);
                    new File(tempDir.toFile(), linkName).delete();
                    canCreateSymLinks = Boolean.TRUE;
                }
                catch (AssertionFailedError assertionFailedError) {
                    canCreateSymLinks = Boolean.FALSE;
                }
            } else {
                canCreateSymLinks = Boolean.TRUE;
            }
        }
        return canCreateSymLinks;
    }

    protected void ensureDoesNotExistInFileSystem(File file) {
        FileSystemHelper.clear(file);
    }

    public InputStream getContents(File target, String errorCode) {
        try {
            return new FileInputStream(target);
        }
        catch (IOException e) {
            CoreTest.fail(errorCode, e);
            return null;
        }
    }

    public InputStream getContents(String text) {
        return new ByteArrayInputStream(text.getBytes());
    }

    public IProgressMonitor getMonitor() {
        return new FussyProgressMonitor();
    }

    public InputStream getRandomContents() {
        return new ByteArrayInputStream(this.getRandomString().getBytes());
    }

    public IPath getRandomLocation() {
        return FileSystemHelper.getRandomLocation(this.getTempDir());
    }

    public String getRandomString() {
        switch ((int)Math.round(Math.random() * 10.0)) {
            case 0: {
                return "este e' o meu conteudo (portuguese)";
            }
            case 1: {
                return "ho ho ho";
            }
            case 2: {
                return "I'll be back";
            }
            case 3: {
                return "don't worry, be happy";
            }
            case 4: {
                return "there is no imagination for more sentences";
            }
            case 5: {
                return "Alexandre Bilodeau, Canada's first home gold. 14/02/2010";
            }
            case 6: {
                return "foo";
            }
            case 7: {
                return "bar";
            }
            case 8: {
                return "foobar";
            }
            case 9: {
                return "case 9";
            }
        }
        return "these are my contents";
    }

    public IPath getTempDir() {
        return FileSystemHelper.getTempDir();
    }

    public String getUniqueString() {
        return String.valueOf(System.currentTimeMillis()) + "-" + Math.random();
    }

    public void transferData(InputStream input, OutputStream output) {
        try {
            try {
                int c = 0;
                while ((c = input.read()) != -1) {
                    output.write(c);
                }
            }
            finally {
                input.close();
                output.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            CoreTest.assertTrue((String)e.toString(), (boolean)false);
        }
    }

    public void transferDataWithoutClose(InputStream input, OutputStream output) {
        try {
            int c = 0;
            while ((c = input.read()) != -1) {
                output.write(c);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            CoreTest.assertTrue((String)e.toString(), (boolean)false);
        }
    }

    public static void assertSame(String message, int expected, int actual) {
        if (expected == actual) {
            return;
        }
        CoreTest.failNotSame(message, expected, actual);
    }

    public static void failNotSame(String message, int expected, int actual) {
        StringBuilder formatted = new StringBuilder();
        if (message != null) {
            formatted.append(message).append(' ');
        }
        formatted.append("expected same:<").append(expected).append("> was not:<").append(actual).append(">");
        CoreTest.fail((String)String.valueOf(formatted));
    }

    public static void assertSame(String message, boolean expected, boolean actual) {
        if (expected == actual) {
            return;
        }
        CoreTest.failNotSame(message, expected, actual);
    }

    public static void failNotSame(String message, boolean expected, boolean actual) {
        StringBuilder formatted = new StringBuilder();
        if (message != null) {
            formatted.append(message).append(' ');
        }
        formatted.append("expected same:<").append(expected).append("> was not:<").append(actual).append(">");
        CoreTest.fail((String)String.valueOf(formatted));
    }

    public static void assertSame(String message, float expected, float actual) {
        if (expected == actual) {
            return;
        }
        CoreTest.failNotSame(message, expected, actual);
    }

    public static void failNotSame(String message, float expected, float actual) {
        StringBuilder formatted = new StringBuilder();
        if (message != null) {
            formatted.append(message).append(' ');
        }
        formatted.append("expected same:<").append(expected).append("> was not:<").append(actual).append(">");
        CoreTest.fail((String)String.valueOf(formatted));
    }

    public static void assertSame(String message, double expected, double actual) {
        if (expected == actual) {
            return;
        }
        CoreTest.failNotSame(message, expected, actual);
    }

    public static void failNotSame(String message, double expected, double actual) {
        StringBuilder formatted = new StringBuilder();
        if (message != null) {
            formatted.append(message).append(' ');
        }
        formatted.append("expected same:<").append(expected).append("> was not:<").append(actual).append(">");
        CoreTest.fail((String)String.valueOf(formatted));
    }

    public static void assertSame(String message, long expected, long actual) {
        if (expected == actual) {
            return;
        }
        CoreTest.failNotSame(message, expected, actual);
    }

    public static void failNotSame(String message, long expected, long actual) {
        StringBuilder formatted = new StringBuilder();
        if (message != null) {
            formatted.append(message).append(' ');
        }
        formatted.append("expected same:<").append(expected).append("> was not:<").append(actual).append(">");
        CoreTest.fail((String)String.valueOf(formatted));
    }
}

