/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.harness;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;

public class EclipseTestHarnessApplication
implements IApplication {
    protected List<String> tests = new ArrayList<String>(5);
    public static String[] args;
    private static boolean deltas;
    private static final String PI_TESTHARNESS = "org.eclipse.core.tests.harness";
    private static final String PT_TESTS = "tests";

    public static boolean deltasEnabled() {
        return deltas;
    }

    protected Object findTestFor(String testName) {
        IConfigurationElement[] elements;
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(PI_TESTHARNESS, PT_TESTS);
        IConfigurationElement[] iConfigurationElementArray = elements = point.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String id;
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals("test") && (id = element.getAttribute("id")) != null && id.equals(testName)) {
                try {
                    return element.createExecutableExtension("run");
                }
                catch (CoreException e) {
                    System.err.println("Could not instantiate test: " + testName);
                    e.printStackTrace();
                    return null;
                }
            }
            ++n2;
        }
        System.out.println("Could not find test: " + testName);
        return null;
    }

    protected String[] processCommandLine(String[] args1) {
        int[] configArgs = new int[100];
        configArgs[0] = -1;
        int configArgIndex = 0;
        int i = 0;
        while (i < args1.length) {
            boolean found = false;
            if (args1[i].equalsIgnoreCase("-deltas")) {
                found = true;
                deltas = true;
            }
            if (found) {
                configArgs[configArgIndex++] = i;
            } else if (i != args1.length - 1 && !args1[i + 1].startsWith("-")) {
                String arg = args1[++i];
                if (args1[i - 1].equalsIgnoreCase("-test")) {
                    found = true;
                    this.tests.add(arg);
                }
                if (found) {
                    configArgs[configArgIndex++] = i - 1;
                    configArgs[configArgIndex++] = i;
                }
            }
            ++i;
        }
        if (configArgIndex == 0) {
            return args1;
        }
        String[] passThruArgs = new String[args1.length - configArgIndex];
        configArgIndex = 0;
        int j = 0;
        int i2 = 0;
        while (i2 < args1.length) {
            if (i2 == configArgs[configArgIndex]) {
                ++configArgIndex;
            } else {
                passThruArgs[j++] = args1[i2];
            }
            ++i2;
        }
        return passThruArgs;
    }

    protected Object run(String testName) throws Exception {
        Object testObject = this.findTestFor(testName);
        if (testObject == null) {
            return null;
        }
        Class<?> testClass = testObject.getClass();
        Method method = testClass.getDeclaredMethod("suite", new Class[0]);
        Test suite = null;
        try {
            suite = (Test)method.invoke(testClass, new Object[0]);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw e;
        }
        this.run(suite);
        return null;
    }

    protected void run(Test suite) throws Exception {
        TestRunner.run((Test)suite);
    }

    public Object start(IApplicationContext context) throws Exception {
        args = (String[])context.getArguments().get("application.args");
        this.processCommandLine(args);
        for (String string : this.tests) {
            this.run(string);
        }
        return null;
    }

    public void stop() {
    }
}

