/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.harness;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class TestJob
extends Job {
    private int ticks;
    private long tickLength;
    private int runCount = 0;

    public TestJob(String name) {
        this(name, 10, 100L);
    }

    public TestJob(String name, int ticks, long tickDuration) {
        super(name);
        this.ticks = ticks;
        this.tickLength = tickDuration;
    }

    public synchronized int getRunCount() {
        return this.runCount;
    }

    public IStatus run(IProgressMonitor monitor) {
        this.setRunCount(this.getRunCount() + 1);
        monitor.beginTask(this.getName(), this.ticks <= 0 ? 1 : this.ticks);
        try {
            int i = 0;
            while (i < this.ticks) {
                monitor.subTask("Tick: " + i);
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                try {
                    Thread.sleep(this.tickLength);
                }
                catch (InterruptedException interruptedException) {}
                monitor.worked(1);
                ++i;
            }
            if (this.ticks <= 0) {
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    private synchronized void setRunCount(int count) {
        this.runCount = count;
    }
}

