/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.session;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ProcessController {
    private boolean finished;
    private OutputStream forwardStdErr;
    private InputStream forwardStdIn;
    private OutputStream forwardStdOut;
    private boolean killed;
    private String[] params;
    private Process process;
    private long startupTime;
    private long timeLimit;

    public ProcessController(long timeout, String[] params) {
        this.timeLimit = timeout;
        this.params = params;
    }

    private void controlProcess() {
        new Thread("Process controller"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!ProcessController.this.isFinished() && !ProcessController.this.timedOut()) {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        try {
                            this.wait(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            break;
                        }
                    }
                }
                ProcessController.this.kill();
            }
        }.start();
    }

    public int execute() throws InterruptedException, IOException, TimeOutException {
        this.startupTime = System.currentTimeMillis();
        this.process = Runtime.getRuntime().exec(this.params);
        if (this.forwardStdErr != null) {
            this.forwardStream("stderr", this.process.getErrorStream(), this.forwardStdErr);
        }
        if (this.forwardStdOut != null) {
            this.forwardStream("stdout", this.process.getInputStream(), this.forwardStdOut);
        }
        if (this.forwardStdIn != null) {
            this.forwardStream("stdin", this.forwardStdIn, this.process.getOutputStream());
        }
        if (this.timeLimit > 0L) {
            this.controlProcess();
        }
        try {
            int n = this.process.waitFor();
            return n;
        }
        finally {
            this.markFinished();
            if (this.wasKilled()) {
                throw new TimeOutException();
            }
        }
    }

    public void forwardErrorOutput(OutputStream err) {
        this.forwardStdErr = err;
    }

    public void forwardOutput(OutputStream out) {
        this.forwardStdOut = out;
    }

    private void forwardStream(String name, final InputStream in, final OutputStream out) {
        new Thread("Stream forwarder [" + name + "]"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    block5: while (true) {
                        if (ProcessController.this.isFinished()) {
                            out.flush();
                            return;
                        }
                        while (true) {
                            if (in.available() <= 0) {
                                2 var1_1 = this;
                                synchronized (var1_1) {
                                    this.wait(100L);
                                    continue block5;
                                }
                            }
                            out.write(in.read());
                        }
                        break;
                    }
                }
                catch (IOException | InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    public Process getProcess() {
        return this.process;
    }

    protected synchronized boolean isFinished() {
        return this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() {
        ProcessController processController = this;
        synchronized (processController) {
            if (this.isFinished()) {
                return;
            }
            this.killed = true;
        }
        this.process.destroy();
    }

    private synchronized void markFinished() {
        this.finished = true;
        this.notifyAll();
    }

    protected synchronized boolean timedOut() {
        return System.currentTimeMillis() - this.startupTime > this.timeLimit;
    }

    public boolean wasKilled() {
        return this.killed;
    }

    public void forwardInput(InputStream in) {
        this.forwardStdIn = in;
    }

    public static class TimeOutException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public TimeOutException() {
        }

        public TimeOutException(String message) {
            super(message);
        }
    }
}

