/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.console;

import java.util.List;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Converter;
import org.apache.felix.service.command.Descriptor;
import org.eclipse.ecf.console.AbstractCommand;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.core.identity.IIDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"osgi.command.scope=ecf", "osgi.command.function=listcontainers", "osgi.command.function=lcs", "osgi.command.function=listnamespaces", "osgi.command.function=lns", "osgi.command.function=listtypedescriptions", "osgi.command.function=lctds", "osgi.command.function=listconfigs", "osgi.command.function=lcfgs"}, service={ContainerCommand.class, Converter.class})
public class ContainerCommand
extends AbstractCommand
implements Converter {
    private IContainerManager containerManager;
    private IIDFactory idFactory;

    @Reference
    void bindContainerManager(IContainerManager cm) {
        this.containerManager = cm;
    }

    void unbindContainerManager(IContainerManager cm) {
        this.containerManager = null;
    }

    @Reference
    void bindIdentityFactory(IIDFactory idf) {
        this.idFactory = idf;
    }

    void unbindIdentityFactory(IIDFactory idf) {
        this.idFactory = null;
    }

    @Override
    protected IContainerManager getContainerManager() {
        return this.containerManager;
    }

    @Override
    protected IIDFactory getIDFactory() {
        return this.idFactory;
    }

    @Descriptor(value="List ECF container instances")
    public List<IContainer> listcontainers(CommandSession cs) {
        this.consoleLine(cs, "%1$-45s|%2$-40s|%3$s", "ID", "ImplClass", "Connected\n");
        return this.getContainers();
    }

    @Descriptor(value="List ECF container instances")
    public List<IContainer> lcs(CommandSession cs) {
        return this.listcontainers(cs);
    }

    public IContainer listcontainers(@Descriptor(value="Container ID to list (String)") IContainer container) {
        return container;
    }

    public IContainer lcs(@Descriptor(value="Container ID to list (String)") IContainer container) {
        return container;
    }

    @Descriptor(value="List ECF ID namespaces")
    public List<Namespace> listnamespaces(CommandSession cs) {
        this.consoleLine(cs, "%s", "Namespace Name\n");
        return this.getNamespaces();
    }

    @Descriptor(value="List ECF ID namespaces")
    public List<Namespace> lns(CommandSession cs) {
        return this.listnamespaces(cs);
    }

    public Namespace listnamespaces(@Descriptor(value="Namespace name to list (String)") Namespace ns) {
        return ns;
    }

    public Namespace lns(@Descriptor(value="Namespace name to list (String)") Namespace ns) {
        return ns;
    }

    @Descriptor(value="List ECF container configs")
    public List<ContainerTypeDescription> listtypedescriptions(CommandSession cs) {
        this.consoleLine(cs, "%s", "ContainerTypeDescription Name\n");
        return this.getConfigs();
    }

    @Descriptor(value="List ECF container configs")
    public List<ContainerTypeDescription> lctds(CommandSession cs) {
        return this.listtypedescriptions(cs);
    }

    @Descriptor(value="List ECF container configs")
    public List<ContainerTypeDescription> listconfigs(CommandSession cs) {
        cs.getConsole().format("%s", "Config Name\n");
        return this.getConfigs();
    }

    public List<ContainerTypeDescription> lcfgs(CommandSession cs) {
        return this.listconfigs(cs);
    }

    public ContainerTypeDescription listtypedescriptions(@Descriptor(value="Container type description name to list (String)") ContainerTypeDescription ctd) {
        return ctd;
    }

    public ContainerTypeDescription lctds(@Descriptor(value="Container type description name to list (String)") ContainerTypeDescription ctd) {
        return ctd;
    }

    public ContainerTypeDescription listconfigs(@Descriptor(value="Config name to list (String)") ContainerTypeDescription ctd) {
        return ctd;
    }

    public ContainerTypeDescription lcfgs(@Descriptor(value="Config name to list (String)") ContainerTypeDescription ctd) {
        return ctd;
    }

    public Object convert(Class<?> desiredType, Object in) throws Exception {
        if (desiredType == IContainer.class && in instanceof String) {
            return this.getContainerForId((String)in);
        }
        if (desiredType == Namespace.class && in instanceof String) {
            return this.getIDFactory().getNamespaceByName((String)in);
        }
        if (desiredType == ContainerTypeDescription.class) {
            return this.getContainerManager().getContainerFactory().getDescriptionByName((String)in);
        }
        return null;
    }

    public String format(Object target, int level, Converter escape) {
        if (target instanceof IContainer) {
            return this.formatContainer((IContainer)target, level, escape);
        }
        if (target instanceof Namespace) {
            return this.formatNamespace((Namespace)target, level, escape);
        }
        if (target instanceof ContainerTypeDescription) {
            return this.formatConfig((ContainerTypeDescription)target, level, escape);
        }
        return null;
    }
}

