/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.common.core.resource.java.Annotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.utility.Association;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.SimpleAssociation;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jpa.core.JpaFactory;
import org.eclipse.jpt.jpa.core.context.BaseColumn;
import org.eclipse.jpt.jpa.core.context.Converter;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.NamedColumn;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaBaseTemporalConverter;
import org.eclipse.jpt.jpa.core.context.java.JavaConverter;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaVersionMapping;
import org.eclipse.jpt.jpa.core.internal.context.JpaValidator;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaAttributeMapping;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.AbstractNamedColumnValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.EntityTableDescriptionProvider;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.NamedColumnValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.java.NullJavaConverter;
import org.eclipse.jpt.jpa.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.VersionAnnotation;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public abstract class AbstractJavaVersionMapping
extends AbstractJavaAttributeMapping<VersionAnnotation>
implements JavaVersionMapping {
    protected final JavaSpecifiedColumn column = this.buildColumn();
    protected JavaConverter converter = this.buildConverter();
    protected static final JavaConverter.Adapter[] CONVERTER_ADAPTER_ARRAY = new JavaConverter.Adapter[]{JavaBaseTemporalConverter.BasicAdapter.instance()};
    protected static final Iterable<JavaConverter.Adapter> CONVERTER_ADAPTERS = IterableTools.iterable((Object[])CONVERTER_ADAPTER_ARRAY);

    protected AbstractJavaVersionMapping(JavaSpecifiedPersistentAttribute parent) {
        super(parent);
    }

    @Override
    public void synchronizeWithResourceModel(IProgressMonitor monitor) {
        super.synchronizeWithResourceModel(monitor);
        this.column.synchronizeWithResourceModel(monitor);
        this.syncConverter(monitor);
    }

    @Override
    public void update(IProgressMonitor monitor) {
        super.update(monitor);
        this.column.update(monitor);
        this.converter.update(monitor);
    }

    @Override
    public JavaSpecifiedColumn getColumn() {
        return this.column;
    }

    protected JavaSpecifiedColumn buildColumn() {
        return this.getJpaFactory().buildJavaColumn(this);
    }

    @Override
    public JavaConverter getConverter() {
        return this.converter;
    }

    @Override
    public void setConverter(Class<? extends Converter> converterType) {
        if (this.converter.getConverterType() != converterType) {
            JavaConverter.Adapter converterAdapter = this.getConverterAdapter(converterType);
            this.retainConverterAnnotation(converterAdapter);
            this.setConverter_(this.buildConverter(converterAdapter));
        }
    }

    protected JavaConverter buildConverter(JavaConverter.Adapter converterAdapter) {
        return converterAdapter != null ? converterAdapter.buildNewConverter(this, this.getJpaFactory()) : this.buildNullConverter();
    }

    protected void setConverter_(JavaConverter converter) {
        JavaConverter old = this.converter;
        this.converter = converter;
        this.firePropertyChanged("converter", old, converter);
    }

    protected void retainConverterAnnotation(JavaConverter.Adapter converterAdapter) {
        JavaResourceAttribute resourceAttribute = this.getResourceAttribute();
        for (JavaConverter.Adapter adapter : this.getConverterAdapters()) {
            if (adapter == converterAdapter) continue;
            adapter.removeConverterAnnotation(resourceAttribute);
        }
    }

    protected JavaConverter buildConverter() {
        JpaFactory jpaFactory = this.getJpaFactory();
        for (JavaConverter.Adapter adapter : this.getConverterAdapters()) {
            JavaConverter javaConverter = adapter.buildConverter(this, jpaFactory);
            if (javaConverter == null) continue;
            return javaConverter;
        }
        return this.buildNullConverter();
    }

    protected void syncConverter(IProgressMonitor monitor) {
        Association<JavaConverter.Adapter, Annotation> assoc = this.getConverterAnnotation();
        if (assoc == null) {
            if (this.converter.getConverterType() != null) {
                this.setConverter_(this.buildNullConverter());
            }
        } else {
            JavaConverter.Adapter adapter = (JavaConverter.Adapter)assoc.getKey();
            Annotation annotation = (Annotation)assoc.getValue();
            if (this.converter.getConverterType() == adapter.getConverterType() && this.converter.getConverterAnnotation() == annotation) {
                this.converter.synchronizeWithResourceModel(monitor);
            } else {
                this.setConverter_(adapter.buildConverter(annotation, this, this.getJpaFactory()));
            }
        }
    }

    protected Association<JavaConverter.Adapter, Annotation> getConverterAnnotation() {
        JavaResourceAttribute resourceAttribute = this.getResourceAttribute();
        for (JavaConverter.Adapter adapter : this.getConverterAdapters()) {
            Annotation annotation = adapter.getConverterAnnotation(resourceAttribute);
            if (annotation == null) continue;
            return new SimpleAssociation((Object)adapter, (Object)annotation);
        }
        return null;
    }

    protected JavaConverter buildNullConverter() {
        return new NullJavaConverter(this);
    }

    protected JavaConverter.Adapter getConverterAdapter(Class<? extends Converter> converterType) {
        for (JavaConverter.Adapter adapter : this.getConverterAdapters()) {
            if (adapter.getConverterType() != converterType) continue;
            return adapter;
        }
        return null;
    }

    protected Iterable<JavaConverter.Adapter> getConverterAdapters() {
        return CONVERTER_ADAPTERS;
    }

    @Override
    public String getKey() {
        return "version";
    }

    @Override
    protected String getAnnotationName() {
        return "javax.persistence.Version";
    }

    @Override
    public boolean isOverridableAttributeMapping() {
        return true;
    }

    @Override
    public JpaContextModel getColumnParent() {
        return this;
    }

    @Override
    public ColumnAnnotation getColumnAnnotation() {
        return (ColumnAnnotation)this.getResourceAttribute().getNonNullAnnotation("javax.persistence.Column");
    }

    @Override
    public void removeColumnAnnotation() {
        this.getResourceAttribute().removeAnnotation("javax.persistence.Column");
    }

    @Override
    public String getDefaultColumnName(NamedColumn col) {
        return this.getName();
    }

    @Override
    public String getDefaultTableName() {
        return this.getTypeMapping().getPrimaryTableName();
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        return this.getTypeMapping().tableNameIsInvalid(tableName);
    }

    @Override
    public Iterable<String> getCandidateTableNames() {
        return this.getTypeMapping().getAllAssociatedTableNames();
    }

    @Override
    public JpaValidator buildColumnValidator(NamedColumn col) {
        return new NamedColumnValidator((PersistentAttribute)this.getPersistentAttribute(), (BaseColumn)col, (AbstractNamedColumnValidator.TableDescriptionProvider)new EntityTableDescriptionProvider());
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        result = this.column.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        result = this.converter.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        return null;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.column.validate(messages, reporter);
        this.converter.validate(messages, reporter);
        this.validateAttributeType(messages);
    }

    protected void validateAttributeType(List<IMessage> messages) {
        if (!ArrayTools.contains((Object[])SUPPORTED_TYPE_NAMES, (Object)this.getPersistentAttribute().getTypeName())) {
            if (this.getPersistentAttribute().isVirtual()) {
                messages.add(this.buildValidationMessage(this.getVirtualPersistentAttributeTextRange(), JptJpaCoreValidationMessages.PERSISTENT_ATTRIBUTE_INVALID_VERSION_MAPPING_TYPE, this.getName()));
            } else {
                messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJpaCoreValidationMessages.PERSISTENT_ATTRIBUTE_INVALID_VERSION_MAPPING_TYPE, this.getName()));
            }
        }
    }
}

