/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.editors.actions;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.EditDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.pagedesigner.editors.actions.ActionsMessages;
import org.eclipse.jst.pagedesigner.editors.actions.OutlineViewAction;
import org.eclipse.jst.pagedesigner.editors.actions.PaletteViewAction;
import org.eclipse.jst.pagedesigner.editors.actions.PropertiesViewAction;
import org.eclipse.jst.pagedesigner.parts.ElementEditPart;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.w3c.dom.Element;

public class RelatedViewActionGroup
extends ActionGroup {
    private final EditDomain _editDomain;

    public RelatedViewActionGroup(EditDomain editDomain) {
        this._editDomain = editDomain;
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        MenuManager viewMgr = new MenuManager(ActionsMessages.getString("RelatedViewActionGroup.Menu.ShowView"), "org.eclipse.jst.pagedesigner.viewMenuMgr");
        viewMgr.add((IAction)new Action(){});
        viewMgr.setRemoveAllWhenShown(true);
        final ActionContext context = this.getContext();
        viewMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                String[] views = new String[]{"org.eclipse.ui.views.PropertySheet", "org.eclipse.gef.ui.palette_view", "org.eclipse.ui.views.ContentOutline"};
                Map icons = RelatedViewActionGroup.this.getIconForView(views);
                if (manager.find("org.eclipse.jst.pagedesigner.editors.actions.PropertiesViewAction") == null) {
                    PropertiesViewAction action = new PropertiesViewAction();
                    action.setId("org.eclipse.jst.pagedesigner.editors.actions.PropertiesViewAction");
                    action.setImageDescriptor((ImageDescriptor)icons.get(views[0]));
                    manager.add((IAction)action);
                }
                ISelection selection = context.getSelection();
                if (manager.find("org.eclipse.jst.pagedesigner.editors.actions.PaletteViewAction") == null && selection instanceof IStructuredSelection) {
                    IStructuredSelection strucSelection = (IStructuredSelection)selection;
                    PaletteViewAction action = null;
                    if (strucSelection.getFirstElement() instanceof ElementEditPart) {
                        Element selectedElem = (Element)((ElementEditPart)((Object)strucSelection.getFirstElement())).getModel();
                        action = new PaletteViewAction(selectedElem, RelatedViewActionGroup.this._editDomain);
                    } else {
                        action = new PaletteViewAction(null, null);
                    }
                    action.setId("org.eclipse.jst.pagedesigner.editors.actions.PaletteViewAction");
                    action.setImageDescriptor((ImageDescriptor)icons.get(views[1]));
                    manager.add((IAction)action);
                }
                if (manager.find("org.eclipse.jst.pagedesigner.editors.actions.OutlineViewAction") == null) {
                    OutlineViewAction action = new OutlineViewAction();
                    action.setId("org.eclipse.jst.pagedesigner.editors.actions.OutlineViewAction");
                    action.setImageDescriptor((ImageDescriptor)icons.get(views[2]));
                    manager.add((IAction)action);
                }
            }
        });
        menu.appendToGroup("additions", (IContributionItem)viewMgr);
    }

    private Map getIconForView(String[] viewids) {
        List<String> views = Arrays.asList(viewids);
        HashMap<String, ImageDescriptor> icons = new HashMap<String, ImageDescriptor>();
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui.views");
        int i = 0;
        while (i < elements.length) {
            String name = elements[i].getName();
            String id = elements[i].getAttribute("id");
            if ("view".equals(name) && views.contains(id)) {
                String iconPath = elements[i].getAttribute("icon");
                if (iconPath != null) {
                    icons.put(id, AbstractUIPlugin.imageDescriptorFromPlugin((String)elements[i].getDeclaringExtension().getContributor().getName(), (String)iconPath));
                } else {
                    icons.put(id, null);
                }
                if (icons.size() == viewids.length) break;
            }
            ++i;
        }
        return icons;
    }
}

