/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.build.analysis;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.xtext.build.analysis.AnalysisUtils;
import org.eclipse.ocl.examples.xtext.build.analysis.DirectAssignmentAnalysis;
import org.eclipse.ocl.examples.xtext.build.analysis.ParserRuleAnalysis;
import org.eclipse.ocl.examples.xtext.build.analysis.SerializationRuleAnalysis;
import org.eclipse.ocl.examples.xtext.build.elements.AssignedCrossReferenceSerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.AssignedKeywordSerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.AssignedSerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.SerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.UnassignedKeywordSerializationNode;
import org.eclipse.ocl.examples.xtext.idioms.AnyAssignmentLocator;
import org.eclipse.ocl.examples.xtext.idioms.AnyElementLocator;
import org.eclipse.ocl.examples.xtext.idioms.AssignmentLocator;
import org.eclipse.ocl.examples.xtext.idioms.FinalLocator;
import org.eclipse.ocl.examples.xtext.idioms.KeywordLocator;
import org.eclipse.ocl.examples.xtext.idioms.Locator;
import org.eclipse.ocl.examples.xtext.idioms.LocatorDeclaration;
import org.eclipse.ocl.examples.xtext.idioms.ReturnsLocator;
import org.eclipse.ocl.examples.xtext.idioms.util.IdiomsSwitch;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;

public interface LocatorHelper {
    public boolean matches(@NonNull Locator var1, @NonNull AbstractElement var2, @NonNull ParserRuleAnalysis var3);

    public boolean matches(@NonNull Locator var1, @NonNull SerializationNode var2);

    public boolean matches(@NonNull Locator var1, @NonNull SerializationNode var2, @NonNull SerializationRuleAnalysis var3);

    public static abstract class AbstractLocatorHelper
    implements LocatorHelper {
        @Override
        public boolean matches(@NonNull Locator locator, @NonNull SerializationNode serializationNode) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean matches(@NonNull Locator locator, @NonNull SerializationNode serializationNode, @NonNull SerializationRuleAnalysis serializationRuleAnalysis) {
            return this.matches(locator, serializationNode);
        }
    }

    public static class AnyAssignmentLocatorHelper
    extends AbstractLocatorHelper {
        public static final @NonNull AnyAssignmentLocatorHelper INSTANCE = new AnyAssignmentLocatorHelper();

        @Override
        public boolean matches(@NonNull Locator locator, @NonNull AbstractElement grammarElement, @NonNull ParserRuleAnalysis parserRuleAnalysis) {
            return grammarElement instanceof Assignment;
        }

        @Override
        public boolean matches(@NonNull Locator locator, @NonNull SerializationNode serializationNode) {
            return serializationNode instanceof AssignedSerializationNode;
        }
    }

    public static class AnyElementLocatorHelper
    extends AbstractLocatorHelper {
        public static final @NonNull AnyElementLocatorHelper INSTANCE = new AnyElementLocatorHelper();

        @Override
        public boolean matches(@NonNull Locator locator, @NonNull AbstractElement grammarElement, @NonNull ParserRuleAnalysis parserRuleAnalysis) {
            return true;
        }

        @Override
        public boolean matches(@NonNull Locator locator, @NonNull SerializationNode serializationNode) {
            return true;
        }
    }

    public static class AssignmentLocatorHelper
    extends AbstractLocatorHelper {
        public static final @NonNull AssignmentLocatorHelper INSTANCE = new AssignmentLocatorHelper();

        @Override
        public boolean matches(@NonNull Locator locator, @NonNull AbstractElement grammarElement, @NonNull ParserRuleAnalysis parserRuleAnalysis) {
            if (grammarElement instanceof Assignment) {
                DirectAssignmentAnalysis assignmentAnalysis = parserRuleAnalysis.getGrammarAnalysis().getAssignmentAnalysis((Assignment)grammarElement);
                AssignmentLocator assignmentLocator = (AssignmentLocator)locator;
                EStructuralFeature assignedEStructuralFeature = assignmentAnalysis.getEStructuralFeature();
                return AnalysisUtils.isEqual(assignmentLocator.getEStructuralFeature(), assignedEStructuralFeature);
            }
            return false;
        }

        @Override
        public boolean matches(@NonNull Locator locator, @NonNull SerializationNode serializationNode) {
            if (serializationNode instanceof AssignedSerializationNode) {
                AssignmentLocator assignmentLocator = (AssignmentLocator)locator;
                EStructuralFeature assignedEStructuralFeature = ((AssignedSerializationNode)serializationNode).getEStructuralFeature();
                return AnalysisUtils.isEqual(assignmentLocator.getEStructuralFeature(), assignedEStructuralFeature);
            }
            return false;
        }
    }

    public static class FinalLocatorHelper
    extends AbstractLocatorHelper {
        public static final @NonNull FinalLocatorHelper INSTANCE = new FinalLocatorHelper();

        @Override
        public boolean matches(@NonNull Locator locator, @NonNull AbstractElement grammarElement, @NonNull ParserRuleAnalysis parserRuleAnalysis) {
            if (grammarElement instanceof Assignment) {
                Assignment assignment = (Assignment)grammarElement;
                if (assignment.getTerminal() instanceof CrossReference) {
                    return true;
                }
                DirectAssignmentAnalysis assignmentAnalysis = parserRuleAnalysis.getGrammarAnalysis().getAssignmentAnalysis(assignment);
                EStructuralFeature eStructuralFeature = assignmentAnalysis.getEStructuralFeature();
                if (eStructuralFeature instanceof EAttribute) {
                    return true;
                }
            } else if (grammarElement instanceof Keyword) {
                return true;
            }
            return false;
        }

        @Override
        public boolean matches(@NonNull Locator locator, @NonNull SerializationNode serializationNode) {
            if (serializationNode instanceof AssignedCrossReferenceSerializationNode) {
                return true;
            }
            if (serializationNode instanceof UnassignedKeywordSerializationNode) {
                return true;
            }
            if (serializationNode instanceof AssignedSerializationNode) {
                AssignedSerializationNode assignedSerializationNode = (AssignedSerializationNode)serializationNode;
                return assignedSerializationNode.getEStructuralFeature() instanceof EAttribute;
            }
            return false;
        }
    }

    public static class KeywordLocatorHelper
    extends AbstractLocatorHelper {
        public static final @NonNull KeywordLocatorHelper INSTANCE = new KeywordLocatorHelper();

        @Override
        public boolean matches(@NonNull Locator locator, @NonNull AbstractElement grammarElement, @NonNull ParserRuleAnalysis parserRuleAnalysis) {
            KeywordLocator keywordLocator;
            String string;
            String value = null;
            if (grammarElement instanceof Keyword) {
                value = ((Keyword)grammarElement).getValue();
            }
            return (string = (keywordLocator = (KeywordLocator)locator).getString()).equals(value);
        }

        @Override
        public boolean matches(@NonNull Locator locator, @NonNull SerializationNode serializationNode) {
            String value = null;
            if (serializationNode instanceof AssignedKeywordSerializationNode) {
                value = ((AssignedKeywordSerializationNode)serializationNode).getValue();
            } else if (serializationNode instanceof UnassignedKeywordSerializationNode) {
                value = ((UnassignedKeywordSerializationNode)serializationNode).getValue();
            }
            KeywordLocator keywordLocator = (KeywordLocator)locator;
            String string = keywordLocator.getString();
            return string.equals(value);
        }
    }

    public static class LocatorSwitch
    extends IdiomsSwitch<LocatorHelper> {
        public static final @NonNull LocatorSwitch INSTANCE = new LocatorSwitch();

        public @Nullable LocatorHelper caseAnyAssignmentLocator(AnyAssignmentLocator anyAssignmentLocator) {
            return AnyAssignmentLocatorHelper.INSTANCE;
        }

        public @Nullable LocatorHelper caseAnyElementLocator(AnyElementLocator anyElementLocator) {
            return AnyElementLocatorHelper.INSTANCE;
        }

        public @Nullable LocatorHelper caseAssignmentLocator(AssignmentLocator assignmentLocator) {
            return AssignmentLocatorHelper.INSTANCE;
        }

        public @Nullable LocatorHelper caseFinalLocator(FinalLocator finalLocator) {
            return FinalLocatorHelper.INSTANCE;
        }

        public @Nullable LocatorHelper caseKeywordLocator(KeywordLocator keywordLocator) {
            return KeywordLocatorHelper.INSTANCE;
        }

        public @Nullable LocatorHelper caseLocatorDeclaration(LocatorDeclaration locatorDeclaration) {
            return (LocatorHelper)this.doSwitch((EObject)locatorDeclaration.getOwnedLocator());
        }

        public @Nullable LocatorHelper caseReturnsLocator(ReturnsLocator producedEClassLocator) {
            return ReturnsLocatorHelper.INSTANCE;
        }

        public @Nullable LocatorHelper defaultCase(EObject object) {
            throw new UnsupportedOperationException("Missing " + ((Object)((Object)this)).getClass().getName() + " support for " + object.eClass().getName());
        }
    }

    public static class ReturnsLocatorHelper
    extends AbstractLocatorHelper {
        public static final @NonNull ReturnsLocatorHelper INSTANCE = new ReturnsLocatorHelper();

        @Override
        public boolean matches(@NonNull Locator locator, @NonNull AbstractElement grammarElement, @NonNull ParserRuleAnalysis parserRuleAnalysis) {
            if (grammarElement.eContainer() instanceof ParserRule) {
                ReturnsLocator producedEClassLocator = (ReturnsLocator)locator;
                EClass producedEClass = parserRuleAnalysis.getReturnedEClass();
                EClass eClass = producedEClassLocator.getEClass();
                if (AnalysisUtils.isSuperTypeOf(eClass, producedEClass)) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean matches(@NonNull Locator locator, @NonNull SerializationNode serializationNode, @NonNull SerializationRuleAnalysis serializationRuleAnalysis) {
            if (serializationNode == serializationRuleAnalysis.getRootSerializationNode()) {
                ReturnsLocator producedEClassLocator = (ReturnsLocator)locator;
                EClass producedEClass = serializationRuleAnalysis.getProducedEClass();
                EClass eClass = producedEClassLocator.getEClass();
                if (AnalysisUtils.isSuperTypeOf(eClass, producedEClass)) {
                    return true;
                }
            }
            return false;
        }
    }
}

