/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.FunctionExpression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.ValueReadQuery;

public class SymfowarePlatform
extends DatabasePlatform {
    public SymfowarePlatform() {
        this.pingSQL = "SELECT 1 FROM RDBII_SYSTEM.RDBII_ASSISTTABLE";
    }

    @Override
    protected void appendDate(Date date, Writer writer) throws IOException {
        writer.write("DATE'" + Helper.printDate(date) + "'");
    }

    @Override
    protected void appendTime(Time time, Writer writer) throws IOException {
        writer.write("TIME'" + Helper.printTime(time) + "'");
    }

    @Override
    protected void appendTimestamp(Timestamp timestamp, Writer writer) throws IOException {
        writer.write("TIMESTAMP'" + Helper.printTimestampWithoutNanos(timestamp) + "'");
    }

    @Override
    protected void appendCalendar(Calendar calendar, Writer writer) throws IOException {
        writer.write("TIMESTAMP'" + Helper.printCalendarWithoutNanos(calendar) + "'");
    }

    @Override
    protected Hashtable<Class<?>, FieldTypeDefinition> buildFieldTypes() {
        Hashtable fieldTypeMapping = new Hashtable();
        fieldTypeMapping.put(Boolean.class, new FieldTypeDefinition("SMALLINT default 0", false));
        fieldTypeMapping.put(Byte.class, new FieldTypeDefinition("SMALLINT", false));
        fieldTypeMapping.put(Short.class, new FieldTypeDefinition("SMALLINT", false));
        fieldTypeMapping.put(Integer.class, new FieldTypeDefinition("INTEGER", false));
        fieldTypeMapping.put(Long.class, new FieldTypeDefinition("NUMERIC", 18));
        fieldTypeMapping.put(Float.class, new FieldTypeDefinition("NUMERIC", 18, 4));
        fieldTypeMapping.put(Double.class, new FieldTypeDefinition("NUMERIC", 18, 4));
        fieldTypeMapping.put(BigDecimal.class, new FieldTypeDefinition("DECIMAL", 18).setLimits(18, -18, 18));
        fieldTypeMapping.put(BigInteger.class, new FieldTypeDefinition("NUMERIC", 18).setLimits(18, -18, 18));
        fieldTypeMapping.put(Number.class, new FieldTypeDefinition("DECIMAL", 18));
        fieldTypeMapping.put(String.class, new FieldTypeDefinition("VARCHAR", 255));
        fieldTypeMapping.put(Character.class, new FieldTypeDefinition("CHARACTER", 1));
        fieldTypeMapping.put(byte[].class, new FieldTypeDefinition("BLOB", 1024));
        fieldTypeMapping.put(Byte[].class, new FieldTypeDefinition("BLOB", 1024));
        fieldTypeMapping.put(char[].class, new FieldTypeDefinition("VARCHAR", 255));
        fieldTypeMapping.put(Character[].class, new FieldTypeDefinition("VARCHAR", 255));
        fieldTypeMapping.put(Blob.class, new FieldTypeDefinition("BLOB", 1024));
        fieldTypeMapping.put(Clob.class, new FieldTypeDefinition("VARCHAR", 255));
        fieldTypeMapping.put(Date.class, new FieldTypeDefinition("DATE", false));
        fieldTypeMapping.put(Time.class, new FieldTypeDefinition("TIME", false));
        fieldTypeMapping.put(Timestamp.class, new FieldTypeDefinition("TIMESTAMP", false));
        fieldTypeMapping.put(Calendar.class, new FieldTypeDefinition("TIMESTAMP", false));
        fieldTypeMapping.put(java.util.Date.class, new FieldTypeDefinition("TIMESTAMP", false));
        return fieldTypeMapping;
    }

    @Override
    protected Map<String, Class> buildClassTypes() {
        Map<String, Class> classTypeMapping = super.buildClassTypes();
        classTypeMapping.put("SMALLINT", Short.class);
        classTypeMapping.put("INTEGER", Integer.class);
        classTypeMapping.put("NUMERIC", Long.class);
        classTypeMapping.put("REAL", Float.class);
        classTypeMapping.put("DECIMAL", BigDecimal.class);
        classTypeMapping.put("DATE", Date.class);
        classTypeMapping.put("TIME", Time.class);
        classTypeMapping.put("TIMESTAMP", Timestamp.class);
        classTypeMapping.put("BLOB", Byte[].class);
        classTypeMapping.put("BINARY LARGE OBJECT", Byte[].class);
        classTypeMapping.put("CHARACTER", String.class);
        classTypeMapping.put("VARCHAR", String.class);
        classTypeMapping.put("CHAR VARYING", String.class);
        classTypeMapping.put("NCHAR", String.class);
        classTypeMapping.put("NCHAR VARYING", String.class);
        classTypeMapping.put("FLOAT", Double.class);
        classTypeMapping.put("DOUBLE PRECISION", Double.class);
        return classTypeMapping;
    }

    @Override
    protected void initializePlatformOperators() {
        super.initializePlatformOperators();
        this.addNonBindingOperator(ExpressionOperator.toUpperCase());
        this.addNonBindingOperator(ExpressionOperator.toLowerCase());
        this.addNonBindingOperator(ExpressionOperator.trim());
        this.addNonBindingOperator(ExpressionOperator.trim2());
        this.addNonBindingOperator(SymfowarePlatform.leftTrim());
        this.addNonBindingOperator(SymfowarePlatform.leftTrim2());
        this.addNonBindingOperator(SymfowarePlatform.rightTrim());
        this.addNonBindingOperator(SymfowarePlatform.rightTrim2());
        this.addNonBindingOperator(ExpressionOperator.ascii());
        this.addNonBindingOperator(SymfowarePlatform.charLength());
        this.addNonBindingOperator(SymfowarePlatform.length());
        this.addNonBindingOperator(ExpressionOperator.leftPad());
        this.addNonBindingOperator(ExpressionOperator.rightPad());
        this.addOperator(SymfowarePlatform.substring());
        this.addOperator(SymfowarePlatform.singleArgumentSubstring());
        this.addOperator(SymfowarePlatform.toNumber());
        this.addOperator(SymfowarePlatform.locate());
        this.addOperator(SymfowarePlatform.locate2());
        this.addOperator(SymfowarePlatform.instring());
        this.addOperator(ExpressionOperator.simpleLogicalNoParens(31, "||"));
        this.addOperator(ExpressionOperator.simpleFunction(48, "CNV_CHAR"));
        this.addOperator(SymfowarePlatform.monthsBetween());
        this.addOperator(SymfowarePlatform.roundDate());
        this.addOperator(SymfowarePlatform.toDate());
        this.addOperator(SymfowarePlatform.addDate());
        this.addOperator(SymfowarePlatform.truncateDate());
        this.addNonBindingOperator(ExpressionOperator.ceil());
        this.addNonBindingOperator(ExpressionOperator.floor());
        this.addNonBindingOperator(SymfowarePlatform.greatest());
        this.addNonBindingOperator(SymfowarePlatform.least());
        this.addOperator(SymfowarePlatform.logOperator());
        this.addOperator(SymfowarePlatform.mod());
        this.addOperator(ExpressionOperator.simpleTwoArgumentFunction(91, "ATAN2"));
        this.addNonBindingOperator(ExpressionOperator.coalesce());
        this.addNonBindingOperator(ExpressionOperator.nullIf());
        this.addNonBindingOperator(ExpressionOperator.isNull());
        this.addNonBindingOperator(ExpressionOperator.notNull());
        this.addNonBindingOperator(SymfowarePlatform.nvl());
    }

    protected void addNonBindingOperator(ExpressionOperator operator) {
        operator.setIsBindingSupported(false);
        this.addOperator(operator);
    }

    @Override
    public boolean isDynamicSQLRequiredForFunctions() {
        return true;
    }

    @Override
    public boolean isForUpdateCompatibleWithDistinct() {
        return false;
    }

    @Override
    public boolean isSymfoware() {
        return true;
    }

    protected static ExpressionOperator length() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setSelector(46);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(2);
        ((Vector)v).addElement("CHAR_LENGTH(");
        ((Vector)v).addElement(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    protected static ExpressionOperator charLength() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setSelector(97);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(2);
        ((Vector)v).addElement("CHAR_LENGTH(");
        ((Vector)v).addElement(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    protected static ExpressionOperator locate() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setSelector(112);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(3);
        ((Vector)v).addElement("POSITION(");
        ((Vector)v).addElement(" IN ");
        ((Vector)v).addElement(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        int[] nArray = new int[2];
        nArray[0] = 1;
        int[] indices = nArray;
        exOperator.setArgumentIndices(indices);
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    protected static ExpressionOperator locate2() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setSelector(113);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(4);
        ((Vector)v).addElement("POSITION(");
        ((Vector)v).addElement(" IN ");
        ((Vector)v).addElement(",");
        ((Vector)v).addElement(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[2] = 2;
        int[] indices = nArray;
        exOperator.setArgumentIndices(indices);
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    protected static ExpressionOperator logOperator() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setSelector(66);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(2);
        ((Vector)v).addElement("(LN(");
        ((Vector)v).addElement(")/LN(10))");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(FunctionExpression.class);
        return exOperator;
    }

    protected static ExpressionOperator leftTrim() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setSelector(37);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(2);
        ((Vector)v).addElement("TRIM(LEADING FROM ");
        ((Vector)v).addElement(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    protected static ExpressionOperator leftTrim2() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setSelector(122);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(3);
        ((Vector)v).addElement("TRIM(LEADING ");
        ((Vector)v).addElement(" FROM ");
        ((Vector)v).addElement(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        int[] nArray = new int[2];
        nArray[0] = 1;
        int[] indices = nArray;
        exOperator.setArgumentIndices(indices);
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    protected static ExpressionOperator mod() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setSelector(67);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(7);
        ((Vector)v).addElement("(CASE WHEN ");
        ((Vector)v).addElement(" = 0 THEN ");
        ((Vector)v).addElement(" ELSE (");
        ((Vector)v).addElement(" - ");
        ((Vector)v).addElement(" * TRUNC( ");
        ((Vector)v).addElement(" / ");
        ((Vector)v).addElement(")) END)");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        int[] nArray = new int[6];
        nArray[0] = 1;
        nArray[3] = 1;
        nArray[5] = 1;
        int[] indices = nArray;
        exOperator.setArgumentIndices(indices);
        exOperator.setNodeClass(FunctionExpression.class);
        return exOperator;
    }

    protected static ExpressionOperator rightTrim() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setSelector(40);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(2);
        ((Vector)v).addElement("TRIM(TRAILING FROM ");
        ((Vector)v).addElement(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    protected static ExpressionOperator rightTrim2() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setSelector(116);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(3);
        ((Vector)v).addElement("TRIM(TRAILING ");
        ((Vector)v).addElement(" FROM ");
        ((Vector)v).addElement(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        int[] nArray = new int[2];
        nArray[0] = 1;
        int[] indices = nArray;
        exOperator.setArgumentIndices(indices);
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    protected static ExpressionOperator substring() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setSelector(41);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(4);
        ((Vector)v).addElement("SUBSTRING(");
        ((Vector)v).addElement(" FROM ");
        ((Vector)v).addElement(" FOR ");
        ((Vector)v).addElement(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    protected static ExpressionOperator singleArgumentSubstring() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setSelector(133);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(3);
        ((Vector)v).addElement("SUBSTRING(");
        ((Vector)v).addElement(" FROM ");
        ((Vector)v).addElement(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    protected static ExpressionOperator toNumber() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setSelector(42);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(2);
        ((Vector)v).addElement("CAST(");
        ((Vector)v).addElement(" AS SMALLINT)");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    protected static ExpressionOperator instring() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setSelector(34);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(3);
        ((Vector)v).addElement("POSITION(");
        ((Vector)v).addElement(" IN ");
        ((Vector)v).addElement(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        int[] nArray = new int[2];
        nArray[0] = 1;
        int[] indices = nArray;
        exOperator.setArgumentIndices(indices);
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    protected static ExpressionOperator monthsBetween() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setSelector(50);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(3);
        ((Vector)v).addElement("SPAN_DATE(");
        ((Vector)v).addElement(" , ");
        ((Vector)v).addElement(",'MONTH')");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    protected static ExpressionOperator roundDate() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setSelector(52);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(3);
        ((Vector)v).addElement("ROUND_DATE(");
        ((Vector)v).addElement(" , ");
        ((Vector)v).addElement(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    protected static ExpressionOperator toDate() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setSelector(53);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(2);
        ((Vector)v).addElement("CNV_DATE(");
        ((Vector)v).addElement(", 'YYYY-MM-DD')");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    protected static ExpressionOperator addDate() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setSelector(90);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(4);
        ((Vector)v).addElement("ADD_DATE(");
        ((Vector)v).addElement(", ");
        ((Vector)v).addElement(", '");
        ((Vector)v).addElement("')");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        int[] indices = new int[]{0, 2, 1};
        exOperator.setArgumentIndices(indices);
        return exOperator;
    }

    protected static ExpressionOperator truncateDate() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setSelector(102);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(3);
        ((Vector)v).addElement("TRUNC_DATE(");
        ((Vector)v).addElement(",");
        ((Vector)v).addElement(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    protected static ExpressionOperator nvl() {
        return ExpressionOperator.simpleTwoArgumentFunction(104, "COALESCE");
    }

    protected static ExpressionOperator greatest() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(76);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(5);
        ((Vector)v).addElement("(CASE WHEN ");
        ((Vector)v).addElement(" >= ");
        ((Vector)v).addElement(" THEN ");
        ((Vector)v).addElement(" ELSE ");
        ((Vector)v).addElement(" END)");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[3] = 1;
        int[] indices = nArray;
        exOperator.setArgumentIndices(indices);
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    protected static ExpressionOperator least() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(77);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(5);
        ((Vector)v).addElement("(CASE WHEN ");
        ((Vector)v).addElement(" <= ");
        ((Vector)v).addElement(" THEN ");
        ((Vector)v).addElement(" ELSE ");
        ((Vector)v).addElement(" END)");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[3] = 1;
        int[] indices = nArray;
        exOperator.setArgumentIndices(indices);
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    @Override
    public int computeMaxRowsForSQL(int firstResultIndex, int maxResults) {
        return maxResults;
    }

    @Override
    public ValueReadQuery buildSelectQueryForSequenceObject(String seqName, Integer size) {
        return new ValueReadQuery("SELECT " + this.getQualifiedName(seqName) + ".NEXTVAL FROM RDBII_SYSTEM.RDBII_ASSISTTABLE");
    }

    @Override
    public String buildCreateIndex(String fullTableName, String indexName, String qualifier, boolean isUnique, String ... columnNames) {
        StringBuilder queryString = new StringBuilder();
        queryString.append("CREATE INDEX ");
        queryString.append(fullTableName).append(".").append(indexName).append(" KEY (");
        queryString.append(columnNames[0]);
        int i = 1;
        while (i < columnNames.length) {
            queryString.append(", ").append(columnNames[i]);
            ++i;
        }
        queryString.append(")");
        return queryString.toString();
    }

    @Override
    public String buildDropIndex(String fullTableName, String indexName, String qualifier) {
        StringBuilder queryString = new StringBuilder();
        queryString.append("DROP INDEX ").append(fullTableName).append(".").append(indexName);
        return queryString.toString();
    }

    @Override
    public String getCreateTempTableSqlPrefix() {
        return "CREATE GLOBAL TEMPORARY TABLE ";
    }

    @Override
    protected String getCreateTempTableSqlSuffix() {
        return super.getCreateTempTableSqlSuffix();
    }

    @Override
    public String getDefaultSequenceTableName() {
        return "\"SEQUENCE\"";
    }

    @Override
    public String getIndexNamePrefix(boolean isUniqueSetOnField) {
        if (isUniqueSetOnField) {
            return "UIX_";
        }
        return super.getIndexNamePrefix(isUniqueSetOnField);
    }

    @Override
    public String getInOutputProcedureToken() {
        return "INOUT";
    }

    @Override
    public String getInputProcedureToken() {
        return "IN";
    }

    @Override
    public int getMaxFieldNameSize() {
        return 36;
    }

    @Override
    public String getProcedureAsString() {
        return "";
    }

    @Override
    public String getProcedureCallHeader() {
        return "{CALL ";
    }

    @Override
    public String getProcedureCallTail() {
        return "}";
    }

    @Override
    public String getProcedureBeginString() {
        return "BEGIN";
    }

    @Override
    public String getProcedureEndString() {
        return "END";
    }

    @Override
    public String getSelectForUpdateString() {
        return " FOR UPDATE";
    }

    @Override
    public ValueReadQuery getTimestampQuery() {
        if (this.timestampQuery == null) {
            this.timestampQuery = new ValueReadQuery();
            this.timestampQuery.setSQLString("SELECT CURRENT_TIMESTAMP FROM RDBII_SYSTEM.RDBII_ASSISTTABLE");
            this.timestampQuery.setAllowNativeSQLQuery(true);
        }
        return this.timestampQuery;
    }

    @Override
    public long minimumTimeIncrement() {
        return 1000L;
    }

    @Override
    public void printSQLSelectStatement(DatabaseCall call, ExpressionSQLPrinter printer, SQLSelectStatement statement) {
        int max = 0;
        if (statement.getQuery() != null) {
            max = statement.getQuery().getMaxRows();
        }
        if (max > 0 && this.shouldUseRownumFiltering()) {
            statement.setUseUniqueFieldAliases(true);
            call.setFields(statement.printSQL(printer));
            printer.printString(" WITH OPTION LIMIT (");
            printer.printParameter(DatabaseCall.MAXROW_FIELD);
            printer.printString(")");
            call.setIgnoreMaxResultsSetting(true);
        } else {
            super.printSQLSelectStatement(call, printer, statement);
        }
    }

    @Override
    public boolean requiresProcedureBrackets() {
        return true;
    }

    @Override
    public boolean requiresUniqueConstraintCreationOnTableCreate() {
        return true;
    }

    @Override
    public void retrieveFirstPrimaryKeyOrOne(ReportQuery subselect) {
        subselect.selectValue1();
    }

    @Override
    public boolean shouldAlwaysUseTempStorageForModifyAll() {
        return false;
    }

    @Override
    public boolean shouldBindLiterals() {
        return false;
    }

    @Override
    public boolean shouldCreateIndicesForPrimaryKeys() {
        return true;
    }

    @Override
    public boolean shouldCreateIndicesOnUniqueKeys() {
        return true;
    }

    @Override
    public boolean shouldPrintInputTokenAtStart() {
        return true;
    }

    @Override
    public boolean shouldPrintOutputTokenBeforeType() {
        return true;
    }

    @Override
    public boolean shouldPrintOutputTokenAtStart() {
        return true;
    }

    @Override
    public boolean shouldPrintStoredProcedureArgumentNameInCall() {
        return false;
    }

    @Override
    public boolean shouldPrintStoredProcedureVariablesAfterBeginString() {
        return true;
    }

    @Override
    public boolean supportsANSIInnerJoinSyntax() {
        return false;
    }

    @Override
    public boolean supportsForeignKeyConstraints() {
        return false;
    }

    @Override
    public boolean supportsGlobalTempTables() {
        return false;
    }

    @Override
    public boolean supportsIndividualTableLocking() {
        return false;
    }

    @Override
    public boolean supportsLockingQueriesWithMultipleTables() {
        return false;
    }

    @Override
    public boolean supportsSequenceObjects() {
        return true;
    }

    @Override
    public boolean supportsStoredFunctions() {
        return false;
    }

    @Override
    public boolean supportsUniqueKeyConstraints() {
        return true;
    }

    @Override
    public boolean wasFailureCommunicationBased(SQLException exception, Connection connection, AbstractSession sessionForProfile) {
        return false;
    }
}

