/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.lexer.Terminal;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTCallStmtNode;
import org.eclipse.photran.internal.core.parser.ASTSeparatedListNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineArgNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineParNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineStmtNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineSubprogramNode;
import org.eclipse.photran.internal.core.parser.IASTNode;
import org.eclipse.photran.internal.core.refactoring.Messages;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranEditorRefactoring;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.photran.internal.core.vpg.refactoring.VPGRefactoring;

public class PermuteSubroutineArgsRefactoring
extends FortranEditorRefactoring {
    private ASTSubroutineStmtNode selectedSubroutine;
    private List<ASTSubroutineParNode> oldParameterList;
    private List<ASTSubroutineParNode> newParameterList;
    private List<Integer> sigma;

    @Override
    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        IASTNode temporaryNode;
        this.ensureProjectHasRefactoringEnabled(status);
        this.newParameterList = new ArrayList<ASTSubroutineParNode>();
        if (this.sigma == null) {
            this.sigma = new ArrayList<Integer>();
        }
        if ((temporaryNode = PermuteSubroutineArgsRefactoring.findEnclosingNode(this.astOfFileInEditor, this.selectedRegionInEditor)) == null) {
            this.fail(Messages.PermuteSubroutineArgsRefactoring_selectedTextNotSubroutine);
        }
        if (temporaryNode instanceof ASTSubroutineSubprogramNode) {
            this.selectedSubroutine = ((ASTSubroutineSubprogramNode)temporaryNode).getSubroutineStmt();
        } else if (temporaryNode instanceof ASTSubroutineStmtNode) {
            if (temporaryNode.findNearestAncestor(ASTSubroutineSubprogramNode.class) == null) {
                this.fail(Messages.PermuteSubroutineArgsRefactoring_selectSubroutineError);
            }
            this.selectedSubroutine = (ASTSubroutineStmtNode)temporaryNode;
        } else {
            this.fail(Messages.PermuteSubroutineArgsRefactoring_selectedTextNotSubroutine);
        }
        this.oldParameterList = this.getSubroutineParameters();
        this.newParameterList = this.getSubroutineParameters();
        if (!this.matchingDeclarationsInInterfacesUniquelyBind()) {
            status.addWarning(Messages.PermuteSubroutineArgsRefactoring_matchingDeclarationsDoNotUniquelyBind);
        }
    }

    @Override
    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
    }

    @Override
    protected void doCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        this.buildNewParameterListFromSigma();
        this.permuteDummyArguments(this.selectedSubroutine);
        this.permuteCallSites();
        this.permuteSubroutineInInterfaceBlocks();
        this.addChangeFromModifiedAST(this.fileInEditor, pm);
        ((PhotranVPG)this.vpg).releaseAST(this.fileInEditor);
    }

    public void setSigma(List<Integer> sigma) {
        this.sigma = sigma;
    }

    public void buildNewParameterListFromSigma() {
        this.newParameterList = new ArrayList<ASTSubroutineParNode>();
        for (int i : this.sigma) {
            this.newParameterList.add(this.oldParameterList.get(i));
        }
    }

    protected void permuteDummyArguments(ASTSubroutineStmtNode node) {
        ASTSeparatedListNode<ASTSubroutineParNode> newParameterList = new ASTSeparatedListNode<ASTSubroutineParNode>(new Token(Terminal.T_COMMA, ","), this.newParameterList);
        node.setSubroutinePars(newParameterList);
    }

    private void permuteCallSites() {
        for (ASTCallStmtNode callStmt : this.getCallSites()) {
            int m = 0;
            if (callStmt.getArgList() != null) {
                m = callStmt.getArgList().size();
            }
            boolean K = false;
            ArrayList<ASTSubroutineArgNode> L_prime = new ArrayList<ASTSubroutineArgNode>();
            for (int i : this.sigma) {
                ASTSubroutineParNode desiredPar = this.oldParameterList.get(i);
                ASTSubroutineArgNode A_i = this.getActualArgFromCallStmt(callStmt, desiredPar.getVariableName(), i);
                if (i > m) {
                    K = true;
                }
                if (A_i == null) continue;
                if (A_i.getName() != null) {
                    K = true;
                }
                if (!K || A_i.getName() != null) {
                    L_prime.add(A_i);
                }
                if (!K || A_i.getName() != null) continue;
                A_i.setName(new Token(Terminal.T_IDENT, desiredPar.getVariableName().getText()));
                L_prime.add(A_i);
            }
            ASTSeparatedListNode<ASTSubroutineArgNode> newArgList = new ASTSeparatedListNode<ASTSubroutineArgNode>(new Token(Terminal.T_COMMA, ","), L_prime);
            callStmt.setArgList(newArgList);
        }
    }

    private ASTSubroutineArgNode getActualArgFromCallStmt(ASTCallStmtNode callStmt, Token desiredParName, int desiredParIndex) {
        int i = 0;
        while (i < callStmt.getArgList().size()) {
            String parameterName;
            String argumentName;
            ASTSubroutineArgNode argument = (ASTSubroutineArgNode)callStmt.getArgList().get(i);
            if (argument.getName() == null || desiredParName == null ? i == desiredParIndex : (argumentName = PhotranVPG.canonicalizeIdentifier(argument.getName().getText())).equals(parameterName = PhotranVPG.canonicalizeIdentifier(desiredParName.getText()))) {
                return argument;
            }
            ++i;
        }
        return null;
    }

    private void permuteSubroutineInInterfaceBlocks() {
        for (Definition declaration : this.getInterfaceDeclarations()) {
            ASTSubroutineStmtNode subroutineStmt = declaration.getTokenRef().findToken().findNearestAncestor(ASTSubroutineStmtNode.class);
            if (subroutineStmt == null || subroutineStmt.getSubroutinePars() == null || subroutineStmt.getSubroutinePars().size() != this.newParameterList.size()) continue;
            this.permuteDummyArguments(subroutineStmt);
        }
    }

    private Collection<Definition> getInterfaceDeclarations() {
        List<Definition> subroutineDefinitions = this.selectedSubroutine.getSubroutineName().getSubroutineName().resolveBinding();
        if (subroutineDefinitions.size() != 1) {
            return new ArrayList<Definition>();
        }
        return subroutineDefinitions.get(0).findMatchingDeclarationsInInterfaces();
    }

    private boolean matchingDeclarationsInInterfacesUniquelyBind() {
        for (Definition declaration : this.getInterfaceDeclarations()) {
            if (declaration.resolveInterfaceBinding().size() == 1) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getName() {
        return Messages.PermuteSubroutineArgsRefactoring_name;
    }

    public List<ASTSubroutineParNode> getSubroutineParameters() {
        if (this.selectedSubroutine.getSubroutinePars() != null) {
            return this.selectedSubroutine.getSubroutinePars();
        }
        return new ArrayList<ASTSubroutineParNode>();
    }

    private Set<ASTCallStmtNode> getCallSites() {
        List<Definition> subroutineDefinitions = this.selectedSubroutine.getSubroutineName().getSubroutineName().resolveBinding();
        HashSet<ASTCallStmtNode> result = new HashSet<ASTCallStmtNode>();
        if (subroutineDefinitions.size() != 1) {
            return result;
        }
        for (PhotranTokenRef tokenRef : subroutineDefinitions.get(0).findAllReferences(true)) {
            Token token = tokenRef.findToken();
            ASTCallStmtNode callStmtNode = token.findNearestAncestor(ASTCallStmtNode.class);
            if (callStmtNode == null) continue;
            result.add(callStmtNode);
        }
        return result;
    }

    public boolean isUsedWithKeywordInCallStmt(ASTSubroutineParNode parameterNode) {
        for (ASTCallStmtNode callStmtNode : this.getCallSites()) {
            for (ASTSubroutineArgNode argument : callStmtNode.getArgList()) {
                String parameterName;
                String argumentName;
                if (argument.getName() == null || parameterNode.getVariableName() == null || !(argumentName = PhotranVPG.canonicalizeIdentifier(argument.getName().getText())).equals(parameterName = PhotranVPG.canonicalizeIdentifier(parameterNode.getVariableName().getText()))) continue;
                return true;
            }
        }
        return false;
    }
}

