/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.php.internal.core.preferences.IPreferencesPropagatorListener;

public abstract class AbstractPreferencesPropagator {
    protected Map<String, List<IPreferencesPropagatorListener>> listenersMap;
    protected boolean isInstalled;
    protected Object lock = new Object();

    public void addPropagatorListener(IPreferencesPropagatorListener listener, String preferencesKey) {
        List<IPreferencesPropagatorListener> list = this.listenersMap.get(preferencesKey);
        if (list == null) {
            list = new ArrayList<IPreferencesPropagatorListener>(5);
            this.listenersMap.put(preferencesKey, list);
        }
        if (!list.contains(listener)) {
            list.add(listener);
        }
    }

    public void removePropagatorListener(IPreferencesPropagatorListener listener, String preferencesKey) {
        List<IPreferencesPropagatorListener> list = this.listenersMap.get(preferencesKey);
        if (list != null) {
            list.remove(listener);
        }
    }

    public void setPropagatorListeners(List<IPreferencesPropagatorListener> listeners, String preferencesKey) {
        this.listenersMap.put(preferencesKey, listeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<IPreferencesPropagatorListener> getPropagatorListeners(String preferencesKey) {
        Object object = this.lock;
        synchronized (object) {
            return this.listenersMap.get(preferencesKey);
        }
    }

    protected synchronized void install() {
        if (this.isInstalled) {
            return;
        }
        this.listenersMap = new HashMap<String, List<IPreferencesPropagatorListener>>();
        this.isInstalled = true;
    }

    protected synchronized void uninstall() {
        if (!this.isInstalled) {
            return;
        }
        this.listenersMap = null;
        this.isInstalled = false;
    }
}

