/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.tcf.core.util.persistence.PeerDataHelper;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelLookupService;
import org.eclipse.tcf.te.tcf.locator.services.AbstractLocatorModelService;

public class LocatorModelLookupService
extends AbstractLocatorModelService
implements ILocatorModelLookupService {
    public LocatorModelLookupService(ILocatorModel parentModel) {
        super(parentModel);
    }

    @Override
    public IPeer lkupPeerById(String id) {
        Assert.isNotNull((Object)id);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        IPeer node = null;
        IPeer[] iPeerArray = this.getLocatorModel().getPeers();
        int n = iPeerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPeer peer = iPeerArray[n2];
            if (id.equals(peer.getID())) {
                node = peer;
                break;
            }
            ++n2;
        }
        return node;
    }

    @Override
    public IPeer[] lkupPeerByAgentId(String agentId) {
        Assert.isNotNull((Object)agentId);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        ArrayList<IPeer> nodes = new ArrayList<IPeer>();
        IPeer[] iPeerArray = this.getLocatorModel().getPeers();
        int n = iPeerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPeer peer = iPeerArray[n2];
            if (agentId.equals(peer.getAgentID())) {
                nodes.add(peer);
            }
            ++n2;
        }
        return nodes.toArray(new IPeer[nodes.size()]);
    }

    @Override
    public IPeer[] lkupPeerByName(String name) {
        Assert.isNotNull((Object)name);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        ArrayList<IPeer> nodes = new ArrayList<IPeer>();
        IPeer[] iPeerArray = this.getLocatorModel().getPeers();
        int n = iPeerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPeer peer = iPeerArray[n2];
            if (name.equals(peer.getName())) {
                nodes.add(peer);
            }
            ++n2;
        }
        return nodes.toArray(new IPeer[nodes.size()]);
    }

    @Override
    public ILocatorNode[] lkupLocatorNodeById(ILocatorNode parent, String id) {
        Assert.isNotNull((Object)id);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        List<ILocatorNode> locatorNodes = parent != null ? parent.getChildren(ILocatorNode.class) : Arrays.asList(this.getLocatorModel().getLocatorNodes());
        ArrayList<ILocatorNode> nodes = new ArrayList<ILocatorNode>();
        for (ILocatorNode node : locatorNodes) {
            if (!id.equals(node.getPeer().getID())) continue;
            nodes.add(node);
        }
        return nodes.toArray(new ILocatorNode[nodes.size()]);
    }

    @Override
    public ILocatorNode[] lkupLocatorNodeByAgentId(ILocatorNode parent, String agentId) {
        Assert.isNotNull((Object)agentId);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        List<ILocatorNode> locatorNodes = parent != null ? parent.getChildren(ILocatorNode.class) : Arrays.asList(this.getLocatorModel().getLocatorNodes());
        ArrayList<ILocatorNode> nodes = new ArrayList<ILocatorNode>();
        for (ILocatorNode node : locatorNodes) {
            String nodeAgentId = node.getPeer().getAgentID();
            if (nodeAgentId == null) {
                nodeAgentId = node.getStringProperty("AgentID");
            }
            if (!agentId.equals(nodeAgentId)) continue;
            nodes.add(node);
        }
        return nodes.toArray(new ILocatorNode[nodes.size()]);
    }

    @Override
    public ILocatorNode lkupLocatorNode(IPeer peer) {
        Assert.isNotNull((Object)peer);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        String encProxies = (String)peer.getAttributes().get("Proxies");
        IPeer[] proxies = PeerDataHelper.decodePeerList((String)encProxies);
        ILocatorNode parent = null;
        IPeer[] iPeerArray = proxies;
        int n = proxies.length;
        int n2 = 0;
        while (n2 < n) {
            IPeer proxy = iPeerArray[n2];
            String agentId = proxy.getAgentID();
            String id = proxy.getID();
            ILocatorNode[] nodes = null;
            if (agentId != null) {
                nodes = this.lkupLocatorNodeByAgentId(parent, agentId);
            }
            if ((nodes == null || nodes.length == 0) && id != null) {
                nodes = this.lkupLocatorNodeById(parent, id);
            }
            if (nodes == null || nodes.length <= 0) {
                parent = null;
                break;
            }
            parent = nodes[0];
            ++n2;
        }
        String agentId = peer.getAgentID();
        String id = peer.getID();
        ILocatorNode[] nodes = null;
        if (agentId != null) {
            nodes = this.lkupLocatorNodeByAgentId(parent, agentId);
        }
        if ((nodes == null || nodes.length == 0) && id != null) {
            nodes = this.lkupLocatorNodeById(parent, id);
        }
        if (nodes != null && nodes.length > 0) {
            return nodes[0];
        }
        return null;
    }
}

