/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.repo;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.actions.CVSAction;

public class AddToBranchAction
extends CVSAction {
    IInputValidator validator = newText -> {
        IStatus status = CVSTag.validateTagName((String)newText);
        if (status.isOK()) {
            return null;
        }
        return status.getMessage();
    };

    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
        this.run(monitor -> {
            ICVSRemoteFolder folder = this.getSelectedRootFolder();
            if (folder == null) {
                return;
            }
            Shell shell = this.getShell();
            CVSException[] exception = new CVSException[1];
            shell.getDisplay().syncExec(() -> {
                InputDialog dialog = new InputDialog(this.getShell(), CVSUIMessages.AddToBranchAction_enterTag, CVSUIMessages.AddToBranchAction_enterTagLong, null, this.validator);
                if (dialog.open() == 0) {
                    CVSTag tag = new CVSTag(dialog.getValue(), 1);
                    try {
                        CVSUIPlugin.getPlugin().getRepositoryManager().addTags((ICVSResource)folder, new CVSTag[]{tag});
                    }
                    catch (CVSException e) {
                        cVSExceptionArray[0] = e;
                    }
                }
            });
            if (exception[0] != null) {
                throw new InvocationTargetException(exception[0]);
            }
        }, false, 2);
    }

    @Override
    public boolean isEnabled() {
        return this.getSelectedRootFolder() != null;
    }

    protected ICVSRemoteFolder getSelectedRootFolder() {
        ICVSRemoteFolder[] folders = this.getSelectedRemoteFolders();
        ICVSRemoteFolder selectedFolder = null;
        ICVSRemoteFolder[] iCVSRemoteFolderArray = folders;
        int n = folders.length;
        int n2 = 0;
        while (n2 < n) {
            ICVSRemoteFolder folder = iCVSRemoteFolderArray[n2];
            if (folder.isDefinedModule() || new Path(null, folder.getRepositoryRelativePath()).segmentCount() == 1) {
                if (selectedFolder != null) {
                    return null;
                }
                selectedFolder = folder;
            }
            ++n2;
        }
        return selectedFolder;
    }
}

