/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.eresource.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.eresource.impl.CDOResourceLeafImpl;
import org.eclipse.emf.cdo.eresource.impl.CDOResourceNodeImpl;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOModificationTrackingAdapter;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.cdo.view.CDOViewProvider;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.NotificationChainImpl;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.notify.impl.NotifyingListImpl;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EStoreEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.DOMHandler;
import org.eclipse.emf.ecore.xmi.DOMHelper;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMIHelperImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.internal.cdo.view.CDOStateMachine;
import org.eclipse.emf.spi.cdo.FSMUtil;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOResource;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.emf.spi.cdo.InternalCDOViewSet;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.transaction.TransactionException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class CDOResourceImpl
extends CDOResourceLeafImpl
implements InternalCDOResource {
    private static final EReference CDO_RESOURCE_CONTENTS = EresourcePackage.eINSTANCE.getCDOResource_Contents();
    private boolean root;
    private URI initialURI;
    private URI uri;
    private boolean existing;
    private boolean loading;
    private boolean loaded;
    private boolean modified;
    private EList<Resource.Diagnostic> errors;
    private EList<Resource.Diagnostic> warnings;
    private transient CDOViewProvider viewProvider;
    private transient Map<String, EObject> intrinsicIDToEObjectMap;
    private transient AtomicInteger loadingCounter = new AtomicInteger();

    public CDOResourceImpl(URI initialURI) {
        this.initialURI = initialURI;
    }

    protected CDOResourceImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return EresourcePackage.Literals.CDO_RESOURCE;
    }

    @Override
    public Resource.Internal eDirectResource() {
        if (this.isRoot()) {
            return this;
        }
        return super.eDirectResource();
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == CDOResource.class) {
            return baseFeatureID;
        }
        if (baseClass == Resource.class) {
            return baseFeatureID + 3;
        }
        return super.eBaseStructuralFeatureID(baseFeatureID, baseClass);
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == CDOResource.class) {
            return derivedFeatureID;
        }
        if (baseClass == Resource.class) {
            return derivedFeatureID - 3;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    @Override
    public boolean isRoot() {
        return this.root;
    }

    public void setRoot(boolean root) {
        this.root = root;
    }

    @Override
    public ResourceSet getResourceSet() {
        return (ResourceSet)this.eGet((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE__RESOURCE_SET, true);
    }

    @Override
    public void setResourceSet(ResourceSet newResourceSet) {
        this.eSet((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE__RESOURCE_SET, newResourceSet);
    }

    public URI getURIGen() {
        return (URI)this.eGet((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE__URI, true);
    }

    @Override
    public URI getURI() {
        if (this.uri == null) {
            this.uri = this.normalizeURI(this.doGetURI());
        }
        return this.uri;
    }

    private URI doGetURI() {
        String path;
        URI uri;
        InternalCDOView view;
        if (this.initialURI != null && ((view = this.cdoView()) == null || view.isClosed() || this.cdoID() == null)) {
            return this.initialURI;
        }
        if (this.viewProvider != null && (uri = this.viewProvider.getResourceURI(view = this.cdoView(), path = this.getPath())) != null) {
            return uri;
        }
        return super.getURI();
    }

    private URI normalizeURI(URI uri) {
        if (uri != null) {
            InternalCDOView view;
            ResourceSet resourceSet = this.getResourceSet();
            if (resourceSet == null && (view = this.cdoView()) != null) {
                resourceSet = view.getResourceSet();
            }
            if (resourceSet != null) {
                if (this.isRoot()) {
                    uri = URI.createURI((String)(String.valueOf(uri.toString()) + "/"));
                    uri = resourceSet.getURIConverter().normalize(uri);
                    String string = uri.toString();
                    if (string.endsWith("/")) {
                        uri = URI.createURI((String)string.substring(0, string.length() - 1));
                    }
                } else {
                    uri = resourceSet.getURIConverter().normalize(uri);
                }
            }
        }
        return uri;
    }

    private void cacheURI(URI uri) {
        this.uri = this.normalizeURI(uri);
    }

    @Override
    public void recacheURIs() {
        InternalCDOView view = this.cdoView();
        String path = this.getPath();
        URI uri = CDOURIUtil.createResourceURI(view, path);
        this.cacheURI(uri);
    }

    public void setURIGen(URI newURI) {
        this.eSet((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE__URI, newURI);
    }

    @Override
    public void setURI(URI newURI) {
        boolean notificationRequired = this.eNotificationRequired();
        URI oldURI = notificationRequired ? this.getURI() : null;
        String newPath = CDOURIUtil.extractResourcePath(newURI);
        this.setPath(newPath);
        if (notificationRequired) {
            NotificationImpl notification = new NotificationImpl(1, oldURI, newURI){

                public Object getNotifier() {
                    return CDOResourceImpl.this;
                }

                public int getFeatureID(Class<?> expectedClass) {
                    return 1;
                }
            };
            this.eNotify((Notification)notification);
        }
    }

    @Override
    public void setPath(String newPath) {
        super.setPath(newPath);
        this.cacheURI(CDOURIUtil.createResourceURI(this.cdoView(), newPath));
    }

    @Override
    public void setFolder(CDOResourceFolder newFolder) {
        super.setFolder(newFolder);
        this.recacheURIs();
    }

    @Override
    public void setName(String newName) {
        super.setName(newName);
        this.recacheURIs();
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 4: {
                return this.getURI();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 4: {
                this.setURI((URI)newValue);
                break;
            }
            default: {
                super.eSet(featureID, newValue);
            }
        }
    }

    @Override
    public EList<EObject> getContents() {
        return (EList)this.eGet((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE__CONTENTS, true);
    }

    @Override
    public void cdoInternalPostDetach(boolean remote, boolean top) {
        super.cdoInternalPostDetach(remote, top);
        if (remote) {
            this.existing = false;
        }
        this.removeFromResourceSet();
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @Override
    public void setModified(boolean newModified) {
        boolean oldModified = this.modified;
        this.modified = newModified;
        if (oldModified != newModified && this.eNotificationRequired()) {
            NotificationImpl notification = new NotificationImpl(1, oldModified, newModified){

                public Object getNotifier() {
                    return CDOResourceImpl.this;
                }

                public int getFeatureID(Class<?> expectedClass) {
                    return 3;
                }
            };
            this.eNotify((Notification)notification);
        }
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    private Notification setLoaded(boolean isLoaded) {
        boolean oldIsLoaded = this.loaded;
        this.loaded = isLoaded;
        if (this.eNotificationRequired()) {
            NotificationImpl notification = new NotificationImpl(1, oldIsLoaded, isLoaded){

                public Object getNotifier() {
                    return CDOResourceImpl.this;
                }

                public int getFeatureID(Class<?> expectedClass) {
                    return 4;
                }
            };
            return notification;
        }
        return null;
    }

    @Override
    public boolean isTrackingModification() {
        return (Boolean)this.eGet((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE__TRACKING_MODIFICATION, true);
    }

    public void setTrackingModificationGen(boolean newTrackingModification) {
        this.eSet((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE__TRACKING_MODIFICATION, newTrackingModification);
    }

    @Override
    public void setTrackingModification(boolean newTrackingModification) {
        InternalCDOView view = this.cdoView();
        if (view != null && view.isReadOnly()) {
            return;
        }
        if (newTrackingModification == this.isTrackingModification()) {
            return;
        }
        EList adapters = this.eAdapters();
        if (newTrackingModification) {
            adapters.add((Object)new CDOModificationTrackingAdapter(this));
        } else {
            for (Adapter adapter : adapters) {
                if (!(adapter instanceof CDOModificationTrackingAdapter)) continue;
                adapters.remove((Object)adapter);
                break;
            }
        }
        this.setTrackingModificationGen(newTrackingModification);
    }

    @Override
    public EList<Resource.Diagnostic> getErrors() {
        if (this.errors == null) {
            this.errors = new NotifyingListImpl<Resource.Diagnostic>(){
                private static final long serialVersionUID = 1L;

                protected boolean isNotificationRequired() {
                    return CDOResourceImpl.this.eNotificationRequired();
                }

                public Object getNotifier() {
                    return CDOResourceImpl.this;
                }

                public int getFeatureID() {
                    return 9;
                }
            };
        }
        return this.errors;
    }

    @Override
    public EList<Resource.Diagnostic> getWarnings() {
        if (this.warnings == null) {
            this.warnings = new NotifyingListImpl<Resource.Diagnostic>(){
                private static final long serialVersionUID = 1L;

                protected boolean isNotificationRequired() {
                    return CDOResourceImpl.this.eNotificationRequired();
                }

                public Object getNotifier() {
                    return CDOResourceImpl.this;
                }

                public int getFeatureID() {
                    return 10;
                }
            };
        }
        return this.warnings;
    }

    @Override
    public long getTimeStamp() {
        return (Long)this.eGet((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE__TIME_STAMP, true);
    }

    @Override
    public void setTimeStamp(long newTimeStamp) {
        this.eSet((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE__TIME_STAMP, newTimeStamp);
    }

    public TreeIterator<EObject> getAllContents() {
        return new AbstractTreeIterator<EObject>((Object)this, false){
            private static final long serialVersionUID = 1L;

            public Iterator<EObject> getChildren(Object object) {
                return object == CDOResourceImpl.this ? CDOResourceImpl.this.getContents().iterator() : ((EObject)object).eContents().iterator();
            }
        };
    }

    public EObject getEObject(String uriFragment) {
        try {
            int length;
            if (uriFragment != null && (length = uriFragment.length()) > 0) {
                EObject eObjectFromView;
                int index;
                if (uriFragment.charAt(0) == '/') {
                    List<String> uriFragmentPath = this.getURIFragmentPath(uriFragment, length);
                    EObject eObjectByFragment = this.getEObject(uriFragmentPath);
                    if (eObjectByFragment != null) {
                        return eObjectByFragment;
                    }
                } else if (uriFragment.charAt(length - 1) == '?' && (index = uriFragment.lastIndexOf(63, length - 2)) > 0) {
                    uriFragment = uriFragment.substring(0, index);
                }
                if ((eObjectFromView = this.getEObjectFromView(uriFragment)) != null) {
                    return eObjectFromView;
                }
                return this.getEObjectByID(uriFragment);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private EObject getEObjectFromView(String uriFragment) {
        InternalCDOView view;
        CDOID id;
        block3: {
            try {
                id = CDOIDUtil.read((String)uriFragment);
                view = this.cdoView();
                if (!CDOIDUtil.isNull((CDOID)id) && (!view.isObjectNew(id) || view.isObjectRegistered(id)) && id.isObject()) break block3;
                return null;
            }
            catch (Exception ex) {
                return null;
            }
        }
        CDOObject object = view.getObject(id, true);
        return CDOUtil.getEObject(object);
    }

    private List<String> getURIFragmentPath(String uriFragment, int length) {
        ArrayList<String> uriFragmentPath = new ArrayList<String>(4);
        int start = 1;
        int i = 1;
        while (i < length) {
            if (uriFragment.charAt(i) == '/') {
                uriFragmentPath.add(start == i ? "" : uriFragment.substring(start, i));
                start = i + 1;
            }
            ++i;
        }
        uriFragmentPath.add(uriFragment.substring(start));
        return uriFragmentPath;
    }

    private EObject getEObject(List<String> uriFragmentPath) {
        int size = uriFragmentPath.size();
        EObject eObject = this.getEObjectForURIFragmentRootSegment(size == 0 ? "" : uriFragmentPath.get(0));
        int i = 1;
        while (i < size && eObject != null) {
            eObject = ((InternalEObject)eObject).eObjectForURIFragmentSegment(uriFragmentPath.get(i));
            ++i;
        }
        return eObject;
    }

    private EObject getEObjectForURIFragmentRootSegment(String uriFragmentRootSegment) {
        EList<EObject> contents;
        int position = 0;
        if (uriFragmentRootSegment.length() > 0) {
            try {
                position = Integer.parseInt(uriFragmentRootSegment);
            }
            catch (NumberFormatException exception) {
                throw new RuntimeException(exception);
            }
        }
        if (position < (contents = this.getContents()).size() && position >= 0) {
            return (EObject)contents.get(position);
        }
        return null;
    }

    public Map<String, EObject> getIntrinsicIDToEObjectMap() {
        return this.intrinsicIDToEObjectMap;
    }

    public void setIntrinsicIDToEObjectMap(Map<String, EObject> intrinsicIDToEObjectMap) {
        this.intrinsicIDToEObjectMap = intrinsicIDToEObjectMap;
    }

    protected EObject getEObjectByID(String id) {
        EObject eObject;
        Map<String, EObject> map = this.getIntrinsicIDToEObjectMap();
        if (map != null && (eObject = map.get(id)) != null) {
            return eObject;
        }
        EObject result = null;
        TreeIterator<EObject> i = this.getAllProperContents((List<EObject>)this.getContents());
        while (i.hasNext()) {
            EObject eObject2 = (EObject)i.next();
            String eObjectId = EcoreUtil.getID((EObject)eObject2);
            if (eObjectId == null) continue;
            if (map != null) {
                map.put(eObjectId, eObject2);
            }
            if (!eObjectId.equals(id)) continue;
            result = eObject2;
            if (map == null) break;
        }
        return result;
    }

    protected TreeIterator<EObject> getAllProperContents(List<EObject> contents) {
        return new EcoreUtil.ContentTreeIterator<EObject>(contents, false){
            private static final long serialVersionUID = 1L;

            public Iterator<EObject> getChildren(Object object) {
                return object == this.object ? ((List)object).iterator() : new EcoreUtil.ProperContentIterator((EObject)object);
            }
        };
    }

    public String getURIFragment(EObject object) {
        InternalCDOObject internalCDOObject = FSMUtil.adapt(object, this.cdoView());
        StringBuilder builder = new StringBuilder();
        CDOIDUtil.write((StringBuilder)builder, (CDOID)internalCDOObject.cdoID());
        return builder.toString();
    }

    public boolean isLoading() {
        return this.loading;
    }

    @Override
    public void cdoInternalLoading(EObject object) {
        if (this.loadingCounter.incrementAndGet() == 1) {
            this.loading = true;
        }
    }

    @Override
    public void cdoInternalLoadingDone(EObject object) {
        if (this.loadingCounter.decrementAndGet() == 0) {
            this.loading = false;
        }
    }

    @Override
    public void cdoInternalPreLoad() {
        try {
            this.load(null);
        }
        catch (IOException ex) {
            throw WrappedException.wrap((Exception)ex);
        }
    }

    public void load(InputStream inputStream, Map<?, ?> options) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void load(Map<?, ?> options) throws IOException {
        if (!this.isLoaded()) {
            Notification notification;
            InternalCDOView view;
            boolean prefetch;
            Map<String, String> parameters;
            String value;
            String query;
            if (this.initialURI != null && (query = this.initialURI.query()) != null && query.length() != 0 && (value = (parameters = CDOURIUtil.getParameters(query)).get("prefetch")) != null && (prefetch = Boolean.parseBoolean(value))) {
                this.cdoPrefetch(-1);
            }
            if (!this.root && (view = this.cdoView()) != null) {
                view.resourceLoaded(this, true);
            }
            if ((notification = this.setLoaded(true)) != null) {
                this.eNotify(notification);
            }
        }
    }

    public void save(Map<?, ?> options) throws IOException {
        CDOTransaction transaction = this.getTransaction(options);
        IProgressMonitor progressMonitor = options != null ? (IProgressMonitor)options.get(CDOResource.OPTION_SAVE_PROGRESS_MONITOR) : null;
        try {
            transaction.commit(progressMonitor);
        }
        catch (CommitException ex) {
            throw new TransactionException((Throwable)ex);
        }
        this.setModified(false);
    }

    private CDOTransaction getTransaction(Map<?, ?> options) {
        CDOTransaction transaction;
        CDOTransaction cDOTransaction = transaction = options != null ? (CDOTransaction)options.get(CDOResource.OPTION_SAVE_OVERRIDE_TRANSACTION) : null;
        if (transaction == null) {
            InternalCDOView view = this.cdoView();
            if (view instanceof CDOTransaction) {
                transaction = (CDOTransaction)((Object)view);
            } else {
                throw new IllegalStateException("No transaction available");
            }
        }
        return transaction;
    }

    public void save(OutputStream outputStream, Map<?, ?> options) throws IOException {
        String baseURI = this.getBaseURIOption(options);
        HashMap<CDOResourceImpl, ExportResource> resourceMappings = new HashMap<CDOResourceImpl, ExportResource>();
        class ExportResource
        extends XMIResourceImpl {
            private CDOResource delegate;
            private final /* synthetic */ Map val$resourceMappings;
            private final /* synthetic */ String val$baseURI;

            public ExportResource(CDOResource delegate, String string, Map map) {
                this.val$baseURI = string;
                this.val$resourceMappings = map;
                super(URI.createURI((String)(String.valueOf(string) + delegate.getPath())));
                this.delegate = delegate;
            }

            public EList<EObject> getContents() {
                return this.delegate.getContents();
            }

            protected boolean useUUIDs() {
                return true;
            }

            protected boolean useIDAttributes() {
                return false;
            }

            public String getID(EObject eObject) {
                CDOObject cdoObject = CDOUtil.getCDOObject(eObject);
                StringBuilder builder = new StringBuilder();
                CDOIDUtil.write((StringBuilder)builder, (CDOID)cdoObject.cdoID());
                return builder.toString();
            }

            protected XMLHelper createXMLHelper() {
                return new XMIHelperImpl((XMLResource)this){

                    public String getHREF(EObject obj) {
                        InternalEObject o = (InternalEObject)obj;
                        URI objectURI = o.eProxyURI();
                        if (objectURI == null) {
                            Resource otherResource = obj.eResource();
                            otherResource = this.getMappedResource(otherResource);
                            objectURI = this.getHREF(otherResource, obj);
                        }
                        objectURI = this.deresolve(objectURI);
                        return objectURI.toString();
                    }

                    protected URI getHREF(Resource otherResource, EObject obj) {
                        String uriFragment = this.getURIFragment(otherResource, obj);
                        if (otherResource == this) {
                            return URI.createURI((String)uriFragment);
                        }
                        return otherResource.getURI().appendFragment(uriFragment);
                    }
                };
            }

            private Resource getMappedResource(Resource otherResource) {
                Resource resource = (Resource)this.val$resourceMappings.get(otherResource);
                if (resource != null) {
                    return resource;
                }
                if (otherResource instanceof CDOResource) {
                    CDOResource cdoResource = (CDOResource)otherResource;
                    otherResource = new ExportResource(cdoResource, this.val$baseURI, this.val$resourceMappings);
                    this.val$resourceMappings.put(cdoResource, otherResource);
                }
                return otherResource;
            }
        }
        ExportResource xmiResource = new ExportResource(this, baseURI, resourceMappings);
        resourceMappings.put(this, xmiResource);
        xmiResource.save(outputStream, options);
    }

    private String getBaseURIOption(Map<?, ?> options) {
        String uri;
        if (options != null && (uri = (String)options.get("OPTION_SAVE_BASE_URI")) != null) {
            return uri;
        }
        return "cdo://";
    }

    public void unload() {
        InternalCDOView view;
        if (!this.root && (view = this.cdoView()) != null) {
            view.resourceLoaded(this, false);
        }
    }

    @Override
    public void delete(Map<?, ?> options) throws IOException {
        if (FSMUtil.isTransient(this)) {
            this.removeFromResourceSet();
        } else {
            if (this.isRoot()) {
                throw new UnsupportedOperationException();
            }
            if (this.getFolder() == null) {
                InternalCDOView view = this.cdoView();
                view.getRootResource().getContents().remove((Object)this);
            } else {
                this.basicSetFolder(null, false);
            }
        }
    }

    private void removeFromResourceSet() {
        final ResourceSet resourceSet = this.getResourceSet();
        if (resourceSet != null) {
            InternalCDOViewSet viewSet = (InternalCDOViewSet)CDOUtil.getViewSet((Notifier)resourceSet);
            viewSet.executeWithoutNotificationHandling(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    resourceSet.getResources().remove((Object)CDOResourceImpl.this);
                    return true;
                }
            });
        }
    }

    public void attached(EObject object) {
        InternalCDOView view;
        if (!FSMUtil.isTransient(this) && (view = this.cdoView()) instanceof InternalCDOTransaction) {
            InternalCDOTransaction transaction = (InternalCDOTransaction)view;
            InternalCDOObject cdoObject = FSMUtil.adapt(object, transaction);
            if (CDOUtil.isLegacyObject(cdoObject)) {
                InternalCDOObject cdoContainer;
                if (!FSMUtil.isTransient(cdoObject)) {
                    return;
                }
                EObject container = cdoObject.eContainer();
                if (container != null && FSMUtil.isTransient(cdoContainer = FSMUtil.adapt(container, transaction))) {
                    return;
                }
                EReference containmentFeature = object.eContainmentFeature();
                if (containmentFeature != null && !EMFUtil.isPersistent((EStructuralFeature)containmentFeature)) {
                    return;
                }
            }
            this.attached(cdoObject, transaction);
        }
    }

    private void attached(InternalCDOObject cdoObject, InternalCDOTransaction transaction) {
        CDOStateMachine.INSTANCE.attach(cdoObject, transaction);
    }

    public void detached(EObject object) {
        InternalCDOView view;
        if (!FSMUtil.isTransient(this) && (view = this.cdoView()) instanceof InternalCDOTransaction) {
            InternalCDOObject cdoObject = FSMUtil.adapt(object, view);
            CDOStateMachine.INSTANCE.detach(cdoObject);
        }
    }

    public NotificationChain basicSetResourceSet(ResourceSet resourceSet, NotificationChain notifications) {
        URI uri;
        InternalCDOView view;
        final ResourceSet oldResourceSet = this.getResourceSet();
        if (oldResourceSet != null) {
            InternalCDOViewSet viewSet = (InternalCDOViewSet)CDOUtil.getViewSet((Notifier)oldResourceSet);
            if (viewSet == null) {
                return notifications;
            }
            final NotificationChain finalNotifications = notifications;
            notifications = viewSet.executeWithoutNotificationHandling(new Callable<NotificationChain>(){

                @Override
                public NotificationChain call() throws Exception {
                    return ((InternalEList)oldResourceSet.getResources()).basicRemove((Object)this, finalNotifications);
                }
            });
        }
        this.setResourceSet(resourceSet);
        if (resourceSet != null && (view = this.cdoView()) == null && (view = (InternalCDOView)CDOUtil.getView(resourceSet, uri = this.getURI())) != null) {
            try {
                view.attachResource(this);
            }
            catch (RuntimeException ex) {
                resourceSet.getResources().remove((Object)this);
                this.setExisting(false);
                this.cdoInternalSetState(CDOState.TRANSIENT);
                throw ex;
            }
            catch (Error ex) {
                resourceSet.getResources().remove((Object)this);
                this.setExisting(false);
                this.cdoInternalSetState(CDOState.TRANSIENT);
                throw ex;
            }
            this.viewProvider = view.getProvider();
            this.cacheURI(uri);
        }
        if (this.eNotificationRequired()) {
            if (notifications == null) {
                notifications = new NotificationChainImpl(2);
            }
            notifications.add((Notification)new NotificationImpl(1, oldResourceSet, resourceSet){

                public Object getNotifier() {
                    return CDOResourceImpl.this;
                }

                public int getFeatureID(Class<?> expectedClass) {
                    return 0;
                }
            });
        }
        return notifications;
    }

    @Override
    public boolean isExisting() {
        return this.existing;
    }

    protected void setExisting(boolean existing) {
        this.existing = existing;
    }

    @Override
    protected EList<?> createList(EStructuralFeature eStructuralFeature) {
        if (eStructuralFeature == CDO_RESOURCE_CONTENTS) {
            return new ContentsCDOList((EStructuralFeature)CDO_RESOURCE_CONTENTS);
        }
        return super.createList(eStructuralFeature);
    }

    @Override
    public String toString(String string) {
        if (this.uri != null) {
            return String.valueOf(string) + "(\"" + this.uri + "\")";
        }
        if (this.initialURI != null) {
            return String.valueOf(string) + "(\"" + this.initialURI + "\")";
        }
        return super.toString(string);
    }

    public String getID(EObject eObject) {
        return this.getURIFragment(eObject);
    }

    public void setID(EObject eObject, String id) {
    }

    public boolean useZip() {
        return false;
    }

    public void setUseZip(boolean useZip) {
    }

    public String getPublicId() {
        throw new UnsupportedOperationException();
    }

    public String getSystemId() {
        throw new UnsupportedOperationException();
    }

    public DOMHelper getDOMHelper() {
        throw new UnsupportedOperationException();
    }

    public Map<Object, Object> getDefaultLoadOptions() {
        throw new UnsupportedOperationException();
    }

    public Map<Object, Object> getDefaultSaveOptions() {
        throw new UnsupportedOperationException();
    }

    public Map<EObject, AnyType> getEObjectToExtensionMap() {
        throw new UnsupportedOperationException();
    }

    public String getEncoding() {
        throw new UnsupportedOperationException();
    }

    public void setEncoding(String encoding) {
    }

    public String getXMLVersion() {
        throw new UnsupportedOperationException();
    }

    public void setXMLVersion(String version) {
    }

    public void setDoctypeInfo(String publicId, String systemId) {
    }

    public void load(Node node, Map<?, ?> options) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void load(InputSource inputSource, Map<?, ?> options) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void save(Writer writer, Map<?, ?> options) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Document save(Document document, Map<?, ?> options, DOMHandler handler) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Map<String, EObject> getIDToEObjectMap() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Map<EObject, String> getEObjectToIDMap() {
        throw new UnsupportedOperationException();
    }

    protected class ContentsCDOList
    extends EStoreEObjectImpl.BasicEStoreEList<Object> {
        private static final long serialVersionUID = 1L;

        public ContentsCDOList(EStructuralFeature eStructuralFeature) {
            super((InternalEObject)CDOResourceImpl.this, eStructuralFeature);
        }

        public boolean contains(Object object) {
            if (this.size() <= 4) {
                return super.contains(object);
            }
            return object instanceof InternalEObject && ((InternalEObject)object).eDirectResource() == CDOResourceImpl.this;
        }

        public NotificationChain inverseAdd(Object object, NotificationChain notifications) {
            if (FSMUtil.isTransient(CDOResourceImpl.this)) {
                InternalEObject eObject = (InternalEObject)object;
                notifications = eObject.eSetResource((Resource.Internal)CDOResourceImpl.this, notifications);
            } else {
                InternalCDOTransaction transaction = CDOResourceImpl.this.cdoView().toTransaction();
                InternalCDOObject cdoObject = FSMUtil.adapt(object, transaction);
                notifications = cdoObject.eSetResource(CDOResourceImpl.this, notifications);
                if (CDOResourceImpl.this.isRoot()) {
                    ((CDOResourceNodeImpl)cdoObject).basicSetFolder(null, false);
                }
                if (FSMUtil.isTransient(cdoObject)) {
                    CDOResourceImpl.this.attached(cdoObject, transaction);
                }
            }
            return notifications;
        }

        public NotificationChain inverseRemove(Object object, NotificationChain notifications) {
            if (FSMUtil.isTransient(CDOResourceImpl.this)) {
                InternalEObject eObject = (InternalEObject)object;
                notifications = eObject.eSetResource(null, notifications);
            } else {
                InternalEObject eObject = (InternalEObject)object;
                CDOResourceImpl.this.detached((EObject)eObject);
                notifications = eObject.eSetResource(null, notifications);
            }
            return notifications;
        }

        protected void loaded() {
            Notification notification = CDOResourceImpl.this.setLoaded(true);
            if (notification != null) {
                CDOResourceImpl.this.eNotify(notification);
            }
        }

        protected void modified() {
            if (CDOResourceImpl.this.isTrackingModification()) {
                CDOResourceImpl.this.setModified(true);
            }
        }

        protected boolean useEquals() {
            return false;
        }

        protected boolean hasInverse() {
            return true;
        }

        protected boolean isUnique() {
            return true;
        }

        protected Object validate(int index, Object object) {
            if (!CDOResourceImpl.this.root && object instanceof CDOResourceNode) {
                throw new IllegalArgumentException("CDOResource.contents must not contain other resource nodes");
            }
            return super.validate(index, object);
        }

        protected void didAdd(int index, Object newObject) {
            super.didAdd(index, newObject);
            if (!CDOResourceImpl.this.isExisting() && !CDOResourceImpl.this.isLoaded()) {
                this.loaded();
            }
        }

        protected void didClear(int size, Object[] oldObjects) {
            super.didClear(size, oldObjects);
            if (!CDOResourceImpl.this.isExisting() && !CDOResourceImpl.this.isLoaded()) {
                this.loaded();
            }
        }
    }
}

