/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.condition;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.reddeer.common.condition.AbstractWaitCondition;
import org.eclipse.reddeer.eclipse.ui.markers.matcher.AbstractMarkerMatcher;
import org.eclipse.reddeer.eclipse.ui.problems.Problem;
import org.eclipse.reddeer.eclipse.ui.views.markers.ProblemsView;

public class ExactNumberOfProblemsExists
extends AbstractWaitCondition {
    private AbstractMarkerMatcher[] problemMatchers;
    private ProblemsView.ProblemType problemType;
    private int expectedProblemsCount;
    private ProblemsView problemsView;
    private List<Problem> problems = new ArrayList<Problem>();

    public ExactNumberOfProblemsExists(ProblemsView.ProblemType type, int count) {
        this(type, count, new AbstractMarkerMatcher[0]);
    }

    public <T extends AbstractMarkerMatcher> ExactNumberOfProblemsExists(ProblemsView.ProblemType type, int count, T ... matchers) {
        this.problemType = type;
        this.expectedProblemsCount = count;
        this.problemMatchers = matchers;
        this.problemsView = new ProblemsView();
        this.problemsView.open();
    }

    public boolean test() {
        this.problemsView.activate();
        this.problems = this.problemsView.getProblems(this.problemType, this.problemMatchers);
        return this.problems.size() == this.expectedProblemsCount;
    }

    public String description() {
        return "number of problems in Problems view is " + this.problems.size() + ".\n" + "Expected number of problems is: " + this.expectedProblemsCount;
    }
}

