/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.migration;

import java.util.UUID;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.sirius.business.api.migration.AbstractMigrationParticipant;
import org.eclipse.sirius.business.api.query.AirDResouceQuery;
import org.eclipse.sirius.business.api.session.resource.AirdResource;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DView;
import org.osgi.framework.Version;

public abstract class AbstractRepresentationsFileMigrationParticipant
extends AbstractMigrationParticipant {
    @Override
    public void postLoad(XMLResource resource, String loadedVersion) {
        AirDResouceQuery query;
        Option<DAnalysis> optionalAnalysis;
        super.postLoad(resource, loadedVersion);
        if (resource instanceof AirdResource && (optionalAnalysis = (query = new AirDResouceQuery((AirdResource)resource)).getDAnalysis()).some()) {
            DAnalysis dAnalysis = (DAnalysis)optionalAnalysis.get();
            this.postLoad(dAnalysis, Version.parseVersion((String)loadedVersion));
        }
    }

    private DRepresentationDescriptor getRepresentationDescriptor(DAnalysis dAnalysis, DRepresentation representation) {
        EList<DView> ownedViews = dAnalysis.getOwnedViews();
        for (DView dView : ownedViews) {
            EList<DRepresentationDescriptor> ownedRepresentationDescriptors = dView.getOwnedRepresentationDescriptors();
            for (DRepresentationDescriptor representationDescriptor : ownedRepresentationDescriptors) {
                if (!representation.equals(representationDescriptor.getRepresentation())) continue;
                return representationDescriptor;
            }
        }
        return null;
    }

    protected void updateChangeId(DAnalysis dAnalysis, DRepresentation representation) {
        DRepresentationDescriptor representationDescriptor = this.getRepresentationDescriptor(dAnalysis, representation);
        if (representationDescriptor != null) {
            representationDescriptor.setChangeId(UUID.randomUUID().toString());
        }
    }

    protected void postLoad(DAnalysis dAnalysis, Version loadedVersion) {
    }
}

