/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.cdt.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.launch.LaunchUtils;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.tcf.debug.ITCFLaunchProjectBuilder;

public class TCFLaunchProjectBuilder
implements ITCFLaunchProjectBuilder {
    private static final String CONFIGURATION_IDS = "org.eclipse.cdt.make.core.configurationIds";
    private static final String CONTENTS = "org.eclipse.cdt.make.core.contents";
    private static final String CONTENTS_CONFIGURATION_IDS = "org.eclipse.cdt.make.core.configurationIds";

    public boolean isSupportedProject(String name) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        return CCorePlugin.getDefault().getCoreModel().create(project) != null;
    }

    public IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        String name = configuration.getAttribute("org.eclipse.tcf.debug.ProjectName", "");
        if (name.length() == 0) {
            return null;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        if (project == null) {
            return null;
        }
        ICProject c_project = CCorePlugin.getDefault().getCoreModel().create(project);
        if (c_project == null) {
            return null;
        }
        IProject[] ordered_projects = null;
        HashSet<IProject> project_set = new HashSet<IProject>();
        this.getReferencedProjectSet(c_project.getProject(), project_set);
        String[] ordered_names = ResourcesPlugin.getWorkspace().getDescription().getBuildOrder();
        if (ordered_names != null) {
            ArrayList<IProject> unordered_list = new ArrayList<IProject>(project_set.size());
            ArrayList<IProject> ordered_list = new ArrayList<IProject>(project_set.size());
            unordered_list.addAll(project_set);
            String[] stringArray = ordered_names;
            int n = ordered_names.length;
            int n2 = 0;
            while (n2 < n) {
                String nm = stringArray[n2];
                for (IProject proj : unordered_list) {
                    if (!proj.getName().equals(nm)) continue;
                    ordered_list.add(proj);
                    unordered_list.remove(proj);
                    break;
                }
                ++n2;
            }
            ordered_list.addAll(unordered_list);
            ordered_projects = ordered_list.toArray(new IProject[ordered_list.size()]);
        } else {
            IProject[] projects = project_set.toArray(new IProject[project_set.size()]);
            ordered_projects = ResourcesPlugin.getWorkspace().computeProjectOrder((IProject[])projects).projects;
        }
        return ordered_projects;
    }

    private void getReferencedProjectSet(IProject proj, Set<IProject> set) throws CoreException {
        set.add(proj);
        IProject[] iProjectArray = proj.getReferencedProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject ref = iProjectArray[n2];
            if (ref.exists() && !set.contains(ref)) {
                this.getReferencedProjectSet(ref, set);
            }
            ++n2;
        }
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        try {
            SubMonitor submon = SubMonitor.convert((IProgressMonitor)monitor, (String)"", (int)1);
            String name = configuration.getAttribute("org.eclipse.tcf.debug.ProjectName", "");
            if (name.length() == 0) {
                return true;
            }
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
            if (project == null) {
                return true;
            }
            String buildConfigID = null;
            if (configuration.getAttribute("org.eclipse.tcf.debug.ProjectBuildConfigAuto", false)) {
                String program_path = configuration.getAttribute("org.eclipse.tcf.debug.LocalProgramFile", "");
                program_path = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(program_path);
                ICConfigurationDescription buildConfig = LaunchUtils.getBuildConfigByProgramPath((IProject)project, (String)program_path);
                if (buildConfig != null) {
                    buildConfigID = buildConfig.getId();
                }
            }
            if (buildConfigID == null) {
                buildConfigID = configuration.getAttribute("org.eclipse.tcf.debug.ProjectBuildConfigID", null);
            }
            if (buildConfigID != null) {
                boolean idIsGood = false;
                ICProjectDescription desc = CCorePlugin.getDefault().getProjectDescription(project, false);
                if (desc != null) {
                    boolean bl = idIsGood = desc.getConfigurationById(buildConfigID) != null;
                }
                if (!idIsGood) {
                    buildConfigID = null;
                }
            }
            this.buildProject(project, buildConfigID, (IProgressMonitor)submon.newChild(1));
            return false;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public void buildProject(final IProject project, final String buildConfigID, IProgressMonitor monitor) throws CoreException {
        int TOTAL_TICKS = 1000;
        IWorkspaceRunnable build = new IWorkspaceRunnable(){

            public void run(IProgressMonitor pm) throws CoreException {
                SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)pm, (String)"", (int)1000);
                try {
                    int buildCount;
                    int n = buildCount = buildConfigID == null ? 1 : project.getDescription().getBuildSpec().length;
                    if (buildCount == 0) {
                        return;
                    }
                    int subtaskTicks = 1000 / buildCount;
                    if (buildConfigID != null) {
                        Map cfgIdArgs = TCFLaunchProjectBuilder.cfgIdsToMap(new String[]{buildConfigID}, new HashMap());
                        cfgIdArgs.put(TCFLaunchProjectBuilder.CONTENTS, "org.eclipse.cdt.make.core.configurationIds");
                        ICommand[] commands = project.getDescription().getBuildSpec();
                        if (!$assertionsDisabled && buildCount != commands.length) {
                            throw new AssertionError();
                        }
                        ICommand[] iCommandArray = commands;
                        int n2 = commands.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            ICommand command = iCommandArray[n3];
                            HashMap args = command.getArguments();
                            if (args == null) {
                                args = new HashMap(cfgIdArgs);
                            } else {
                                args.putAll(cfgIdArgs);
                            }
                            if (localmonitor.isCanceled()) {
                                throw new OperationCanceledException();
                            }
                            project.build(10, command.getBuilderName(), args, (IProgressMonitor)localmonitor.newChild(subtaskTicks));
                            ++n3;
                        }
                    } else {
                        project.build(10, (IProgressMonitor)localmonitor.newChild(subtaskTicks));
                    }
                }
                finally {
                    if (pm != null) {
                        pm.done();
                    }
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(build, (IProgressMonitor)new SubProgressMonitor(monitor, 1000, 0){
            private boolean cancelled;

            public void setCanceled(boolean b) {
                this.cancelled = b;
            }

            public boolean isCanceled() {
                return this.cancelled || super.isCanceled();
            }
        });
    }

    private static Map<String, String> cfgIdsToMap(String[] ids, Map<String, String> map) {
        map.put("org.eclipse.cdt.make.core.configurationIds", TCFLaunchProjectBuilder.encodeList(Arrays.asList(ids)));
        return map;
    }

    private static String encodeList(List<String> values) {
        StringBuffer str = new StringBuffer();
        for (String entry : values) {
            str.append(TCFLaunchProjectBuilder.escapeChars(entry, "|\\", '\\'));
            str.append("|");
        }
        return str.toString();
    }

    private static String escapeChars(String string, String escapeChars, char escapeChar) {
        StringBuffer str = new StringBuffer(string);
        int i = 0;
        while (i < str.length()) {
            if (escapeChars.indexOf(str.charAt(i)) != -1) {
                str.insert(i, escapeChar);
                ++i;
            }
            ++i;
        }
        return str.toString();
    }
}

