/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.util.Util;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.CommentTemplateEditDialog;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class CommentTemplatesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
ISelectionChangedListener {
    private ListViewer viewer;
    private Button editButton;
    private Button removeButton;
    private Text preview;

    protected Control createContents(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(1808));
        this.createListAndButtons(parent);
        Label previewLabel = new Label(parent, 0);
        previewLabel.setText(CVSUIMessages.CommentTemplatesPreferencePage_Preview);
        this.preview = new Text(parent, 2058);
        GridData gd = new GridData(768);
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        this.preview.setLayoutData((Object)gd);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.team.cvs.ui.comment_template_preference_page_context");
        Dialog.applyDialogFont((Control)ancestor);
        return parent;
    }

    private Composite createListAndButtons(Composite parent) {
        String[] templates;
        Composite listAndButtons = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        listAndButtons.setLayout((Layout)layout);
        listAndButtons.setLayoutData((Object)new GridData(1808));
        Label viewerLabel = new Label(listAndButtons, 0);
        viewerLabel.setText(CVSUIMessages.CommentTemplatesPreferencePage_Description);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        viewerLabel.setLayoutData((Object)data);
        this.viewer = new ListViewer(listAndButtons);
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                String template = (String)element;
                return Util.flattenText((String)template);
            }
        });
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                String template1 = Util.flattenText((String)((String)e1));
                String template2 = Util.flattenText((String)((String)e2));
                return template1.compareToIgnoreCase(template2);
            }
        });
        this.viewer.addDoubleClickListener(event -> this.editTemplate());
        List list = this.viewer.getList();
        list.setLayoutData((Object)new GridData(1808));
        String[] stringArray = templates = CVSUIPlugin.getPlugin().getRepositoryManager().getCommentTemplates();
        int n = templates.length;
        int n2 = 0;
        while (n2 < n) {
            String template = stringArray[n2];
            this.viewer.add((Object)template);
            ++n2;
        }
        this.createButtons(listAndButtons);
        return listAndButtons;
    }

    private void createButtons(Composite parent) {
        Composite buttons = new Composite(parent, 0);
        buttons.setLayoutData((Object)new GridData(2));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        Button newButton = new Button(buttons, 8);
        newButton.setText(CVSUIMessages.CommentTemplatesPreferencePage_New);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, newButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        newButton.setLayoutData((Object)data);
        newButton.setEnabled(true);
        newButton.addListener(13, event -> this.newTemplate());
        this.editButton = new Button(buttons, 8);
        this.editButton.setText(CVSUIMessages.CommentTemplatesPreferencePage_Edit);
        data = new GridData();
        data.horizontalAlignment = 4;
        widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, this.editButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.editButton.setLayoutData((Object)data);
        this.editButton.setEnabled(false);
        this.editButton.addListener(13, e -> this.editTemplate());
        this.removeButton = new Button(buttons, 8);
        this.removeButton.setText(CVSUIMessages.CommentTemplatesPreferencePage_Remove);
        data = new GridData();
        data.horizontalAlignment = 4;
        widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, this.removeButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.removeButton.setLayoutData((Object)data);
        this.removeButton.setEnabled(false);
        this.removeButton.addListener(13, e -> this.remove());
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = event.getStructuredSelection();
        switch (selection.size()) {
            case 0: {
                this.editButton.setEnabled(false);
                this.removeButton.setEnabled(false);
                this.preview.setText("");
                break;
            }
            case 1: {
                this.editButton.setEnabled(true);
                this.removeButton.setEnabled(true);
                this.preview.setText((String)selection.getFirstElement());
                break;
            }
            default: {
                this.editButton.setEnabled(false);
                this.removeButton.setEnabled(true);
                this.preview.setText("");
            }
        }
    }

    void newTemplate() {
        CommentTemplateEditDialog dialog = new CommentTemplateEditDialog(this.getShell(), CVSUIMessages.CommentTemplatesPreferencePage_EditCommentTemplateTitle, CVSUIMessages.CommentTemplatesPreferencePage_EditCommentTemplateMessage, "", null);
        if (dialog.open() == 0) {
            this.viewer.add((Object)dialog.getValue());
        }
    }

    void editTemplate() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() == 1) {
            String oldTemplate = (String)selection.getFirstElement();
            CommentTemplateEditDialog dialog = new CommentTemplateEditDialog(this.getShell(), CVSUIMessages.CommentTemplatesPreferencePage_EditCommentTemplateTitle, CVSUIMessages.CommentTemplatesPreferencePage_EditCommentTemplateMessage, oldTemplate, null);
            if (dialog.open() == 0) {
                this.viewer.remove((Object)oldTemplate);
                this.viewer.add((Object)dialog.getValue());
            }
        }
    }

    void remove() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        this.viewer.remove(selection.toArray());
    }

    public boolean performOk() {
        int numTemplates = this.viewer.getList().getItemCount();
        String[] templates = new String[numTemplates];
        int i = 0;
        while (i < numTemplates) {
            templates[i] = (String)this.viewer.getElementAt(i);
            ++i;
        }
        try {
            CVSUIPlugin.getPlugin().getRepositoryManager().replaceAndSaveCommentTemplates(templates);
        }
        catch (TeamException e) {
            CVSUIPlugin.openError(this.getShell(), null, null, e, 8);
        }
        return super.performOk();
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        this.viewer.getList().removeAll();
        super.performDefaults();
    }
}

