/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.querybasedfeatures.runtime;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.viatra.addon.querybasedfeatures.runtime.IQueryBasedFeatureHandler;
import org.eclipse.viatra.addon.querybasedfeatures.runtime.QueryBasedFeature;
import org.eclipse.viatra.addon.querybasedfeatures.runtime.QueryBasedFeatureHandler;
import org.eclipse.viatra.addon.querybasedfeatures.runtime.QueryBasedFeatureKind;
import org.eclipse.viatra.addon.querybasedfeatures.runtime.handler.QueryBasedFeatures;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.api.scope.QueryScope;
import org.eclipse.viatra.query.runtime.emf.EMFScope;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistry;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryEntry;
import org.eclipse.viatra.query.runtime.registry.QuerySpecificationRegistry;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;

public final class QueryBasedFeatureHelper {
    private static final Map<Notifier, Map<EStructuralFeature, WeakReference<IQueryBasedFeatureHandler>>> FEATURE_MAP = new WeakHashMap<Notifier, Map<EStructuralFeature, WeakReference<IQueryBasedFeatureHandler>>>();

    private QueryBasedFeatureHelper() {
    }

    public static Notifier prepareNotifierForSource(EObject source) {
        if (source != null) {
            Resource eResource = source.eResource();
            if (eResource != null) {
                ResourceSet resourceSet = eResource.getResourceSet();
                if (resourceSet != null) {
                    return resourceSet;
                }
                return eResource;
            }
            EObject top = source;
            while (top.eContainer() != null) {
                top = top.eContainer();
            }
            if (!top.equals(source)) {
                return QueryBasedFeatureHelper.prepareNotifierForSource(top);
            }
        }
        return source;
    }

    public static IQueryBasedFeatureHandler getQueryBasedFeatureHandler(Notifier notifier, EStructuralFeature feature, String patternFQN, String sourceParamName, String targetParamName, QueryBasedFeatureKind kind, boolean keepCache) {
        WeakReference<IQueryBasedFeatureHandler> weakReference;
        IQueryBasedFeatureHandler derivedFeature;
        Map<EStructuralFeature, WeakReference<IQueryBasedFeatureHandler>> features = FEATURE_MAP.get(notifier);
        if (features == null) {
            features = new HashMap<EStructuralFeature, WeakReference<IQueryBasedFeatureHandler>>();
            FEATURE_MAP.put(notifier, features);
        }
        IQueryBasedFeatureHandler iQueryBasedFeatureHandler = derivedFeature = (weakReference = features.get(feature)) == null ? null : (IQueryBasedFeatureHandler)weakReference.get();
        if (derivedFeature != null) {
            return derivedFeature;
        }
        QueryBasedFeature newFeature = QueryBasedFeatureHelper.createQueryBasedFeature(feature, kind, keepCache);
        if (newFeature == null) {
            ViatraQueryLoggingUtil.getLogger(QueryBasedFeatureHelper.class).error((Object)("Handler initialization failed, feature kind " + (Object)((Object)kind) + " not supported!"));
            return null;
        }
        QueryBasedFeatureHandler queryBasedFeatureHandler = new QueryBasedFeatureHandler(newFeature);
        features.put(feature, new WeakReference<QueryBasedFeatureHandler>(queryBasedFeatureHandler));
        IQuerySpecificationRegistry registry = QuerySpecificationRegistry.getInstance();
        IQuerySpecificationRegistryEntry registryEntry = registry.getDefaultView().getEntry(patternFQN);
        IQuerySpecification querySpecification = (IQuerySpecification)registryEntry.get();
        if (querySpecification != null) {
            try {
                ViatraQueryMatcher matcher = querySpecification.getMatcher(ViatraQueryEngine.on((QueryScope)new EMFScope(notifier)));
                newFeature.initialize((ViatraQueryMatcher<IPatternMatch>)matcher, sourceParamName, targetParamName);
                newFeature.startMonitoring();
            }
            catch (ViatraQueryException e) {
                ViatraQueryLoggingUtil.getLogger(QueryBasedFeatureHelper.class).error((Object)"Handler initialization failed", (Throwable)e);
                return null;
            }
        } else {
            ViatraQueryLoggingUtil.getLogger(QueryBasedFeatureHelper.class).error((Object)String.format("Handler initialization failed, query specification is null for %s. Make sure to include your VIATRA Query project with the query definitions in the configuration.", patternFQN));
        }
        return queryBasedFeatureHandler;
    }

    protected static QueryBasedFeature createQueryBasedFeature(EStructuralFeature feature, QueryBasedFeatureKind kind, boolean keepCache) {
        QueryBasedFeature newFeature = null;
        switch (kind) {
            case SINGLE_REFERENCE: {
                newFeature = QueryBasedFeatures.newSingleValueFeature(feature, keepCache);
                break;
            }
            case MANY_REFERENCE: {
                newFeature = QueryBasedFeatures.newMultiValueFeatue(feature, keepCache);
                break;
            }
            case SUM: {
                newFeature = QueryBasedFeatures.newSumFeature(feature);
                break;
            }
        }
        return newFeature;
    }

    public static IQueryBasedFeatureHandler getQueryBasedFeatureHandlerOnNotifier(Notifier notifier, EStructuralFeature feature, String patternFQN, String sourceParamName, String targetParamName, QueryBasedFeatureKind kind) {
        return QueryBasedFeatureHelper.getQueryBasedFeatureHandler(notifier, feature, patternFQN, sourceParamName, targetParamName, kind, true);
    }

    public static IQueryBasedFeatureHandler getQueryBasedFeatureHandler(EObject source, EStructuralFeature feature, String patternFQN, String sourceParamName, String targetParamName, QueryBasedFeatureKind kind, boolean keepCache, boolean useSourceAsNotifier) {
        EObject notifier = source;
        if (!useSourceAsNotifier) {
            notifier = QueryBasedFeatureHelper.prepareNotifierForSource(source);
        }
        return QueryBasedFeatureHelper.getQueryBasedFeatureHandler((Notifier)notifier, feature, patternFQN, sourceParamName, targetParamName, kind, keepCache);
    }

    public static IQueryBasedFeatureHandler getQueryBasedFeatureHandler(EObject source, EStructuralFeature feature, String patternFQN, String sourceParamName, String targetParamName, QueryBasedFeatureKind kind) {
        return QueryBasedFeatureHelper.getQueryBasedFeatureHandler(source, feature, patternFQN, sourceParamName, targetParamName, kind, true, false);
    }
}

