/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gef.part.menu;

import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.Graphics;
import org.eclipse.wb.draw2d.IColorConstants;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.core.gef.part.menu.SubmenuAwareEditPart;
import org.eclipse.wb.internal.core.model.menu.IMenuInfo;
import org.eclipse.wb.internal.core.model.menu.IMenuItemInfo;

public final class MenuItemEditPart
extends SubmenuAwareEditPart {
    private final IMenuItemInfo m_item;

    public MenuItemEditPart(Object toolkitModel, IMenuItemInfo item) {
        super(toolkitModel, item);
        this.m_item = item;
    }

    @Override
    protected Figure createFigure() {
        return new Figure(){

            @Override
            protected void paintClientArea(Graphics graphics) {
                Image image = MenuItemEditPart.this.m_item.getImage();
                if (image != null) {
                    graphics.drawImage(image, 0, 0);
                }
                if (!MenuItemEditPart.this.getModelChildren().isEmpty()) {
                    Rectangle area = MenuItemEditPart.this.getFigure().getClientArea();
                    graphics.setForegroundColor(IColorConstants.menuBackgroundSelected);
                    graphics.setBackgroundColor(IColorConstants.white);
                    graphics.setLineWidth(2);
                    graphics.drawRectangle(1, 1, area.width - 2, area.height - 2);
                }
            }
        };
    }

    @Override
    protected void refreshVisuals() {
        this.getFigure().setBounds(this.m_item.getBounds());
    }

    @Override
    protected Object getChildMenu() {
        IMenuInfo menu = this.m_item.getMenu();
        return menu != null ? menu.getModel() : null;
    }
}

