/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.debug.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;
import org.eclipse.wst.xsl.core.XSLCore;
import org.eclipse.wst.xsl.internal.debug.ui.Messages;
import org.eclipse.wst.xsl.internal.debug.ui.actions.AbstractStylesheetAction;
import org.eclipse.wst.xsl.internal.debug.ui.tabs.main.StylesheetViewer;
import org.eclipse.wst.xsl.launching.config.LaunchTransform;

public class AddWorkspaceFileAction
extends AbstractStylesheetAction {
    private final ISelectionStatusValidator validator = new ISelectionStatusValidator(){

        public IStatus validate(Object[] selection) {
            if (selection.length == 0) {
                return new Status(4, "org.eclipse.wst.xsl.debug.ui", 0, "", null);
            }
            int i = 0;
            while (i < selection.length) {
                if (!(selection[i] instanceof IFile)) {
                    return new Status(4, "org.eclipse.wst.xsl.debug.ui", 0, "", null);
                }
                ++i;
            }
            return new Status(0, "org.eclipse.wst.xsl.debug.ui", 0, "", null);
        }
    };

    public AddWorkspaceFileAction(StylesheetViewer viewer) {
        super(Messages.AddWorkspaceFileAction_Text, viewer);
    }

    public void run() {
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setValidator(this.validator);
        dialog.setTitle(Messages.AddWorkspaceFileAction_DialogTitle);
        dialog.setMessage(Messages.AddWorkspaceFileAction_DialogMessage);
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (!(element instanceof IResource)) {
                    return false;
                }
                IResource resource = (IResource)element;
                return resource.getType() != 1 || XSLCore.isXSLFile((IFile)((IFile)resource));
            }
        });
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            LaunchTransform[] res = new LaunchTransform[elements.length];
            int i = 0;
            while (i < res.length) {
                IResource elem = (IResource)elements[i];
                res[i] = new LaunchTransform(elem.getFullPath().toPortableString(), "resource");
                ++i;
            }
            this.addTransforms(res);
        }
    }

    @Override
    protected int getActionType() {
        return 1;
    }
}

