/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.efacet.ui.internal.widget;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.papyrus.emf.facet.efacet.ui.internal.Messages;
import org.eclipse.papyrus.emf.facet.efacet.ui.internal.composites.FilteredElementSelectionComposite;
import org.eclipse.papyrus.emf.facet.efacet.ui.internal.composites.SelectETypeComposite;
import org.eclipse.swt.widgets.Composite;

public class EClassifierSelectionControl
extends FilteredElementSelectionComposite {
    private final Map<String, EClassifier> stringToEClassifierMap = new HashMap<String, EClassifier>();
    private final SelectETypeComposite.ETypeSelectionOptions eTypeSelectionOption;
    private String metamodelNsUri;

    public EClassifierSelectionControl(Composite parent, String metamodelNsUri, SelectETypeComposite.ETypeSelectionOptions eTypeSelectionOption) {
        super(parent, true, false);
        this.eTypeSelectionOption = eTypeSelectionOption;
        this.metamodelNsUri = metamodelNsUri;
    }

    public void updateList(String metamodelNsUri2) {
        this.metamodelNsUri = metamodelNsUri2;
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(this.metamodelNsUri);
        if (ePackage != null) {
            ArrayList<String> eClasses = new ArrayList<String>();
            EList eClassifiers = ePackage.getEClassifiers();
            if (this.eTypeSelectionOption == SelectETypeComposite.ETypeSelectionOptions.ECLASS) {
                for (EClassifier eClassifier : eClassifiers) {
                    if (!(eClassifier instanceof EClass)) continue;
                    eClasses.add(eClassifier.getName());
                    this.stringToEClassifierMap.put(eClassifier.getName(), eClassifier);
                }
            } else if (this.eTypeSelectionOption == SelectETypeComposite.ETypeSelectionOptions.EDATATYPE) {
                for (EClassifier eClassifier : eClassifiers) {
                    if (!(eClassifier instanceof EDataType)) continue;
                    eClasses.add(eClassifier.getName());
                    this.stringToEClassifierMap.put(eClassifier.getName(), eClassifier);
                }
            } else {
                for (EClassifier eClassifier : eClassifiers) {
                    eClasses.add(eClassifier.getName());
                    this.stringToEClassifierMap.put(eClassifier.getName(), eClassifier);
                }
            }
            if (eClasses.isEmpty()) {
                eClasses.add(Messages.No_result_found);
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
            this.setElements(eClasses.toArray());
        }
    }

    public EClassifier getSelectedEClassifier() {
        Object[] selectElements = this.getSelectedElements();
        if (selectElements != null && selectElements.length > 0 && this.stringToEClassifierMap.containsKey(selectElements[0])) {
            return this.stringToEClassifierMap.get(selectElements[0]);
        }
        return null;
    }
}

