/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.part;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.structure.DiagramStructure;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.expressions.UMLOCLFactory;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLVisualIDRegistry {
    public static final DiagramStructure TYPED_INSTANCE = new DiagramStructure(){

        public String getVisualID(View view) {
            return UMLVisualIDRegistry.getVisualID(view);
        }

        public String getModelID(View view) {
            return UMLVisualIDRegistry.getModelID(view);
        }

        public String getNodeVisualID(View containerView, EObject domainElement) {
            return UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        }

        public boolean checkNodeVisualID(View containerView, EObject domainElement, String candidate) {
            return UMLVisualIDRegistry.checkNodeVisualID(containerView, domainElement, candidate);
        }

        public boolean isCompartmentVisualID(String visualID) {
            return UMLVisualIDRegistry.isCompartmentVisualID(visualID);
        }

        public boolean isSemanticLeafVisualID(String visualID) {
            return UMLVisualIDRegistry.isSemanticLeafVisualID(visualID);
        }
    };

    public static String getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("PapyrusUMLStateMachineDiagram".equals(view.getType())) {
                return "Package_StateMachineDiagram";
            }
            return "";
        }
        return UMLVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static String getVisualID(String type) {
        return type;
    }

    public static String getType(String visualID) {
        return visualID;
    }

    public static String getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return "";
        }
        return "Package_StateMachineDiagram";
    }

    public static String getNodeVisualID(View containerView, EObject domainElement) {
        block63: {
            String containerVisualID;
            if (domainElement == null) {
                return "";
            }
            String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
            if (!"PapyrusUMLStateMachineDiagram".equals(containerModelID)) {
                return "";
            }
            if ("PapyrusUMLStateMachineDiagram".equals(containerModelID)) {
                containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
            } else if (containerView instanceof Diagram) {
                containerVisualID = "Package_StateMachineDiagram";
            } else {
                return "";
            }
            if (containerVisualID == null) break block63;
            switch (containerVisualID) {
                case "Package_StateMachineDiagram": {
                    if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) {
                        return "StateMachine_Shape";
                    }
                    if (!UMLPackage.eINSTANCE.getState().isSuperTypeOf(domainElement.eClass())) break;
                    return "State_Shape_TN";
                }
                case "StateMachine_Shape": {
                    if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_EntryPointShape(containerView, (Pseudostate)domainElement)) {
                        return "Pseudostate_EntryPointShape";
                    }
                    if (!UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isPseudostate_ExitPointShape(containerView, (Pseudostate)domainElement)) break;
                    return "Pseudostate_ExitPointShape";
                }
                case "State_Shape_TN": {
                    if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_EntryPointShape(containerView, (Pseudostate)domainElement)) {
                        return "Pseudostate_EntryPointShape";
                    }
                    if (!UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isPseudostate_ExitPointShape(containerView, (Pseudostate)domainElement)) break;
                    return "Pseudostate_ExitPointShape";
                }
                case "State_Shape": {
                    if (UMLPackage.eINSTANCE.getBehavior().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isBehavior_EntryBehaviorLabel((Behavior)domainElement)) {
                        return "Behavior_EntryBehaviorLabel";
                    }
                    if (UMLPackage.eINSTANCE.getBehavior().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isBehavior_DoActivityBehaviorLabel((Behavior)domainElement)) {
                        return "Behavior_DoActivityBehaviorLabel";
                    }
                    if (UMLPackage.eINSTANCE.getBehavior().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isBehavior_ExitBehaviorLabel((Behavior)domainElement)) {
                        return "Behavior_ExitBehaviorLabel";
                    }
                    if (UMLPackage.eINSTANCE.getTrigger().isSuperTypeOf(domainElement.eClass())) {
                        return "Trigger_DeferrableTriggerLabel";
                    }
                    if (UMLPackage.eINSTANCE.getTransition().isSuperTypeOf(domainElement.eClass())) {
                        return "Transition_InternalTransitionLabel";
                    }
                    if (UMLPackage.eINSTANCE.getRegion().isSuperTypeOf(domainElement.eClass())) {
                        return "Region_Shape";
                    }
                    if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_EntryPointShape(containerView, (Pseudostate)domainElement)) {
                        return "Pseudostate_EntryPointShape";
                    }
                    if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_ExitPointShape(containerView, (Pseudostate)domainElement)) {
                        return "Pseudostate_ExitPointShape";
                    }
                    if (!UMLPackage.eINSTANCE.getConnectionPointReference().isSuperTypeOf(domainElement.eClass())) break;
                    return "ConnectionPointReference_Shape";
                }
                case "Region_SubvertexCompartment": {
                    if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_InitialShape(containerView, (Pseudostate)domainElement)) {
                        return "Pseudostate_InitialShape";
                    }
                    if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_JoinShape(containerView, (Pseudostate)domainElement)) {
                        return "Pseudostate_JoinShape";
                    }
                    if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_ForkShape(containerView, (Pseudostate)domainElement)) {
                        return "Pseudostate_ForkShape";
                    }
                    if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_ChoiceShape(containerView, (Pseudostate)domainElement)) {
                        return "Pseudostate_ChoiceShape";
                    }
                    if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_JunctionShape(containerView, (Pseudostate)domainElement)) {
                        return "Pseudostate_JunctionShape";
                    }
                    if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_ShallowHistoryShape(containerView, (Pseudostate)domainElement)) {
                        return "Pseudostate_ShallowHistoryShape";
                    }
                    if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_DeepHistoryShape(containerView, (Pseudostate)domainElement)) {
                        return "Pseudostate_DeepHistoryShape";
                    }
                    if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_TerminateShape(containerView, (Pseudostate)domainElement)) {
                        return "Pseudostate_TerminateShape";
                    }
                    if (UMLPackage.eINSTANCE.getFinalState().isSuperTypeOf(domainElement.eClass())) {
                        return "FinalState_Shape";
                    }
                    if (UMLPackage.eINSTANCE.getState().isSuperTypeOf(domainElement.eClass())) {
                        return "State_Shape";
                    }
                    if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_EntryPointShape(containerView, (Pseudostate)domainElement)) {
                        return "Pseudostate_EntryPointShape";
                    }
                    if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_ExitPointShape(containerView, (Pseudostate)domainElement)) {
                        return "Pseudostate_ExitPointShape";
                    }
                    if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                        return "Comment_Shape";
                    }
                    if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                    return "Constraint_Shape";
                }
                case "StateMachine_RegionCompartment": {
                    if (UMLPackage.eINSTANCE.getRegion().isSuperTypeOf(domainElement.eClass())) {
                        return "Region_Shape";
                    }
                    if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_EntryPointShape(containerView, (Pseudostate)domainElement)) {
                        return "Pseudostate_EntryPointShape";
                    }
                    if (!UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isPseudostate_ExitPointShape(containerView, (Pseudostate)domainElement)) break;
                    return "Pseudostate_ExitPointShape";
                }
                case "State_RegionCompartment": {
                    if (UMLPackage.eINSTANCE.getRegion().isSuperTypeOf(domainElement.eClass())) {
                        return "Region_Shape";
                    }
                    if (!UMLPackage.eINSTANCE.getConnectionPointReference().isSuperTypeOf(domainElement.eClass())) break;
                    return "ConnectionPointReference_Shape";
                }
                case "State_RegionCompartment_TN": {
                    if (UMLPackage.eINSTANCE.getRegion().isSuperTypeOf(domainElement.eClass())) {
                        return "Region_Shape";
                    }
                    if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_EntryPointShape(containerView, (Pseudostate)domainElement)) {
                        return "Pseudostate_EntryPointShape";
                    }
                    if (!UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isPseudostate_ExitPointShape(containerView, (Pseudostate)domainElement)) break;
                    return "Pseudostate_ExitPointShape";
                }
            }
        }
        return "";
    }

    public static boolean canCreateNode(View containerView, String nodeVisualID) {
        block138: {
            String containerVisualID;
            String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
            if (!"PapyrusUMLStateMachineDiagram".equals(containerModelID)) {
                return false;
            }
            if ("PapyrusUMLStateMachineDiagram".equals(containerModelID)) {
                containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
            } else if (containerView instanceof Diagram) {
                containerVisualID = "Package_StateMachineDiagram";
            } else {
                return false;
            }
            if (containerVisualID == null) break block138;
            switch (containerVisualID) {
                case "Package_StateMachineDiagram": {
                    if ("StateMachine_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"State_Shape_TN".equals(nodeVisualID)) break;
                    return true;
                }
                case "StateMachine_Shape": {
                    if ("StateMachine_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("StateMachine_RegionCompartment".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Pseudostate_EntryPointShape".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Pseudostate_ExitPointShape".equals(nodeVisualID)) break;
                    return true;
                }
                case "State_Shape_TN": {
                    if ("State_NameLabel_TN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("State_RegionCompartment_TN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Pseudostate_EntryPointShape".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Pseudostate_ExitPointShape".equals(nodeVisualID)) break;
                    return true;
                }
                case "Region_Shape": {
                    if (!"Region_SubvertexCompartment".equals(nodeVisualID)) break;
                    return true;
                }
                case "FinalState_Shape": {
                    if ("FinalState_FloatingNameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"FinalState_StereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "State_Shape": {
                    if ("State_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("State_FloatingNameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("State_RegionCompartment".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Behavior_EntryBehaviorLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Behavior_DoActivityBehaviorLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Behavior_ExitBehaviorLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Trigger_DeferrableTriggerLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Transition_InternalTransitionLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Region_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Pseudostate_EntryPointShape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Pseudostate_ExitPointShape".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"ConnectionPointReference_Shape".equals(nodeVisualID)) break;
                    return true;
                }
                case "Pseudostate_InitialShape": {
                    if ("Pseudostate_InitialFloatingNameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Pseudostate_InitialStereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Pseudostate_JoinShape": {
                    if ("Pseudostate_JoinFloatingNameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Pseudostate_JoinStereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Pseudostate_ForkShape": {
                    if ("Pseudostate_ForkFloatingNameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Pseudostate_ForkStereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Pseudostate_ChoiceShape": {
                    if ("Pseudostate_ChoiceFloatingNameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Pseudostate_ChoiceStereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Pseudostate_JunctionShape": {
                    if ("Pseudostate_JunctionFloatingNameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Pseudostate_JunctionStereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Pseudostate_ShallowHistoryShape": {
                    if ("Pseudostate_ShallowHistoryFloatingNameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Pseudostate_ShallowHistoryStereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Pseudostate_DeepHistoryShape": {
                    if ("Pseudostate_DeepHistoryFloatingNameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Pseudostate_DeepHistoryStereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Pseudostate_TerminateShape": {
                    if ("Pseudostate_TerminateFloatingNameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Pseudostate_TerminateStereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Pseudostate_EntryPointShape": {
                    if ("Pseudostate_EntryPointFloatingNameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Pseudostate_EntryPointStereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Pseudostate_ExitPointShape": {
                    if ("Pseudostate_ExitPointFloatingNameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Pseudostate_ExitPointStereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "ConnectionPointReference_Shape": {
                    if ("ConnectionPointReference_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"ConnectionPointReference_StereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Comment_Shape": {
                    if (!"Comment_BodyLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Constraint_Shape": {
                    if ("Constraint_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Constraint_BodyLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Region_SubvertexCompartment": {
                    if ("Pseudostate_InitialShape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Pseudostate_JoinShape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Pseudostate_ForkShape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Pseudostate_ChoiceShape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Pseudostate_JunctionShape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Pseudostate_ShallowHistoryShape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Pseudostate_DeepHistoryShape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Pseudostate_TerminateShape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("FinalState_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("State_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Pseudostate_EntryPointShape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Pseudostate_ExitPointShape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Comment_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Constraint_Shape".equals(nodeVisualID)) break;
                    return true;
                }
                case "StateMachine_RegionCompartment": {
                    if ("Region_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Pseudostate_EntryPointShape".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Pseudostate_ExitPointShape".equals(nodeVisualID)) break;
                    return true;
                }
                case "State_RegionCompartment": {
                    if ("Region_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"ConnectionPointReference_Shape".equals(nodeVisualID)) break;
                    return true;
                }
                case "State_RegionCompartment_TN": {
                    if ("Region_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Pseudostate_EntryPointShape".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Pseudostate_ExitPointShape".equals(nodeVisualID)) break;
                    return true;
                }
                case "Transition_Edge": {
                    if ("Transition_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Transition_GuardLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Transition_StereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Generalization_Edge": {
                    if (!"Generalization_StereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Constraint_ContextEdge": {
                    if (!"Constraint_KeywordLabel".equals(nodeVisualID)) break;
                    return true;
                }
            }
        }
        return false;
    }

    public static String getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return "";
        }
        if (UMLPackage.eINSTANCE.getTransition().isSuperTypeOf(domainElement.eClass())) {
            return "Transition_Edge";
        }
        if (UMLPackage.eINSTANCE.getGeneralization().isSuperTypeOf(domainElement.eClass())) {
            return "Generalization_Edge";
        }
        return "";
    }

    private static boolean isPseudostate_InitialShape(View containerView, Pseudostate domainElement) {
        PseudostateKind kind;
        return domainElement instanceof Pseudostate && (kind = domainElement.getKind()).equals((Object)PseudostateKind.INITIAL_LITERAL);
    }

    private static boolean isPseudostate_JoinShape(View containerView, Pseudostate domainElement) {
        PseudostateKind kind;
        return domainElement instanceof Pseudostate && (kind = domainElement.getKind()).equals((Object)PseudostateKind.JOIN_LITERAL);
    }

    private static boolean isPseudostate_ForkShape(View containerView, Pseudostate domainElement) {
        PseudostateKind kind;
        return domainElement instanceof Pseudostate && (kind = domainElement.getKind()).equals((Object)PseudostateKind.FORK_LITERAL);
    }

    private static boolean isPseudostate_ChoiceShape(View containerView, Pseudostate domainElement) {
        PseudostateKind kind;
        return domainElement instanceof Pseudostate && (kind = domainElement.getKind()).equals((Object)PseudostateKind.CHOICE_LITERAL);
    }

    private static boolean isPseudostate_JunctionShape(View containerView, Pseudostate domainElement) {
        PseudostateKind kind;
        return domainElement instanceof Pseudostate && (kind = domainElement.getKind()).equals((Object)PseudostateKind.JUNCTION_LITERAL);
    }

    private static boolean isPseudostate_ShallowHistoryShape(View containerView, Pseudostate domainElement) {
        PseudostateKind kind;
        return domainElement instanceof Pseudostate && (kind = domainElement.getKind()).equals((Object)PseudostateKind.SHALLOW_HISTORY_LITERAL);
    }

    private static boolean isPseudostate_DeepHistoryShape(View containerView, Pseudostate domainElement) {
        PseudostateKind kind;
        return domainElement instanceof Pseudostate && (kind = domainElement.getKind()).equals((Object)PseudostateKind.DEEP_HISTORY_LITERAL);
    }

    private static boolean isPseudostate_TerminateShape(View containerView, Pseudostate domainElement) {
        PseudostateKind kind;
        return domainElement instanceof Pseudostate && (kind = domainElement.getKind()).equals((Object)PseudostateKind.TERMINATE_LITERAL);
    }

    private static boolean isPseudostate_EntryPointShape(View containerView, Pseudostate domainElement) {
        PseudostateKind kind;
        return domainElement instanceof Pseudostate && (kind = domainElement.getKind()).equals((Object)PseudostateKind.ENTRY_POINT_LITERAL);
    }

    private static boolean isPseudostate_ExitPointShape(View containerView, Pseudostate domainElement) {
        PseudostateKind kind;
        return domainElement instanceof Pseudostate && (kind = domainElement.getKind()).equals((Object)PseudostateKind.EXIT_POINT_LITERAL);
    }

    private static boolean isBehavior_EntryBehaviorLabel(Behavior domainElement) {
        Object result = UMLOCLFactory.getExpression(2, (EClassifier)UMLPackage.eINSTANCE.getBehavior(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isBehavior_DoActivityBehaviorLabel(Behavior domainElement) {
        Object result = UMLOCLFactory.getExpression(3, (EClassifier)UMLPackage.eINSTANCE.getBehavior(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isBehavior_ExitBehaviorLabel(Behavior domainElement) {
        Object result = UMLOCLFactory.getExpression(1, (EClassifier)UMLPackage.eINSTANCE.getBehavior(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    public static boolean checkNodeVisualID(View containerView, EObject domainElement, String candidate) {
        if (candidate == null) {
            return false;
        }
        String basic = UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        return candidate.equals(basic);
    }

    public static boolean isCompartmentVisualID(String visualID) {
        block13: {
            if (visualID == null) break block13;
            switch (visualID) {
                case "StateMachine_RegionCompartment": 
                case "State_RegionCompartment_TN": 
                case "Region_SubvertexCompartment": 
                case "State_RegionCompartment": {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isSemanticLeafVisualID(String visualID) {
        block46: {
            if (visualID == null) break block46;
            switch (visualID) {
                case "Package_StateMachineDiagram": {
                    return false;
                }
                case "ConnectionPointReference_Shape": 
                case "Pseudostate_ShallowHistoryShape": 
                case "Pseudostate_JunctionShape": 
                case "Pseudostate_JoinShape": 
                case "Constraint_Shape": 
                case "Pseudostate_DeepHistoryShape": 
                case "Transition_InternalTransitionLabel": 
                case "Behavior_EntryBehaviorLabel": 
                case "Pseudostate_TerminateShape": 
                case "Comment_Shape": 
                case "FinalState_Shape": 
                case "Pseudostate_ExitPointShape": 
                case "Behavior_DoActivityBehaviorLabel": 
                case "Pseudostate_ChoiceShape": 
                case "Trigger_DeferrableTriggerLabel": 
                case "Pseudostate_ForkShape": 
                case "Pseudostate_InitialShape": 
                case "Behavior_ExitBehaviorLabel": 
                case "Pseudostate_EntryPointShape": {
                    return true;
                }
            }
        }
        return false;
    }
}

