/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.parsers;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.papyrus.uml.diagram.timing.custom.Messages;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.EcoreUtils;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Duration;
import org.eclipse.uml2.uml.DurationInterval;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.TimeExpression;
import org.eclipse.uml2.uml.TimeInterval;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public class ConstraintParser
implements ISemanticParser {
    private static final String ERROR = "<error>";
    private static final Pattern pattern = Pattern.compile("\\{(.*?)\\.\\.(.*?)\\}");

    public String getPrintString(IAdaptable element, int flags) {
        return this.getEditString(element, flags);
    }

    public String getEditString(IAdaptable element, int flags) {
        Constraint constraint = ConstraintParser.doAdapt(element);
        MinMax minMax = this.getMinMax(constraint);
        if (minMax == null) {
            return ERROR;
        }
        return ConstraintParser.getMinMaxLabel(minMax);
    }

    protected static String getMinMaxLabel(MinMax minMax) {
        return "{" + minMax.getMin().stringValue() + ".." + minMax.getMax().stringValue() + "}";
    }

    public ICommand getParseCommand(IAdaptable element, String newString, int flags) {
        Constraint constraint = ConstraintParser.doAdapt(element);
        MinMax minMax = this.getMinMax(constraint);
        if (minMax == null) {
            return UnexecutableCommand.INSTANCE;
        }
        Matcher matcher = pattern.matcher(newString);
        if (matcher.matches()) {
            String min = matcher.group(1);
            String max = matcher.group(2);
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)constraint);
            return ConstraintParser.createSetMinMaxCommand(constraint, minMax, min, max, editingDomain);
        }
        return UnexecutableCommand.INSTANCE;
    }

    private MinMax getMinMax(Constraint constraint) {
        if (constraint == null) {
            return null;
        }
        ValueSpecification specification = constraint.getSpecification();
        if (specification instanceof TimeInterval) {
            return this.getTimeIntervalMinMax((TimeInterval)specification);
        }
        if (specification instanceof DurationInterval) {
            return this.getDurationIntervalMinMax((DurationInterval)specification);
        }
        return null;
    }

    private MinMax getTimeIntervalMinMax(TimeInterval timeInterval) {
        ValueSpecification min = timeInterval.getMin();
        ValueSpecification max = timeInterval.getMax();
        if (!(min instanceof TimeExpression) || !(max instanceof TimeExpression)) {
            return null;
        }
        TimeExpression minTime = (TimeExpression)min;
        TimeExpression maxTime = (TimeExpression)max;
        ValueSpecification minValue = minTime.getExpr();
        ValueSpecification maxValue = maxTime.getExpr();
        if (!(minValue instanceof LiteralString) || !(maxValue instanceof LiteralString)) {
            return null;
        }
        LiteralString minStr = (LiteralString)minValue;
        LiteralString maxStr = (LiteralString)maxValue;
        return new MinMax(minStr, maxStr);
    }

    private MinMax getDurationIntervalMinMax(DurationInterval durationInterval) {
        ValueSpecification min = durationInterval.getMin();
        ValueSpecification max = durationInterval.getMax();
        if (!(min instanceof Duration) || !(max instanceof Duration)) {
            return null;
        }
        Duration minDuration = (Duration)min;
        Duration maxDuration = (Duration)max;
        ValueSpecification minValue = minDuration.getExpr();
        ValueSpecification maxValue = maxDuration.getExpr();
        if (!(minValue instanceof LiteralString) || !(maxValue instanceof LiteralString)) {
            return null;
        }
        LiteralString minStr = (LiteralString)minValue;
        LiteralString maxStr = (LiteralString)maxValue;
        return new MinMax(minStr, maxStr);
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        return ParserEditStatus.EDITABLE_STATUS;
    }

    private static ICommand createSetMinMaxCommand(final Constraint constraint, final MinMax minMax, final String min, final String max, TransactionalEditingDomain editingDomain) {
        if (editingDomain == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return new AbstractTransactionalCommand(editingDomain, Messages.ConstraintParser_SetConstraint, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                minMax.getMin().setValue(min);
                minMax.getMax().setValue(max);
                constraint.setName(ConstraintParser.getMinMaxLabel(minMax));
                return CommandResult.newOKCommandResult();
            }
        };
    }

    protected static Constraint doAdapt(IAdaptable element) {
        Object obj = element.getAdapter(EObject.class);
        if (obj instanceof Constraint) {
            return (Constraint)obj;
        }
        return null;
    }

    public boolean isAffectingEvent(Object event, int flags) {
        return true;
    }

    public IContentAssistProcessor getCompletionProcessor(IAdaptable element) {
        return null;
    }

    public List<?> getSemanticElementsBeingParsed(EObject element) {
        Constraint constraint;
        MinMax minMax;
        ArrayList<LiteralString> list = new ArrayList<LiteralString>();
        if (element instanceof Constraint && (minMax = this.getMinMax(constraint = (Constraint)element)) != null) {
            list.add(minMax.getMin());
            list.add(minMax.getMax());
        }
        return list;
    }

    public boolean areSemanticElementsAffected(EObject listener, Object notification) {
        EStructuralFeature feature = EcoreUtils.getEStructuralFeature(notification);
        return UMLPackage.eINSTANCE.getLiteralString_Value().equals(feature);
    }

    private class MinMax {
        LiteralString min;
        LiteralString max;

        public MinMax(LiteralString min, LiteralString max) {
            this.min = min;
            this.max = max;
        }

        public LiteralString getMin() {
            return this.min;
        }

        public LiteralString getMax() {
            return this.max;
        }
    }
}

