/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.base.access;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.passage.lic.api.acquire.GrantAcquisition;

final class Residence {
    private final Path file;
    private final Logger log = LogManager.getLogger(this.getClass());

    Residence(Supplier<Path> srotage) {
        this.file = srotage.get().resolve("forsaken-grants.bin");
    }

    List<GrantAcquisition> read() {
        if (this.notWrittenYet()) {
            return Collections.emptyList();
        }
        ArrayList<GrantAcquisition> grants = new ArrayList<GrantAcquisition>();
        this.safelyAndSilently(() -> this.rawRead(grants));
        return grants;
    }

    void write(List<GrantAcquisition> grants) {
        this.checkFile();
        this.safelyAndSilently(() -> this.rawWrite(grants));
    }

    private void rawWrite(List<GrantAcquisition> grants) throws Exception {
        this.checkFile();
        Throwable throwable = null;
        Object var3_4 = null;
        try (ObjectOutputStream stream = new ObjectOutputStream(new FileOutputStream(this.file.toFile()));){
            stream.writeInt(grants.size());
            for (GrantAcquisition grant : grants) {
                stream.writeObject(grant);
            }
            stream.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void rawRead(List<GrantAcquisition> grants) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ObjectInputStream stream = new ObjectInputStream(new FileInputStream(this.file.toFile()));){
            int amount = stream.readInt();
            int i = 0;
            while (i < amount) {
                grants.add((GrantAcquisition)stream.readObject());
                ++i;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safelyAndSilently(Operation operation) {
        String path;
        String string = path = this.file.toFile().getAbsolutePath().intern();
        synchronized (string) {
            try {
                operation.run();
            }
            catch (Exception e) {
                this.log.error("Forsaken grants residence operation fails", (Throwable)e);
            }
        }
    }

    private boolean notWrittenYet() {
        return !Files.exists(this.file, new LinkOption[0]) || !Files.isRegularFile(this.file, new LinkOption[0]);
    }

    private void checkFile() {
        Path owner;
        if (Files.exists(this.file, new LinkOption[0])) {
            ArrayList<String> message = new ArrayList<String>();
            if (Files.isDirectory(this.file, new LinkOption[0])) {
                message.add("directory");
            }
            if (!Files.isReadable(this.file)) {
                message.add("not readable");
            }
            if (!Files.isWritable(this.file)) {
                message.add("not writable");
            }
            if (!message.isEmpty()) {
                this.log.error(String.format("Forsaken grant residence will constantly fail to operate: residence file [%s] is %s", this.file.toAbsolutePath(), message.stream().collect(Collectors.joining(", "))));
            }
        }
        if (!Files.exists(owner = this.file.getParent(), new LinkOption[0])) {
            boolean successful = this.file.toFile().mkdirs();
            if (!successful) {
                this.log.error(String.format("Forsaken grant residence will constantly fail to operate: failed to create folder structure [%s]", this.file.toAbsolutePath()));
            }
        } else if (!Files.isExecutable(owner)) {
            this.log.error(String.format("Forsaken grant residence will constantly fail to operate: folder [%s] is not executable", owner.toAbsolutePath()));
        }
    }

    private static interface Operation {
        public void run() throws Exception;
    }
}

