/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.sync.ui.menus;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ptp.internal.rdt.sync.ui.RDTSyncUIPlugin;
import org.eclipse.ptp.internal.rdt.sync.ui.SyncMergeFileTableViewer;
import org.eclipse.ptp.internal.rdt.sync.ui.handlers.CommonSyncExceptionHandler;
import org.eclipse.ptp.internal.rdt.sync.ui.messages.Messages;
import org.eclipse.ptp.internal.rdt.sync.ui.preferences.SyncFileFilterDialog;
import org.eclipse.ptp.internal.rdt.sync.ui.properties.ManageConfigurationDialog;
import org.eclipse.ptp.rdt.sync.core.AbstractSyncFileFilter;
import org.eclipse.ptp.rdt.sync.core.SyncConfigManager;
import org.eclipse.ptp.rdt.sync.core.SyncFlag;
import org.eclipse.ptp.rdt.sync.core.SyncManager;
import org.eclipse.ptp.rdt.sync.core.handlers.ISyncExceptionHandler;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;

public class SyncMenuOperation
extends AbstractHandler
implements IElementUpdater {
    private static final String SYNC_COMMAND_PARAMETER_ID = "org.eclipse.ptp.rdt.sync.ui.syncCommand.syncModeParameter";
    private static final String syncActiveCommand = "sync_active";
    private static final String syncAllCommand = "sync_all";
    private static final String setNoneCommand = "set_none";
    private static final String setActiveCommand = "set_active";
    private static final String setActiveBeforeBuildCommand = "set_active_before_build";
    private static final String setAllCommand = "set_all";
    private static final String syncAutoCommand = "sync_auto";
    private static final String syncFileList = "sync_file_list";
    private static final String syncDefaultFileList = "sync_default_file_list";
    private static final String syncExcludeCommand = "sync_exclude";
    private static final String syncIncludeCommand = "sync_include";
    private static final String checkoutCommand = "checkout";
    private static final String resolveAsRemoteCommand = "checkout_remote_copy";
    private static final String resolveMergeCommand = "resolve";
    private static final String manageCommand = "manage";
    private static final ISyncExceptionHandler syncExceptionHandler = new CommonSyncExceptionHandler(false, true);

    /*
     * Unable to fully structure code
     */
    public Object execute(ExecutionEvent event) {
        block31: {
            command = event.getParameter("org.eclipse.ptp.rdt.sync.ui.syncCommand.syncModeParameter");
            sel = this.getSelectedElements();
            if (sel == null || sel.getFirstElement() == null) {
                return null;
            }
            project = this.getProject(sel);
            if (project == null) {
                RDTSyncUIPlugin.getDefault().logErrorMessage(Messages.SyncMenuOperation_0);
                return null;
            }
            try {
                block34: {
                    block32: {
                        if (command.equals("sync_active")) {
                            SyncManager.sync(null, (IProject)project, (Set)SyncFlag.BOTH, (ISyncExceptionHandler)SyncMenuOperation.syncExceptionHandler);
                            break block31;
                        }
                        if (command.equals("sync_all")) {
                            SyncManager.syncAll(null, (IProject)project, (Set)SyncFlag.BOTH, (ISyncExceptionHandler)SyncMenuOperation.syncExceptionHandler);
                            break block31;
                        }
                        if (command.equals("set_active")) {
                            SyncManager.setSyncMode((IProject)project, (SyncManager.SyncMode)SyncManager.SyncMode.ACTIVE);
                            SyncManager.sync(null, (IProject)project, (Set)SyncFlag.BOTH, (ISyncExceptionHandler)SyncMenuOperation.syncExceptionHandler);
                            break block31;
                        }
                        if (command.equals("set_all")) {
                            SyncManager.setSyncMode((IProject)project, (SyncManager.SyncMode)SyncManager.SyncMode.ALL);
                            SyncManager.syncAll(null, (IProject)project, (Set)SyncFlag.BOTH, (ISyncExceptionHandler)SyncMenuOperation.syncExceptionHandler);
                            break block31;
                        }
                        if (command.equals("set_none")) {
                            SyncManager.setSyncMode((IProject)project, (SyncManager.SyncMode)SyncManager.SyncMode.NONE);
                            break block31;
                        }
                        if (command.equals("set_active_before_build")) {
                            SyncManager.setSyncMode((IProject)project, (SyncManager.SyncMode)SyncManager.SyncMode.ACTIVE_BEFORE_BUILD);
                            break block31;
                        }
                        if (command.equals("sync_auto")) {
                            SyncManager.setSyncAuto((boolean)(SyncManager.getSyncAuto() == false));
                            if (SyncManager.getSyncAuto()) {
                                syncMode = SyncManager.getSyncMode((IProject)project);
                                if (syncMode == SyncManager.SyncMode.ACTIVE) {
                                    SyncManager.sync(null, (IProject)project, (Set)SyncFlag.BOTH, (ISyncExceptionHandler)SyncMenuOperation.syncExceptionHandler);
                                } else if (syncMode == SyncManager.SyncMode.ALL) {
                                    SyncManager.syncAll(null, (IProject)project, (Set)SyncFlag.BOTH, (ISyncExceptionHandler)SyncMenuOperation.syncExceptionHandler);
                                }
                            }
                            break block31;
                        }
                        if (!command.equals("sync_exclude") && !command.equals("sync_include")) break block32;
                        sff = SyncManager.getFileFilter((IProject)project);
                        exclude = command.equals("sync_exclude");
                        var10_10 = sel.toArray();
                        var9_12 = var10_10.length;
                        var8_14 = 0;
                        while (var8_14 < var9_12) {
                            block33: {
                                element = var10_10[var8_14];
                                if (!(element instanceof IResource)) break block33;
                                selection = (IResource)element;
                                ** GOTO lbl62
                            }
                            if (!(element instanceof IAdaptable)) {
                                RDTSyncUIPlugin.getDefault().logErrorMessage(Messages.SyncMenuOperation_6);
                            } else {
                                selection = (IResource)((IAdaptable)element).getAdapter(IResource.class);
lbl62:
                                // 2 sources

                                sff.addPattern(selection, exclude);
                            }
                            ++var8_14;
                        }
                        try {
                            SyncManager.saveFileFilter((IProject)project, (AbstractSyncFileFilter)sff);
                        }
                        catch (CoreException e) {
                            RDTSyncUIPlugin.log(e);
                        }
                        break block31;
                    }
                    if (command.equals("sync_file_list")) {
                        SyncFileFilterDialog.open(HandlerUtil.getActiveShell((ExecutionEvent)event), project);
                        break block31;
                    }
                    if (command.equals("sync_default_file_list")) {
                        SyncFileFilterDialog.open(HandlerUtil.getActiveShell((ExecutionEvent)event), null);
                        break block31;
                    }
                    if (!command.equals("checkout") && !command.equals("resolve") && !command.equals("checkout_remote_copy")) break block34;
                    currentSyncServiceId = SyncConfigManager.getActive((IProject)project).getSyncProviderId();
                    syncService = SyncManager.getSyncService((String)currentSyncServiceId);
                    paths = new ArrayList<IPath>();
                    var11_20 = sel.toArray();
                    var10_11 = var11_20.length;
                    var9_13 = 0;
                    while (var9_13 < var10_11) {
                        block35: {
                            element = var11_20[var9_13];
                            if (!(element instanceof IResource)) break block35;
                            selection = (IResource)element;
                            ** GOTO lbl97
                        }
                        if (!(element instanceof IAdaptable)) {
                            RDTSyncUIPlugin.getDefault().logErrorMessage(Messages.SyncMenuOperation_6);
                        } else {
                            selection = (IResource)((IAdaptable)element).getAdapter(IResource.class);
lbl97:
                            // 2 sources

                            paths.add(selection.getProjectRelativePath());
                        }
                        ++var9_13;
                    }
                    if (command.equals("checkout")) {
                        syncService.checkout(project, paths.toArray(new IPath[paths.size()]));
                    }
                    if (command.equals("checkout_remote_copy")) {
                        syncService.checkoutRemoteCopy(project, paths.toArray(new IPath[paths.size()]));
                    }
                    if (command.equals("resolve") || command.equals("checkout_remote_copy")) {
                        syncService.setMergeAsResolved(project, paths.toArray(new IPath[paths.size()]));
                        viewer = SyncMergeFileTableViewer.getActiveInstance();
                        if (viewer != null) {
                            viewer.update(null);
                        }
                    }
                    break block31;
                }
                if (command.equals("manage")) {
                    new ManageConfigurationDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), project).open();
                }
            }
            catch (CoreException e) {
                RDTSyncUIPlugin.getDefault().logErrorMessage(Messages.SyncMenuOperation_1);
            }
        }
        window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        if (window != null) {
            service = (ICommandService)window.getService(ICommandService.class);
            service.refreshElements(event.getCommand().getId(), null);
        }
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        String command = (String)parameters.get(SYNC_COMMAND_PARAMETER_ID);
        if (command == null) {
            RDTSyncUIPlugin.getDefault().logErrorMessage(Messages.SyncMenuOperation_2);
            return;
        }
        IStructuredSelection sel = this.getSelectedElements();
        IProject project = this.getProject(sel);
        if (project == null) {
            return;
        }
        SyncManager.SyncMode syncMode = SyncManager.getSyncMode((IProject)project);
        if (command.equals(setActiveCommand) && syncMode == SyncManager.SyncMode.ACTIVE || command.equals(setActiveBeforeBuildCommand) && syncMode == SyncManager.SyncMode.ACTIVE_BEFORE_BUILD || command.equals(setAllCommand) && syncMode == SyncManager.SyncMode.ALL || command.equals(setNoneCommand) && (syncMode == SyncManager.SyncMode.NONE || syncMode == SyncManager.SyncMode.UNAVAILABLE) || command.equals(syncAutoCommand) && SyncManager.getSyncAuto()) {
            element.setChecked(true);
        } else {
            element.setChecked(false);
        }
    }

    private IProject getProject(IStructuredSelection selection) {
        if (selection == null) {
            return null;
        }
        Object firstElement = selection.getFirstElement();
        if (!(firstElement instanceof IAdaptable)) {
            return null;
        }
        Object o = ((IAdaptable)firstElement).getAdapter(IResource.class);
        if (o == null) {
            return null;
        }
        IResource resource = (IResource)o;
        return resource.getProject();
    }

    private IStructuredSelection getSelectedElements() {
        IWorkbenchWindow wnd = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage pg = wnd.getActivePage();
        ISelection sel = pg.getSelection();
        if (!(sel instanceof IStructuredSelection)) {
            return null;
        }
        return (IStructuredSelection)sel;
    }
}

