/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.internal.debug.core;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.rcptt.ecl.debug.model.Variable;
import org.eclipse.rcptt.ecl.internal.debug.core.EclDebugElement;
import org.eclipse.rcptt.ecl.internal.debug.core.EclDebugTarget;
import org.eclipse.rcptt.ecl.internal.debug.core.EclDebugThread;
import org.eclipse.rcptt.ecl.internal.debug.core.EclVariable;
import org.eclipse.rcptt.ecl.runtime.BoxedValues;

public class EclValue
extends EclDebugElement
implements IValue {
    private final EclDebugThread thread;
    private Variable arg;
    private IVariable[] children;
    private boolean resolved = false;

    public EclValue(EclDebugThread thread, Variable arg) {
        this.thread = thread;
        this.setVariable(arg);
    }

    public IDebugTarget getDebugTarget() {
        return this.thread.getDebugTarget();
    }

    public String getReferenceTypeName() throws DebugException {
        return this.arg.getType();
    }

    public String getValueString() throws DebugException {
        Object object = BoxedValues.unbox((Object)this.arg.getValue());
        if (object != null) {
            return object.toString();
        }
        return this.arg.getType();
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public IVariable[] getVariables() throws DebugException {
        this.resolve();
        return this.children;
    }

    public boolean hasVariables() throws DebugException {
        this.resolve();
        return !this.arg.getChildren().isEmpty();
    }

    private void resolve() {
        if (!this.resolved) {
            this.resolved = true;
            if (this.arg.isComplex()) {
                ((EclDebugTarget)this.getDebugTarget()).resolveVariable(this.arg, this);
            }
        }
    }

    public void setVariable(Variable var) {
        this.arg = var;
        EList list = this.arg.getChildren();
        this.children = new IVariable[list.size()];
        int i = 0;
        while (i < list.size()) {
            this.children[i] = new EclVariable(this.thread, (Variable)list.get(i));
            ++i;
        }
    }
}

