/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.query;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.query.ResourceQuery;
import org.eclipse.sirius.business.api.query.SiriusReferenceFinder;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSession;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.description.DAnnotation;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class EObjectQuery {
    protected ECrossReferenceAdapter xref;
    private org.eclipse.sirius.model.business.internal.query.EObjectQuery internalQuery;

    public EObjectQuery(EObject eObject) {
        this.internalQuery = new org.eclipse.sirius.model.business.internal.query.EObjectQuery(eObject);
    }

    public EObjectQuery(EObject eObject, ECrossReferenceAdapter xref) {
        this(eObject);
        this.xref = xref;
    }

    public Option<DRepresentation> getRepresentation() {
        return this.internalQuery.getRepresentation();
    }

    public EObject getResourceContainer() {
        return this.internalQuery.getResourceContainer();
    }

    public Option<EObject> getFirstAncestorOfType(EClass klass) {
        return this.internalQuery.getFirstAncestorOfType(klass);
    }

    public Collection<EObject> getInverseReferences(final String featureName) {
        Objects.requireNonNull(featureName);
        return this.getInverseReferences(new Predicate<EStructuralFeature.Setting>(){

            public boolean apply(EStructuralFeature.Setting input) {
                return input != null && input.getEStructuralFeature() != null && featureName.equals(input.getEStructuralFeature().getName());
            }
        });
    }

    public Collection<EObject> getInverseReferences(final EReference ref) {
        Objects.requireNonNull(ref);
        return this.getInverseReferences(new Predicate<EStructuralFeature.Setting>(){

            public boolean apply(EStructuralFeature.Setting input) {
                return input != null && ref.equals(input.getEStructuralFeature());
            }
        });
    }

    public Collection<EObject> getInverseReferences(final Set<EReference> refs) {
        Objects.requireNonNull(refs);
        return this.getInverseReferences(new Predicate<EStructuralFeature.Setting>(){

            public boolean apply(EStructuralFeature.Setting input) {
                return input != null && refs.contains(input.getEStructuralFeature());
            }
        });
    }

    private Collection<EObject> getInverseReferences(Predicate<EStructuralFeature.Setting> predicate) {
        Session session;
        Objects.requireNonNull(predicate);
        if (this.xref == null && (session = this.getSession()) != null) {
            this.xref = session.getSemanticCrossReferencer();
        }
        if (this.xref == null) {
            return Collections.emptySet();
        }
        HashSet<EObject> result = new HashSet<EObject>();
        for (EStructuralFeature.Setting setting : Iterables.filter((Iterable)this.xref.getInverseReferences(this.internalQuery.getEObject()), predicate)) {
            result.add(setting.getEObject());
        }
        return result;
    }

    public List<DRepresentationDescriptor> getImpactedRepDescriptorFromDAnnotationData(String sourceKey) {
        Collection<EObject> inverseReferences = this.getInverseReferences(DescriptionPackage.eINSTANCE.getDAnnotation_References());
        return inverseReferences.stream().map(DAnnotation.class::cast).filter(annot -> sourceKey != null ? sourceKey.equals(annot.getSource()) : true).map(annot -> annot.eContainer()).filter(DRepresentationDescriptor.class::isInstance).map(DRepresentationDescriptor.class::cast).collect(Collectors.toList());
    }

    public Session getSession() {
        EObject eObject = this.internalQuery.getEObject();
        Session found = SessionManager.INSTANCE.getSession(eObject);
        if (found == null) {
            try {
                Resource res;
                EObject root = EcoreUtil.getRootContainer((EObject)eObject);
                Resource resource = res = root != null ? root.eResource() : null;
                if (res != null) {
                    ResourceQuery resourceQuery = new ResourceQuery(res);
                    if (resourceQuery.isRepresentationsResource()) {
                        found = this.getSessionFromAirdResource(res);
                    } else if (resourceQuery.isSrmResource()) {
                        found = this.getSessionFromSrmResource(res);
                    }
                }
            }
            catch (IllegalStateException illegalStateException) {}
        }
        return found;
    }

    private Session getSessionFromSrmResource(Resource srmResource) {
        return Optional.ofNullable(new EObjectQuery((EObject)srmResource.getContents().get(0)).getDAnalysis()).map(EObject::eResource).map(res -> this.getSessionFromAirdResource((Resource)res)).orElse(null);
    }

    private Session getSessionFromAirdResource(Resource airdResource) {
        Session found = null;
        Iterator<Session> sessions = SessionManager.INSTANCE.getSessions().iterator();
        while (sessions.hasNext() && found == null) {
            Session sess = sessions.next();
            if (!(sess instanceof DAnalysisSession) || !sess.getAllSessionResources().contains(airdResource)) continue;
            found = sess;
        }
        return found;
    }

    public Collection<URI> getResolvedDependencies() {
        return this.internalQuery.getResolvedDependencies();
    }

    public Collection<URI> getUnresolvedDependencies() {
        return this.internalQuery.getUnresolvedDependencies();
    }

    public List<EObject> getValues(EReference ref) {
        return this.internalQuery.getValues(ref);
    }

    public boolean isContainedIn(EObject parentToCheck) {
        return this.internalQuery.isContainedIn(parentToCheck);
    }

    public Collection<Viewpoint> getAvailableViewpointsInResourceSet() {
        return this.internalQuery.getAvailableViewpointsInResourceSet();
    }

    public DAnalysis getDAnalysis() {
        return this.internalQuery.getDAnalysis();
    }

    public SiriusReferenceFinder getSiriusReferenceFinder() {
        SiriusReferenceFinder inverseCrossRef = Optional.ofNullable(this.getSession()).filter(DAnalysisSessionImpl.class::isInstance).map(DAnalysisSessionImpl.class::cast).map(DAnalysisSessionImpl::getSiriusReferenceFinder).orElse(null);
        return inverseCrossRef;
    }

    public String getGenericDecription() {
        return this.internalQuery.getGenericDecription();
    }
}

