/**
 * Copyright (c) 2010-2012, Balazs Grill, Istvan Rath and Daniel Varro
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-v20.html.
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.viatra.query.tooling.ui.migrator;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.osgi.framework.Version;

@SuppressWarnings("all")
public abstract class JavaProjectMigratorData {
  protected static final VersionRange stable = new VersionRange(new Version(2, 0, 0), true, new Version(3, 0, 0), false);
  
  protected static final VersionRange incubation = new VersionRange(new Version(0, 20, 0), true, new Version(0, 21, 0), false);
  
  protected static final LinkedHashMap<String, String> bundleRenames = CollectionLiterals.<String, String>newLinkedHashMap(
    Pair.<String, String>of("org.eclipse.incquery.databinding.runtime", "org.eclipse.viatra.addon.databinding.runtime"), 
    Pair.<String, String>of("org.eclipse.incquery.facet.browser", "org.eclipse.viatra.integration.modisco"), 
    Pair.<String, String>of("org.eclipse.incquery.patternlanguage", "org.eclipse.viatra.query.patternlanguage"), 
    Pair.<String, String>of("org.eclipse.incquery.patternlanguage.emf", "org.eclipse.viatra.query.patternlanguage.emf"), 
    Pair.<String, String>of("org.eclipse.incquery.patternlanguage.emf.tests", "org.eclipse.viatra.query.patternlanguage.emf.tests"), 
    Pair.<String, String>of("org.eclipse.incquery.patternlanguage.emf.ui", "org.eclipse.viatra.query.patternlanguage.emf.ui"), 
    Pair.<String, String>of("org.eclipse.incquery.patternlanguage.generator", "org.eclipse.viatra.query.patternlanguage.generator"), 
    Pair.<String, String>of("org.eclipse.incquery.patternlanguage.tests", "org.eclipse.viatra.query.patternlanguage.tests"), 
    Pair.<String, String>of("org.eclipse.incquery.patternlanguage.ui", "org.eclipse.viatra.query.patternlanguage.ui"), 
    Pair.<String, String>of("org.eclipse.incquery.querybasedfeatures.runtime", "org.eclipse.viatra.addon.querybasedfeatures.runtime"), 
    Pair.<String, String>of("org.eclipse.incquery.querybasedfeatures.tooling", "org.eclipse.viatra.addon.querybasedfeatures.tooling"), 
    Pair.<String, String>of("org.eclipse.incquery.runtime", "org.eclipse.viatra.query.runtime"), 
    Pair.<String, String>of("org.eclipse.incquery.runtime.base", "org.eclipse.viatra.query.runtime.base"), 
    Pair.<String, String>of("org.eclipse.incquery.runtime.base.itc", "org.eclipse.viatra.query.runtime.base.itc"), 
    Pair.<String, String>of("org.eclipse.incquery.runtime.base.itc.tests", "org.eclipse.viatra.query.runtime.base.itc.tests"), 
    Pair.<String, String>of("org.eclipse.incquery.runtime.evm", "org.eclipse.viatra.transformation.evm"), 
    Pair.<String, String>of("org.eclipse.incquery.runtime.evm.transactions", "org.eclipse.viatra.transformation.evm.transactions"), 
    Pair.<String, String>of("org.eclipse.incquery.runtime.gmf", "org.eclipse.viatra.integration.gmf"), 
    Pair.<String, String>of("org.eclipse.incquery.runtime.graphiti", "org.eclipse.viatra.integration.graphiti"), 
    Pair.<String, String>of("org.eclipse.incquery.runtime.localsearch", "org.eclipse.viatra.query.runtime.localsearch"), 
    Pair.<String, String>of("org.eclipse.incquery.runtime.matchers", "org.eclipse.viatra.query.runtime.matchers"), 
    Pair.<String, String>of("org.eclipse.incquery.runtime.rete", "org.eclipse.viatra.query.runtime.rete"), 
    Pair.<String, String>of("org.eclipse.incquery.runtime.rete.recipes", "org.eclipse.viatra.query.runtime.rete.recipes"), 
    Pair.<String, String>of("org.eclipse.incquery.runtime.tests", "org.eclipse.viatra.query.runtime.tests"), 
    Pair.<String, String>of("org.eclipse.incquery.snapshot", "org.eclipse.viatra.query.testing.snapshot"), 
    Pair.<String, String>of("org.eclipse.incquery.snapshot.edit", "org.eclipse.viatra.query.testing.snapshot.edit"), 
    Pair.<String, String>of("org.eclipse.incquery.snapshot.editor", "org.eclipse.viatra.query.testing.snapshot.editor"), 
    Pair.<String, String>of("org.eclipse.incquery.testing.core", "org.eclipse.viatra.query.testing.core"), 
    Pair.<String, String>of("org.eclipse.incquery.testing.ui", "org.eclipse.viatra.query.testing.ui"), 
    Pair.<String, String>of("org.eclipse.incquery.tooling.core", "org.eclipse.viatra.query.tooling.core"), 
    Pair.<String, String>of("org.eclipse.incquery.tooling.debug", "org.eclipse.viatra.query.tooling.debug"), 
    Pair.<String, String>of("org.eclipse.incquery.tooling.generator.model", "org.eclipse.viatra.query.tooling.generator.model"), 
    Pair.<String, String>of("org.eclipse.incquery.tooling.generator.model.ui", "org.eclipse.viatra.query.tooling.generator.model.ui"), 
    Pair.<String, String>of("org.eclipse.incquery.tooling.localsearch.ui", "org.eclipse.viatra.query.tooling.localsearch.ui"), 
    Pair.<String, String>of("org.eclipse.incquery.tooling.ui", "org.eclipse.viatra.query.tooling.ui"), 
    Pair.<String, String>of("org.eclipse.incquery.tooling.ui.retevis", "org.eclipse.viatra.query.tooling.ui.retevis"), 
    Pair.<String, String>of("org.eclipse.incquery.uml", "org.eclipse.viatra.integration.uml"), 
    Pair.<String, String>of("org.eclipse.incquery.uml.test", "org.eclipse.viatra.integration.uml.test"), 
    Pair.<String, String>of("org.eclipse.incquery.validation.core", "org.eclipse.viatra.addon.validation.core"), 
    Pair.<String, String>of("org.eclipse.incquery.validation.runtime", "org.eclipse.viatra.addon.validation.runtime"), 
    Pair.<String, String>of("org.eclipse.incquery.validation.runtime.ui", "org.eclipse.viatra.addon.validation.runtime.ui"), 
    Pair.<String, String>of("org.eclipse.incquery.validation.tooling", "org.eclipse.viatra.addon.validation.tooling"), 
    Pair.<String, String>of("org.eclipse.incquery.viewers.runtime", "org.eclipse.viatra.addon.viewers.runtime"), 
    Pair.<String, String>of("org.eclipse.incquery.viewers.runtime.zest", "org.eclipse.viatra.addon.viewers.runtime.zest"), 
    Pair.<String, String>of("org.eclipse.incquery.viewers.tooling.ui", "org.eclipse.viatra.addon.viewers.tooling.ui"), 
    Pair.<String, String>of("org.eclipse.incquery.viewers.tooling.ui.zest", "org.eclipse.viatra.addon.viewers.tooling.zest.ui"), 
    Pair.<String, String>of("org.eclipse.incquery.viewmodel", "org.eclipse.viatra.transformation.views"), 
    Pair.<String, String>of("org.eclipse.incquery.xcore", "org.eclipse.viatra.integration.xcore"), 
    Pair.<String, String>of("org.eclipse.incquery.xcore.model", "org.eclipse.viatra.integration.xcore.model"), 
    Pair.<String, String>of("org.eclipse.incquery.xcore.modeleditor", "org.eclipse.viatra.integration.xcore.modeleditor"), 
    Pair.<String, String>of("org.eclipse.incquery.xcore.ui", "org.eclipse.viatra.integration.xcore.ui"), 
    Pair.<String, String>of("org.eclipse.viatra.emf.mwe2integration", "org.eclipse.viatra.integration.mwe2"), 
    Pair.<String, String>of("org.eclipse.viatra.emf.mwe2integration.debug", "org.eclipse.viatra.integration.mwe2.debug"), 
    Pair.<String, String>of("org.eclipse.viatra.emf.mwe2integration.test", "org.eclipse.viatra.integration.mwe2.test"), 
    Pair.<String, String>of("org.eclipse.viatra.emf.runtime", "org.eclipse.viatra.transformation.runtime.emf"), 
    Pair.<String, String>of("org.eclipse.viatra.emf.runtime.debug", "org.eclipse.viatra.transformation.debug"), 
    Pair.<String, String>of("org.eclipse.viatra.emf.runtime.debug.ui", "org.eclipse.viatra.transformation.debug.ui"), 
    Pair.<String, String>of("org.eclipse.viatra.emf.runtime.tracer", "org.eclipse.viatra.transformation.tracer"));
  
  protected static final LinkedHashMap<String, VersionRange> bundleVersions = CollectionLiterals.<String, VersionRange>newLinkedHashMap(
    Pair.<String, VersionRange>of("org.eclipse.viatra.addon.databinding.runtime", JavaProjectMigratorData.stable), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.integration.modisco", JavaProjectMigratorData.incubation), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.query.patternlanguage", JavaProjectMigratorData.stable), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.query.patternlanguage.emf", JavaProjectMigratorData.stable), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.query.patternlanguage.emf.tests", JavaProjectMigratorData.stable), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.query.patternlanguage.emf.ui", JavaProjectMigratorData.stable), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.query.patternlanguage.generator", JavaProjectMigratorData.stable), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.query.patternlanguage.tests", JavaProjectMigratorData.stable), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.query.patternlanguage.ui", JavaProjectMigratorData.stable), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.addon.querybasedfeatures.runtime", JavaProjectMigratorData.stable), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.addon.querybasedfeatures.tooling", JavaProjectMigratorData.stable), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.query.runtime", JavaProjectMigratorData.stable), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.query.runtime.base", JavaProjectMigratorData.stable), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.query.runtime.base.itc", JavaProjectMigratorData.stable), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.query.runtime.base.itc.tests", JavaProjectMigratorData.stable), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.transformation.evm", JavaProjectMigratorData.stable), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.transformation.evm.transactions", JavaProjectMigratorData.stable), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.integration.gmf", JavaProjectMigratorData.stable), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.integration.graphiti", JavaProjectMigratorData.incubation), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.query.runtime.localsearch", JavaProjectMigratorData.stable), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.query.runtime.matchers", JavaProjectMigratorData.stable), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.query.runtime.rete", JavaProjectMigratorData.stable), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.query.runtime.rete.recipes", JavaProjectMigratorData.stable), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.query.runtime.tests", JavaProjectMigratorData.stable), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.query.testing.snapshot", JavaProjectMigratorData.stable), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.query.testing.snapshot.edit", JavaProjectMigratorData.stable), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.query.testing.snapshot.editor", JavaProjectMigratorData.stable), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.query.testing.core", JavaProjectMigratorData.stable), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.query.testing.queries", JavaProjectMigratorData.stable), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.query.testing.ui", JavaProjectMigratorData.stable), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.query.tooling.core", JavaProjectMigratorData.stable), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.query.tooling.debug", JavaProjectMigratorData.stable), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.query.tooling.generator.model", JavaProjectMigratorData.stable), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.query.tooling.generator.model.ui", JavaProjectMigratorData.stable), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.query.tooling.localsearch.ui", JavaProjectMigratorData.incubation), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.query.tooling.ui", JavaProjectMigratorData.stable), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.query.tooling.ui.retevis", JavaProjectMigratorData.incubation), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.integration.uml", JavaProjectMigratorData.stable), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.integration.uml.test", JavaProjectMigratorData.stable), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.addon.validation.core", JavaProjectMigratorData.stable), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.addon.validation.runtime", JavaProjectMigratorData.stable), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.addon.validation.runtime.ui", JavaProjectMigratorData.stable), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.addon.validation.tooling", JavaProjectMigratorData.stable), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.addon.viewers.runtime", JavaProjectMigratorData.incubation), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.addon.viewers.runtime.zest", JavaProjectMigratorData.incubation), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.addon.viewers.tooling.ui", JavaProjectMigratorData.incubation), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.addon.viewers.tooling.ui.zest", JavaProjectMigratorData.incubation), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.transformation.views", JavaProjectMigratorData.incubation), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.integration.xcore", JavaProjectMigratorData.incubation), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.integration.xcore.model", JavaProjectMigratorData.incubation), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.integration.xcore.modeleditor", JavaProjectMigratorData.incubation), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.integration.xcore.ui", JavaProjectMigratorData.incubation), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.integration.mwe2", JavaProjectMigratorData.incubation), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.integration.mwe2.debug", JavaProjectMigratorData.incubation), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.integration.mwe2.test", JavaProjectMigratorData.incubation), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.transformation.runtime.emf", JavaProjectMigratorData.stable), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.transformation.debug", JavaProjectMigratorData.incubation), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.transformation.debug.ui", JavaProjectMigratorData.incubation), 
    Pair.<String, VersionRange>of("org.eclipse.viatra.transformation.tracer", JavaProjectMigratorData.incubation));
  
  /**
   * Package or Type renames. Shall be fully qualified.
   * 
   * Package names shall be end with '.' while type names shall be not. List shall be ordered so for every entry key
   * there is no prefix is present in the preceding entry keys. Bundle renames are added automatically
   */
  protected static final Map<String, String> qualifiedNameRenames = JavaProjectMigratorData.initQualifiedRenames();
  
  public static Map<String, String> initQualifiedRenames() {
    Pair<String, String> _mappedTo = Pair.<String, String>of("org.eclipse.incquery.runtime.api.AdvancedIncQueryEngine", "org.eclipse.viatra.query.runtime.api.AdvancedViatraQueryEngine");
    Pair<String, String> _mappedTo_1 = Pair.<String, String>of("org.eclipse.incquery.runtime.api.IncQueryEngine", "org.eclipse.viatra.query.runtime.api.ViatraQueryEngine");
    Pair<String, String> _mappedTo_2 = Pair.<String, String>of("org.eclipse.incquery.runtime.api.IncQueryMatcher", "org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher");
    Pair<String, String> _mappedTo_3 = Pair.<String, String>of("org.eclipse.incquery.runtime.api.impl.BasePatternGroup", "org.eclipse.viatra.query.runtime.api.impl.BaseQueryGroup");
    Pair<String, String> _mappedTo_4 = Pair.<String, String>of("org.eclipse.incquery.runtime.api.PackageBasedPatternGroup", "org.eclipse.viatra.query.runtime.api.PackageBasedQueryGroup");
    Pair<String, String> _mappedTo_5 = Pair.<String, String>of("org.eclipse.incquery.runtime.api.GenericPatternGroup", "org.eclipse.viatra.query.runtime.api.GenericQueryGroup");
    Pair<String, String> _mappedTo_6 = Pair.<String, String>of("org.eclipse.incquery.runtime.api.IncQueryEngineManager", "org.eclipse.viatra.query.runtime.api.ViatraQueryEngineManager");
    Pair<String, String> _mappedTo_7 = Pair.<String, String>of("org.eclipse.incquery.runtime.api.IncQueryEngineLifecycleListener", "org.eclipse.viatra.query.runtime.api.ViatraQueryEngineLifecycleListener");
    Pair<String, String> _mappedTo_8 = Pair.<String, String>of("org.eclipse.incquery.runtime.api.IncQueryModelUpdateListener", "org.eclipse.viatra.query.runtime.api.ViatraQueryModelUpdateListener");
    Pair<String, String> _mappedTo_9 = Pair.<String, String>of("org.eclipse.incquery.runtime.api.IncQueryEngineInitializationListener", "org.eclipse.viatra.query.runtime.api.ViatraQueryEngineInitializationListener");
    Pair<String, String> _mappedTo_10 = Pair.<String, String>of("org.eclipse.incquery.runtime.internal.api.impl.IncQueryEngineImpl", "org.eclipse.viatra.query.runtime.internal.api.impl.ViatraQueryEngineImpl");
    Pair<String, String> _mappedTo_11 = Pair.<String, String>of("org.eclipse.viatra.emf.runtime.update.IQEngineUpdateCompleteProvider", "org.eclipse.viatra.transformation.evm.update.QueryEngineUpdateCompleteProvider");
    Pair<String, String> _mappedTo_12 = Pair.<String, String>of("org.eclipse.incquery.runtime.exception.IncQueryException", "org.eclipse.viatra.query.runtime.exception.ViatraQueryException");
    Pair<String, String> _mappedTo_13 = Pair.<String, String>of("org.eclipse.incquery.runtime.util.IncQueryLoggingUtil", "org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil");
    Pair<String, String> _mappedTo_14 = Pair.<String, String>of("org.eclipse.incquery.runtime.api.scope.IncQueryScope", "org.eclipse.viatra.query.runtime.api.scope.QueryScope");
    Pair<String, String> _mappedTo_15 = Pair.<String, String>of("org.eclipse.incquery.runtime.emf.helper.IncQueryRuntimeHelper", "org.eclipse.viatra.query.runtime.emf.helper.ViatraQueryRuntimeHelper");
    Pair<String, String> _mappedTo_16 = Pair.<String, String>of("org.eclipse.incquery.runtime.evm.specific.event.IncQueryEventRealm", "org.eclipse.viatra.transformation.evm.specific.event.ViatraQueryEventRealm");
    Pair<String, String> _mappedTo_17 = Pair.<String, String>of("org.eclipse.incquery.runtime.evm.specific.event.IncQueryEventSource", "org.eclipse.viatra.transformation.evm.specific.event.ViatraQueryEventSource");
    Pair<String, String> _mappedTo_18 = Pair.<String, String>of("org.eclipse.incquery.runtime.evm.specific.event.IncQueryEventSourceSpecification", "org.eclipse.viatra.transformation.evm.specific.event.ViatraQueryEventSourceSpecification");
    Pair<String, String> _mappedTo_19 = Pair.<String, String>of("org.eclipse.incquery.runtime.evm.specific.event.IncQuerySinglePatternMatchEventFilter", "org.eclipse.viatra.transformation.evm.specific.event.ViatraQueryMatchEventFilter");
    Pair<String, String> _mappedTo_20 = Pair.<String, String>of("org.eclipse.incquery.runtime.evm.specific.event.IncQueryMultiPatternMatchEventFilter", "org.eclipse.viatra.transformation.evm.specific.event.ViatraQueryMultiMatchEventFilter");
    Pair<String, String> _mappedTo_21 = Pair.<String, String>of("org.eclipse.incquery.runtime.evm.specific.event.IncQueryFilterSemantics", "org.eclipse.viatra.transformation.evm.specific.event.ViatraQueryFilterSemantics");
    Pair<String, String> _mappedTo_22 = Pair.<String, String>of("org.eclipse.incquery.runtime.evm.specific.event.IncQueryEventHandler", "org.eclipse.viatra.transformation.evm.specific.event.ViatraQueryEventHandler");
    Pair<String, String> _mappedTo_23 = Pair.<String, String>of("org.eclipse.incquery.runtime.evm.specific.event.IncQueryRuleInstanceBuilder", "org.eclipse.viatra.transformation.evm.specific.event.ViatraQueryRuleInstanceBuilder");
    Pair<String, String> _mappedTo_24 = Pair.<String, String>of("org.eclipse.incquery.runtime.evm.specific.event.IncQueryActivationStateEnum", "org.eclipse.viatra.transformation.evm.specific.crud.CRUDActivationStateEnum");
    Pair<String, String> _mappedTo_25 = Pair.<String, String>of("org.eclipse.incquery.runtime.evm.specific.event.IncQueryEvent", "org.eclipse.viatra.transformation.evm.specific.event.ViatraQueryEvent");
    Pair<String, String> _mappedTo_26 = Pair.<String, String>of("org.eclipse.incquery.runtime.evm.specific.event.IncQueryEventTypeEnum", "org.eclipse.viatra.transformation.evm.specific.crud.CRUDEventTypeEnum");
    Pair<String, String> _mappedTo_27 = Pair.<String, String>of("org.eclipse.incquery.runtime.evm.specific.TransactionalSchedulers", "org.eclipse.viatra.transformation.evm.transactions.specific.TransactionalSchedulers");
    Pair<String, String> _mappedTo_28 = Pair.<String, String>of("org.eclipse.incquery.runtime.evm.specific.TransactionalJobs", "org.eclipse.viatra.transformation.evm.transactions.specific.TransactionalJobs");
    Pair<String, String> _mappedTo_29 = Pair.<String, String>of("org.eclipse.incquery.runtime.evm.specific.job.CommandExecutingJob", "org.eclipse.viatra.transformation.evm.transactions.specific.job.CommandExecutingJob");
    Pair<String, String> _mappedTo_30 = Pair.<String, String>of("org.eclipse.incquery.runtime.evm.specific.job.EventAtomEditingDomainProvider", "org.eclipse.viatra.transformation.evm.transactions.specific.job.EventAtomEditingDomainProvider");
    Pair<String, String> _mappedTo_31 = Pair.<String, String>of("org.eclipse.incquery.runtime.evm.specific.job.RecordingJob", "org.eclipse.viatra.transformation.evm.transactions.specific.job.RecordingJob");
    Pair<String, String> _mappedTo_32 = Pair.<String, String>of("org.eclipse.incquery.runtime.evm.update.TransactionUpdateCompleteProvider", "org.eclipse.viatra.transformation.evm.transactions.update.TransactionUpdateCompleteProvider");
    Pair<String, String> _mappedTo_33 = Pair.<String, String>of("org.eclipse.incquery.runtime.base.exception.IncQueryBaseException", "org.eclipse.viatra.query.runtime.base.exception.ViatraBaseException");
    Pair<String, String> _mappedTo_34 = Pair.<String, String>of("org.eclipse.incquery.runtime.base.api.IncQueryBaseFactory", "org.eclipse.viatra.query.runtime.base.api.ViatraBaseFactory");
    Pair<String, String> _mappedTo_35 = Pair.<String, String>of("org.eclipse.incquery.runtime.base.api.scope.IncQueryBaseIndexChangeListener", "org.eclipse.viatra.query.runtime.api.scope.ViatraBaseIndexChangeListener");
    Pair<String, String> _mappedTo_36 = Pair.<String, String>of("org.eclipse.viatra.cep.core.api.events.ParameterizableIncQueryPatternEventInstance", "org.eclipse.viatra.cep.core.api.events.ParameterizableViatraQueryPatternEventInstance");
    Pair<String, String> _mappedTo_37 = Pair.<String, String>of("org.eclipse.incquery.databinding.runtime.api.IncQueryObservables", "org.eclipse.viatra.addon.databinding.runtime.api.ViatraObservables");
    Pair<String, String> _mappedTo_38 = Pair.<String, String>of("org.eclipse.incquery.databinding.runtime.api.IncQueryHeadlessRealm", "org.eclipse.viatra.addon.databinding.runtime.api.ViatraHeadlessRealm");
    Pair<String, String> _mappedTo_39 = Pair.<String, String>of("org.eclipse.incquery.tooling.core.generator.genmodel.IEiqGenmodelProvider", "org.eclipse.viatra.query.tooling.core.generator.genmodel.IVQGenmodelProvider");
    Pair<String, String> _mappedTo_40 = Pair.<String, String>of("org.eclipse.incquery.tooling.generator.model.generatorModel.IncQueryGeneratorModel", "org.eclipse.viatra.query.tooling.generator.model.generatorModel.ViatraQueryGeneratorModel");
    Pair<String, String> _mappedTo_41 = Pair.<String, String>of("org.eclipse.incquery.viewers.runtime.IncQueryViewerSupport", "org.eclipse.viatra.addon.viewers.runtime.ViatraViewerSupport");
    Pair<String, String> _mappedTo_42 = Pair.<String, String>of("org.eclipse.incquery.viewers.runtime.extensions.jface.IncQueryViewersJFaceViewSupport", "org.eclipse.viatra.addon.viewers.runtime.extensions.jface.ViatraViewersJFaceViewSupport");
    Pair<String, String> _mappedTo_43 = Pair.<String, String>of("org.eclipse.incquery.viewers.runtime.extensions.IncQueryViewersViewSupport", "org.eclipse.viatra.addon.viewers.runtime.extensions.ViatraViewersViewSupport");
    Pair<String, String> _mappedTo_44 = Pair.<String, String>of("org.eclipse.incquery.viewers.runtime.extensions.IncQueryViewersPartSupport", "org.eclipse.viatra.addon.viewers.runtime.extensions.ViatraViewersPartSupport");
    Pair<String, String> _mappedTo_45 = Pair.<String, String>of("org.eclipse.incquery.viewers.runtime.zest.IncQueryGraphViewers", "org.eclipse.viatra.addon.viewers.runtime.zest.ViatraGraphViewers");
    Pair<String, String> _mappedTo_46 = Pair.<String, String>of("org.eclipse.incquery.viewers.runtime.model.IncQueryViewerDataModel", "org.eclipse.viatra.addon.viewers.runtime.model.ViatraViewerDataModel");
    Pair<String, String> _mappedTo_47 = Pair.<String, String>of("org.eclipse.incquery.viewers.runtime.zest.extensions.IncQueryViewersZestViewSupport", "org.eclipse.viatra.addon.viewers.runtime.zest.extensions.ViatraViewersZestViewSupport");
    Pair<String, String> _mappedTo_48 = Pair.<String, String>of("org.eclipse.viatra.addon.viewers.runtime.model.Containment", "org.eclipse.viatra.addon.viewers.runtime.notation.Containment");
    Pair<String, String> _mappedTo_49 = Pair.<String, String>of("org.eclipse.viatra.addon.viewers.runtime.model.Edge", "org.eclipse.viatra.addon.viewers.runtime.notation.Edge");
    Pair<String, String> _mappedTo_50 = Pair.<String, String>of("org.eclipse.viatra.addon.viewers.runtime.model.Item", "org.eclipse.viatra.addon.viewers.runtime.notation.Item");
    Pair<String, String> _mappedTo_51 = Pair.<String, String>of("org.eclipse.viatra.query.runtime.base.itc.alg.incscc.Direction", "org.eclipse.viatra.query.runtime.matchers.util.Direction");
    Pair<String, String> _mappedTo_52 = Pair.<String, String>of("org.eclipse.viatra.query.runtime.base.itc.alg.incscc.UnionFind", "org.eclipse.viatra.query.runtime.matchers.algorithms.UnionFind");
    Pair<String, String> _mappedTo_53 = Pair.<String, String>of("org.eclipse.viatra.query.patternlanguage.patternLanguage", "org.eclipse.viatra.query.patternlanguage.emf.vql");
    Pair<String, String> _mappedTo_54 = Pair.<String, String>of("org.eclipse.viatra.query.patternlanguage.patternLanguage.impl", "org.eclipse.viatra.query.patternlanguage.emf.vql.impl");
    Pair<String, String> _mappedTo_55 = Pair.<String, String>of("org.eclipse.viatra.query.patternlanguage.patternLanguage.util", "org.eclipse.viatra.query.patternlanguage.emf.vql.util");
    Pair<String, String> _mappedTo_56 = Pair.<String, String>of("org.eclipse.viatra.query.patternlanguage.emf.eMFPatternLanguage", "org.eclipse.viatra.query.patternlanguage.emf.vql");
    Pair<String, String> _mappedTo_57 = Pair.<String, String>of("org.eclipse.viatra.query.patternlanguage.emf.eMFPatternLanguage.impl", "org.eclipse.viatra.query.patternlanguage.emf.vql.impl");
    Pair<String, String> _mappedTo_58 = Pair.<String, String>of("org.eclipse.viatra.query.patternlanguage.emf.eMFPatternLanguage.util", "org.eclipse.viatra.query.patternlanguage.emf.vql.util");
    Pair<String, String> _mappedTo_59 = Pair.<String, String>of("org.eclipse.viatra.query.patternlanguage.helper.CorePatternLanguageHelper", "org.eclipse.viatra.query.patternlanguage.emf.helper.PatternLanguageHelper");
    Pair<String, String> _mappedTo_60 = Pair.<String, String>of("org.eclipse.viatra.query.patternlanguage.emf.helper.EMFPatternLanguageHelper", "org.eclipse.viatra.query.patternlanguage.emf.helper.PatternLanguageHelper");
    final LinkedHashMap<String, String> result = CollectionLiterals.<String, String>newLinkedHashMap(_mappedTo, _mappedTo_1, _mappedTo_2, _mappedTo_3, _mappedTo_4, _mappedTo_5, _mappedTo_6, _mappedTo_7, _mappedTo_8, _mappedTo_9, _mappedTo_10, _mappedTo_11, _mappedTo_12, _mappedTo_13, _mappedTo_14, _mappedTo_15, _mappedTo_16, _mappedTo_17, _mappedTo_18, _mappedTo_19, _mappedTo_20, _mappedTo_21, _mappedTo_22, _mappedTo_23, _mappedTo_24, _mappedTo_25, _mappedTo_26, _mappedTo_27, _mappedTo_28, _mappedTo_29, _mappedTo_30, _mappedTo_31, _mappedTo_32, _mappedTo_33, _mappedTo_34, _mappedTo_35, _mappedTo_36, _mappedTo_37, _mappedTo_38, _mappedTo_39, _mappedTo_40, _mappedTo_41, _mappedTo_42, _mappedTo_43, _mappedTo_44, _mappedTo_45, _mappedTo_46, _mappedTo_47, _mappedTo_48, _mappedTo_49, _mappedTo_50, _mappedTo_51, _mappedTo_52, _mappedTo_53, _mappedTo_54, _mappedTo_55, _mappedTo_56, _mappedTo_57, _mappedTo_58, _mappedTo_59, _mappedTo_60);
    Set<Map.Entry<String, String>> _entrySet = JavaProjectMigratorData.bundleRenames.entrySet();
    List<Map.Entry<String, String>> _sortWith = IterableExtensions.<Map.Entry<String, String>>sortWith(_entrySet, new Comparator<Map.Entry<String, String>>() {
      @Override
      public int compare(final Map.Entry<String, String> o1, final Map.Entry<String, String> o2) {
        return Integer.compare(o2.getKey().length(), o1.getKey().length());
      }
    });
    for (final Map.Entry<String, String> entry : _sortWith) {
      String _key = entry.getKey();
      String _plus = (_key + ".");
      String _value = entry.getValue();
      String _plus_1 = (_value + ".");
      result.put(_plus, _plus_1);
    }
    return result;
  }
}
