/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.network;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.viatra.query.runtime.matchers.context.IPosetComparator;
import org.eclipse.viatra.query.runtime.matchers.psystem.IExpressionEvaluator;
import org.eclipse.viatra.query.runtime.matchers.psystem.aggregations.IMultisetAggregationOperator;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;
import org.eclipse.viatra.query.runtime.rete.aggregation.ColumnAggregatorNode;
import org.eclipse.viatra.query.runtime.rete.aggregation.CountNode;
import org.eclipse.viatra.query.runtime.rete.aggregation.IAggregatorNode;
import org.eclipse.viatra.query.runtime.rete.aggregation.timely.FaithfulParallelTimelyColumnAggregatorNode;
import org.eclipse.viatra.query.runtime.rete.aggregation.timely.FaithfulSequentialTimelyColumnAggregatorNode;
import org.eclipse.viatra.query.runtime.rete.aggregation.timely.FirstOnlyParallelTimelyColumnAggregatorNode;
import org.eclipse.viatra.query.runtime.rete.aggregation.timely.FirstOnlySequentialTimelyColumnAggregatorNode;
import org.eclipse.viatra.query.runtime.rete.boundary.ExternalInputEnumeratorNode;
import org.eclipse.viatra.query.runtime.rete.boundary.ExternalInputStatelessFilterNode;
import org.eclipse.viatra.query.runtime.rete.eval.EvaluatorCore;
import org.eclipse.viatra.query.runtime.rete.eval.MemorylessEvaluatorNode;
import org.eclipse.viatra.query.runtime.rete.eval.OutputCachingEvaluatorNode;
import org.eclipse.viatra.query.runtime.rete.index.ExistenceNode;
import org.eclipse.viatra.query.runtime.rete.index.Indexer;
import org.eclipse.viatra.query.runtime.rete.index.JoinNode;
import org.eclipse.viatra.query.runtime.rete.matcher.TimelyConfiguration;
import org.eclipse.viatra.query.runtime.rete.misc.ConstantNode;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.Supplier;
import org.eclipse.viatra.query.runtime.rete.recipes.AggregatorIndexerRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.AntiJoinRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.CheckRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.ConstantRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.CountAggregatorRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.DiscriminatorBucketRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.DiscriminatorDispatcherRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.EqualityFilterRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.EvalRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.ExpressionDefinition;
import org.eclipse.viatra.query.runtime.rete.recipes.ExpressionEnforcerRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.IndexerRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.InequalityFilterRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.InputFilterRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.InputRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.JoinRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.Mask;
import org.eclipse.viatra.query.runtime.rete.recipes.ProductionRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.ProjectionIndexerRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.ReteNodeRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.SemiJoinRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.SingleColumnAggregatorRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.TransitiveClosureRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.TransparentRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.TrimmerRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.UniquenessEnforcerRecipe;
import org.eclipse.viatra.query.runtime.rete.single.DefaultProductionNode;
import org.eclipse.viatra.query.runtime.rete.single.DiscriminatorBucketNode;
import org.eclipse.viatra.query.runtime.rete.single.DiscriminatorDispatcherNode;
import org.eclipse.viatra.query.runtime.rete.single.EqualityFilterNode;
import org.eclipse.viatra.query.runtime.rete.single.InequalityFilterNode;
import org.eclipse.viatra.query.runtime.rete.single.TimelyProductionNode;
import org.eclipse.viatra.query.runtime.rete.single.TimelyUniquenessEnforcerNode;
import org.eclipse.viatra.query.runtime.rete.single.TransitiveClosureNode;
import org.eclipse.viatra.query.runtime.rete.single.TransparentNode;
import org.eclipse.viatra.query.runtime.rete.single.TrimmerNode;
import org.eclipse.viatra.query.runtime.rete.single.UniquenessEnforcerNode;
import org.eclipse.viatra.query.runtime.rete.traceability.TraceInfo;

class NodeFactory {
    Logger logger;

    public NodeFactory(Logger logger) {
        this.logger = logger;
    }

    public Indexer createIndexer(ReteContainer reteContainer, IndexerRecipe recipe, Supplier parentNode, TraceInfo ... traces) {
        if (recipe instanceof ProjectionIndexerRecipe) {
            return parentNode.constructIndex(this.toMask(recipe.getMask()), traces);
        }
        if (recipe instanceof AggregatorIndexerRecipe) {
            int indexOfAggregateResult = recipe.getParent().getArity();
            int resultPosition = recipe.getMask().getSourceIndices().lastIndexOf((Object)indexOfAggregateResult);
            IAggregatorNode aggregatorNode = (IAggregatorNode)((Object)parentNode);
            Indexer result = resultPosition == -1 ? aggregatorNode.getAggregatorOuterIndexer() : aggregatorNode.getAggregatorOuterIdentityIndexer(resultPosition);
            TraceInfo[] traceInfoArray = traces;
            int n = traces.length;
            int n2 = 0;
            while (n2 < n) {
                TraceInfo traceInfo = traceInfoArray[n2];
                result.assignTraceInfo(traceInfo);
                ++n2;
            }
            return result;
        }
        throw new IllegalArgumentException("Unkown Indexer recipe: " + recipe);
    }

    public Supplier createNode(ReteContainer reteContainer, ReteNodeRecipe recipe, TraceInfo ... traces) {
        if (recipe instanceof IndexerRecipe) {
            throw new IllegalArgumentException("Indexers are not created by NodeFactory: " + recipe);
        }
        Supplier result = this.instantiateNodeDispatch(reteContainer, recipe);
        TraceInfo[] traceInfoArray = traces;
        int n = traces.length;
        int n2 = 0;
        while (n2 < n) {
            TraceInfo traceInfo = traceInfoArray[n2];
            result.assignTraceInfo(traceInfo);
            ++n2;
        }
        return result;
    }

    private Supplier instantiateNodeDispatch(ReteContainer reteContainer, ReteNodeRecipe recipe) {
        if (recipe instanceof ConstantRecipe) {
            return this.instantiateNode(reteContainer, (ConstantRecipe)recipe);
        }
        if (recipe instanceof InputRecipe) {
            return this.instantiateNode(reteContainer, (InputRecipe)recipe);
        }
        if (recipe instanceof InputFilterRecipe) {
            return this.instantiateNode(reteContainer, (InputFilterRecipe)recipe);
        }
        if (recipe instanceof InequalityFilterRecipe) {
            return this.instantiateNode(reteContainer, (InequalityFilterRecipe)recipe);
        }
        if (recipe instanceof EqualityFilterRecipe) {
            return this.instantiateNode(reteContainer, (EqualityFilterRecipe)recipe);
        }
        if (recipe instanceof TransparentRecipe) {
            return this.instantiateNode(reteContainer, (TransparentRecipe)recipe);
        }
        if (recipe instanceof TrimmerRecipe) {
            return this.instantiateNode(reteContainer, (TrimmerRecipe)recipe);
        }
        if (recipe instanceof TransitiveClosureRecipe) {
            return this.instantiateNode(reteContainer, (TransitiveClosureRecipe)recipe);
        }
        if (recipe instanceof ExpressionEnforcerRecipe) {
            return this.instantiateNode(reteContainer, (ExpressionEnforcerRecipe)recipe);
        }
        if (recipe instanceof CountAggregatorRecipe) {
            return this.instantiateNode(reteContainer, (CountAggregatorRecipe)recipe);
        }
        if (recipe instanceof SingleColumnAggregatorRecipe) {
            return this.instantiateNode(reteContainer, (SingleColumnAggregatorRecipe)recipe);
        }
        if (recipe instanceof DiscriminatorDispatcherRecipe) {
            return this.instantiateNode(reteContainer, (DiscriminatorDispatcherRecipe)recipe);
        }
        if (recipe instanceof DiscriminatorBucketRecipe) {
            return this.instantiateNode(reteContainer, (DiscriminatorBucketRecipe)recipe);
        }
        if (recipe instanceof UniquenessEnforcerRecipe) {
            return this.instantiateNode(reteContainer, (UniquenessEnforcerRecipe)recipe);
        }
        if (recipe instanceof ProductionRecipe) {
            return this.instantiateNode(reteContainer, (ProductionRecipe)recipe);
        }
        if (recipe instanceof JoinRecipe) {
            return this.instantiateNode(reteContainer, (JoinRecipe)recipe);
        }
        if (recipe instanceof SemiJoinRecipe) {
            return this.instantiateNode(reteContainer, (SemiJoinRecipe)recipe);
        }
        if (recipe instanceof AntiJoinRecipe) {
            return this.instantiateNode(reteContainer, (AntiJoinRecipe)recipe);
        }
        throw new IllegalArgumentException("Unsupported recipe type: " + recipe);
    }

    private Supplier instantiateNode(ReteContainer reteContainer, InputRecipe recipe) {
        return new ExternalInputEnumeratorNode(reteContainer);
    }

    private Supplier instantiateNode(ReteContainer reteContainer, InputFilterRecipe recipe) {
        return new ExternalInputStatelessFilterNode(reteContainer, this.toMaskOrNull(recipe.getMask()));
    }

    private Supplier instantiateNode(ReteContainer reteContainer, CountAggregatorRecipe recipe) {
        return new CountNode(reteContainer);
    }

    private Supplier instantiateNode(ReteContainer reteContainer, TransparentRecipe recipe) {
        return new TransparentNode(reteContainer);
    }

    private Supplier instantiateNode(ReteContainer reteContainer, ExpressionEnforcerRecipe recipe) {
        IExpressionEvaluator evaluator = this.toIExpressionEvaluator(recipe.getExpression());
        Map<String, Integer> posMapping = this.toStringIndexMap((EMap<String, Integer>)recipe.getMappedIndices());
        int sourceTupleWidth = recipe.getParent().getArity();
        EvaluatorCore core = null;
        if (recipe instanceof CheckRecipe) {
            core = new EvaluatorCore.PredicateEvaluatorCore(this.logger, evaluator, posMapping, sourceTupleWidth);
        } else if (recipe instanceof EvalRecipe) {
            boolean isUnwinding = ((EvalRecipe)recipe).isUnwinding();
            core = new EvaluatorCore.FunctionEvaluatorCore(this.logger, evaluator, posMapping, sourceTupleWidth, isUnwinding);
        } else {
            throw new IllegalArgumentException("Unhandled expression enforcer recipe: " + recipe.getClass() + "!");
        }
        if (recipe.isCacheOutput()) {
            return new OutputCachingEvaluatorNode(reteContainer, core);
        }
        return new MemorylessEvaluatorNode(reteContainer, core);
    }

    private Supplier instantiateNode(ReteContainer reteContainer, SingleColumnAggregatorRecipe recipe) {
        IMultisetAggregationOperator operator = recipe.getMultisetAggregationOperator();
        TupleMask coreMask = null;
        coreMask = recipe.getOptionalMonotonicityInfo() != null ? this.toMask(recipe.getOptionalMonotonicityInfo().getCoreMask()) : this.toMask(recipe.getGroupByMask());
        if (reteContainer.isTimelyEvaluation()) {
            TimelyConfiguration timelyConfiguration = reteContainer.getTimelyConfiguration();
            TimelyConfiguration.AggregatorArchitecture aggregatorArchitecture = timelyConfiguration.getAggregatorArchitecture();
            TimelyConfiguration.TimelineRepresentation timelineRepresentation = timelyConfiguration.getTimelineRepresentation();
            TupleMask posetMask = null;
            if (recipe.getOptionalMonotonicityInfo() != null) {
                posetMask = this.toMask(recipe.getOptionalMonotonicityInfo().getPosetMask());
            } else {
                int aggregatedColumn = recipe.getAggregableIndex();
                posetMask = TupleMask.selectSingle((int)aggregatedColumn, (int)coreMask.sourceWidth);
            }
            if (timelineRepresentation == TimelyConfiguration.TimelineRepresentation.FIRST_ONLY && aggregatorArchitecture == TimelyConfiguration.AggregatorArchitecture.SEQUENTIAL) {
                return new FirstOnlySequentialTimelyColumnAggregatorNode(reteContainer, operator, coreMask, posetMask);
            }
            if (timelineRepresentation == TimelyConfiguration.TimelineRepresentation.FIRST_ONLY && aggregatorArchitecture == TimelyConfiguration.AggregatorArchitecture.PARALLEL) {
                return new FirstOnlyParallelTimelyColumnAggregatorNode(reteContainer, operator, coreMask, posetMask);
            }
            if (timelineRepresentation == TimelyConfiguration.TimelineRepresentation.FAITHFUL && aggregatorArchitecture == TimelyConfiguration.AggregatorArchitecture.SEQUENTIAL) {
                return new FaithfulSequentialTimelyColumnAggregatorNode(reteContainer, operator, coreMask, posetMask);
            }
            if (timelineRepresentation == TimelyConfiguration.TimelineRepresentation.FAITHFUL && aggregatorArchitecture == TimelyConfiguration.AggregatorArchitecture.PARALLEL) {
                return new FaithfulParallelTimelyColumnAggregatorNode(reteContainer, operator, coreMask, posetMask);
            }
            throw new IllegalArgumentException("Unsupported timely configuration!");
        }
        if (recipe.isDeleteRederiveEvaluation() && recipe.getOptionalMonotonicityInfo() != null) {
            TupleMask posetMask = this.toMask(recipe.getOptionalMonotonicityInfo().getPosetMask());
            IPosetComparator posetComparator = (IPosetComparator)recipe.getOptionalMonotonicityInfo().getPosetComparator();
            return new ColumnAggregatorNode(reteContainer, operator, recipe.isDeleteRederiveEvaluation(), coreMask, posetMask, posetComparator);
        }
        int aggregatedColumn = recipe.getAggregableIndex();
        return new ColumnAggregatorNode(reteContainer, operator, coreMask, aggregatedColumn);
    }

    private Supplier instantiateNode(ReteContainer reteContainer, TransitiveClosureRecipe recipe) {
        return new TransitiveClosureNode(reteContainer);
    }

    private Supplier instantiateNode(ReteContainer reteContainer, ProductionRecipe recipe) {
        if (reteContainer.isTimelyEvaluation()) {
            return new TimelyProductionNode(reteContainer, this.toStringIndexMap((EMap<String, Integer>)recipe.getMappedIndices()));
        }
        if (recipe.isDeleteRederiveEvaluation() && recipe.getOptionalMonotonicityInfo() != null) {
            TupleMask coreMask = this.toMask(recipe.getOptionalMonotonicityInfo().getCoreMask());
            TupleMask posetMask = this.toMask(recipe.getOptionalMonotonicityInfo().getPosetMask());
            IPosetComparator posetComparator = (IPosetComparator)recipe.getOptionalMonotonicityInfo().getPosetComparator();
            return new DefaultProductionNode(reteContainer, this.toStringIndexMap((EMap<String, Integer>)recipe.getMappedIndices()), recipe.isDeleteRederiveEvaluation(), coreMask, posetMask, posetComparator);
        }
        return new DefaultProductionNode(reteContainer, this.toStringIndexMap((EMap<String, Integer>)recipe.getMappedIndices()), recipe.isDeleteRederiveEvaluation());
    }

    private Supplier instantiateNode(ReteContainer reteContainer, UniquenessEnforcerRecipe recipe) {
        if (reteContainer.isTimelyEvaluation()) {
            return new TimelyUniquenessEnforcerNode(reteContainer, recipe.getArity());
        }
        if (recipe.isDeleteRederiveEvaluation() && recipe.getOptionalMonotonicityInfo() != null) {
            TupleMask coreMask = this.toMask(recipe.getOptionalMonotonicityInfo().getCoreMask());
            TupleMask posetMask = this.toMask(recipe.getOptionalMonotonicityInfo().getPosetMask());
            IPosetComparator posetComparator = (IPosetComparator)recipe.getOptionalMonotonicityInfo().getPosetComparator();
            return new UniquenessEnforcerNode(reteContainer, recipe.getArity(), recipe.isDeleteRederiveEvaluation(), coreMask, posetMask, posetComparator);
        }
        return new UniquenessEnforcerNode(reteContainer, recipe.getArity(), recipe.isDeleteRederiveEvaluation());
    }

    private Supplier instantiateNode(ReteContainer reteContainer, ConstantRecipe recipe) {
        EList constantValues = recipe.getConstantValues();
        Object[] constantArray = constantValues.toArray(new Object[constantValues.size()]);
        return new ConstantNode(reteContainer, Tuples.flatTupleOf((Object[])constantArray));
    }

    private Supplier instantiateNode(ReteContainer reteContainer, DiscriminatorBucketRecipe recipe) {
        return new DiscriminatorBucketNode(reteContainer, recipe.getBucketKey());
    }

    private Supplier instantiateNode(ReteContainer reteContainer, DiscriminatorDispatcherRecipe recipe) {
        return new DiscriminatorDispatcherNode(reteContainer, recipe.getDiscriminationColumnIndex());
    }

    private Supplier instantiateNode(ReteContainer reteContainer, TrimmerRecipe recipe) {
        return new TrimmerNode(reteContainer, this.toMask(recipe.getMask()));
    }

    private Supplier instantiateNode(ReteContainer reteContainer, InequalityFilterRecipe recipe) {
        InequalityFilterNode result = new InequalityFilterNode(reteContainer, recipe.getSubject(), TupleMask.fromSelectedIndices((int)recipe.getParent().getArity(), (Collection)recipe.getInequals()));
        return result;
    }

    private Supplier instantiateNode(ReteContainer reteContainer, EqualityFilterRecipe recipe) {
        int[] equalIndices = TupleMask.integersToIntArray((Collection)recipe.getIndices());
        return new EqualityFilterNode(reteContainer, equalIndices);
    }

    private Supplier instantiateNode(ReteContainer reteContainer, AntiJoinRecipe recipe) {
        return new ExistenceNode(reteContainer, true);
    }

    private Supplier instantiateNode(ReteContainer reteContainer, SemiJoinRecipe recipe) {
        return new ExistenceNode(reteContainer, false);
    }

    private Supplier instantiateNode(ReteContainer reteContainer, JoinRecipe recipe) {
        return new JoinNode(reteContainer, this.toMask(recipe.getRightParentComplementaryMask()));
    }

    private IExpressionEvaluator toIExpressionEvaluator(ExpressionDefinition expressionDefinition) {
        Object evaluator = expressionDefinition.getEvaluator();
        if (evaluator instanceof IExpressionEvaluator) {
            return (IExpressionEvaluator)evaluator;
        }
        throw new IllegalArgumentException("No runtime support for expression definition: " + evaluator);
    }

    private Map<String, Integer> toStringIndexMap(EMap<String, Integer> mappedIndices) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (Map.Entry entry : mappedIndices) {
            result.put((String)entry.getKey(), (Integer)entry.getValue());
        }
        return result;
    }

    private TupleMask toMaskOrNull(Mask mask) {
        if (mask == null) {
            return null;
        }
        return this.toMask(mask);
    }

    private TupleMask toMask(Mask mask) {
        return TupleMask.fromSelectedIndices((int)mask.getSourceArity(), (Collection)mask.getSourceIndices());
    }
}

