/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.order;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.description.MethodDescription;
import org.eclipse.wb.internal.core.model.order.MethodOrderAfter;
import org.eclipse.wb.internal.core.model.order.MethodOrderAfterAssociation;
import org.eclipse.wb.internal.core.model.order.MethodOrderAfterChildren;
import org.eclipse.wb.internal.core.model.order.MethodOrderAfterCreation;
import org.eclipse.wb.internal.core.model.order.MethodOrderAfterParentChildren;
import org.eclipse.wb.internal.core.model.order.MethodOrderBeforeAssociation;
import org.eclipse.wb.internal.core.model.order.MethodOrderDefault;
import org.eclipse.wb.internal.core.model.order.MethodOrderFirst;
import org.eclipse.wb.internal.core.model.order.MethodOrderLast;
import org.eclipse.wb.internal.core.model.variable.ThisVariableSupport;
import org.eclipse.wb.internal.core.utils.Pair;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;

public abstract class MethodOrder {
    public static final MethodOrder DEFAULT = new MethodOrderDefault();

    public static MethodOrder parse(String specification) {
        if (specification.startsWith("first")) {
            return new MethodOrderFirst();
        }
        if (specification.startsWith("afterCreation")) {
            return new MethodOrderAfterCreation();
        }
        if (specification.startsWith("beforeAssociation")) {
            return new MethodOrderBeforeAssociation();
        }
        if (specification.startsWith("afterAssociation")) {
            return new MethodOrderAfterAssociation();
        }
        if (specification.startsWith("after ")) {
            String targetSignature = specification.substring("after ".length());
            return new MethodOrderAfter(targetSignature);
        }
        if (specification.startsWith("afterChildren ")) {
            String targetChild = specification.substring("afterChildren ".length());
            return new MethodOrderAfterChildren(targetChild);
        }
        if (specification.startsWith("afterParentChildren ")) {
            String targetChild = specification.substring("afterParentChildren ".length());
            return new MethodOrderAfterParentChildren(targetChild);
        }
        if (specification.equals("last")) {
            return new MethodOrderLast();
        }
        throw new IllegalArgumentException("Unsupported order specification: " + specification);
    }

    public abstract boolean canReference(JavaInfo var1);

    public final StatementTarget getTarget(JavaInfo javaInfo, String newSignature) throws Exception {
        TypeDeclaration typeDeclaration;
        MethodDeclaration targetMethod;
        String targetMethodSignature;
        MethodDescription newDescription;
        for (Pair<MethodInvocation, MethodOrder> pair : MethodOrder.getInvocationOrders(javaInfo)) {
            MethodOrderAfter afterOrder;
            MethodInvocation existingInvocation = (MethodInvocation)pair.getLeft();
            MethodOrder existingOrder = (MethodOrder)pair.getRight();
            if (!(existingOrder instanceof MethodOrderAfter) || !(afterOrder = (MethodOrderAfter)existingOrder).isTarget(newSignature)) continue;
            Statement statement = AstNodeUtils.getEnclosingStatement((ASTNode)existingInvocation);
            return new StatementTarget(statement, true);
        }
        if (javaInfo.getVariableSupport() instanceof ThisVariableSupport && (newDescription = javaInfo.getDescription().getMethod(newSignature)) != null && (targetMethodSignature = newDescription.getTag("thisTargetMethod")) != null && (targetMethod = AstNodeUtils.getMethodBySignature(typeDeclaration = JavaInfoUtils.getTypeDeclaration(javaInfo), targetMethodSignature)) != null) {
            ExpressionStatement firstStatement;
            Block targetBlock = targetMethod.getBody();
            List<Statement> statements = DomGenerics.statements(targetBlock);
            if (!statements.isEmpty() && statements.get(0) instanceof ExpressionStatement && (firstStatement = (ExpressionStatement)statements.get(0)).getExpression() instanceof SuperMethodInvocation) {
                return new StatementTarget((Statement)firstStatement, false);
            }
            return new StatementTarget(targetBlock, true);
        }
        return this.getSpecificTarget(javaInfo, newSignature);
    }

    protected static List<Pair<MethodInvocation, MethodOrder>> getInvocationOrders(JavaInfo javaInfo) {
        ArrayList invocationOrders = Lists.newArrayList();
        List<MethodInvocation> invocations = javaInfo.getMethodInvocations();
        for (MethodInvocation invocation : invocations) {
            String signature = AstNodeUtils.getMethodSignature(invocation);
            MethodDescription description = javaInfo.getDescription().getMethod(signature);
            if (description == null) continue;
            MethodOrder order = description.getOrder();
            invocationOrders.add(Pair.create((Object)invocation, (Object)order));
        }
        return invocationOrders;
    }

    protected StatementTarget getSpecificTarget(JavaInfo javaInfo, String newSignature) throws Exception {
        return javaInfo.getDescription().getDefaultMethodOrder().getTarget(javaInfo, newSignature);
    }
}

