/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.Sensors;
import oshi.jna.platform.windows.PdhUtil;
import oshi.jna.platform.windows.WbemcliUtil;
import oshi.util.platform.windows.PerfDataUtil;
import oshi.util.platform.windows.WmiUtil;

public class WindowsSensors
implements Sensors {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(WindowsSensors.class);
    private static final String BASE_SENSOR_CLASS = "Sensor";
    private static final WbemcliUtil.WmiQuery<OhmHardwareProperty> OHM_HARDWARE_QUERY = WbemcliUtil.createQuery("ROOT\\OpenHardwareMonitor", "Hardware WHERE HardwareType=\"CPU\"", OhmHardwareProperty.class);
    private static final WbemcliUtil.WmiQuery<OhmHardwareProperty> OHM_VOLTAGE_QUERY = WbemcliUtil.createQuery("ROOT\\OpenHardwareMonitor", "Hardware WHERE SensorType=\"Voltage\"", OhmHardwareProperty.class);
    private static final WbemcliUtil.WmiQuery<OhmSensorProperty> OHM_SENSOR_QUERY = WbemcliUtil.createQuery("ROOT\\OpenHardwareMonitor", null, OhmSensorProperty.class);
    private static final WbemcliUtil.WmiQuery<FanProperty> FAN_QUERY = WbemcliUtil.createQuery("Win32_Fan", FanProperty.class);
    private static final WbemcliUtil.WmiQuery<VoltProperty> VOLT_QUERY = WbemcliUtil.createQuery("Win32_Processor", VoltProperty.class);
    private PerfDataUtil.PerfCounter thermalZoneCounter = null;
    private WbemcliUtil.WmiQuery<ThermalZoneProperty> thermalZoneQuery = null;

    public WindowsSensors() {
        this.initPdhCounters();
    }

    private void initPdhCounters() {
        String thermalZoneInfo = PdhUtil.PdhLookupPerfNameByIndex(null, PdhUtil.PdhLookupPerfIndexByEnglishName("Thermal Zone Information"));
        boolean enumeration = false;
        if (!thermalZoneInfo.isEmpty()) {
            try {
                PdhUtil.PdhEnumObjectItems objectItems = PdhUtil.PdhEnumObjectItems(null, null, thermalZoneInfo, 100);
                String cpuInstance = "";
                for (String instance : objectItems.getInstances()) {
                    if (!cpuInstance.isEmpty() && !instance.toLowerCase().contains("cpu")) continue;
                    cpuInstance = instance;
                    enumeration = true;
                }
                this.thermalZoneCounter = PerfDataUtil.createCounter("Thermal Zone Information", cpuInstance, "Temperature");
            }
            catch (PdhUtil.PdhException e) {
                LOG.warn("Unable to enumerate performance counter instances for {}.", (Object)thermalZoneInfo);
            }
        }
        if (!enumeration || !PerfDataUtil.addCounterToQuery(this.thermalZoneCounter)) {
            this.thermalZoneCounter = null;
            this.thermalZoneQuery = WbemcliUtil.createQuery("Win32_PerfRawData_Counters_ThermalZoneInformation", ThermalZoneProperty.class);
        }
    }

    @Override
    public double getCpuTemperature() {
        String cpuIdentifier;
        double tempC = 0.0;
        WbemcliUtil.WmiResult<OhmHardwareProperty> ohmHardware = WmiUtil.queryWMI(OHM_HARDWARE_QUERY);
        if (ohmHardware.getResultCount() > 0 && (cpuIdentifier = ohmHardware.getString(OhmHardwareProperty.IDENTIFIER, 0)).length() > 0) {
            StringBuilder sb = new StringBuilder(BASE_SENSOR_CLASS);
            sb.append(" WHERE Parent = \"").append(cpuIdentifier);
            sb.append("\" AND SensorType=\"Temperature\"");
            OHM_SENSOR_QUERY.setWmiClassName(sb.toString());
            WbemcliUtil.WmiResult<OhmSensorProperty> ohmSensors = WmiUtil.queryWMI(OHM_SENSOR_QUERY);
            if (ohmSensors.getResultCount() > 0) {
                double sum = 0.0;
                for (int i = 0; i < ohmSensors.getResultCount(); ++i) {
                    sum += (double)ohmSensors.getFloat(OhmSensorProperty.VALUE, i).floatValue();
                }
                tempC = sum / (double)ohmSensors.getResultCount();
            }
            if (tempC > 0.0) {
                return tempC;
            }
        }
        long tempK = 0L;
        if (this.thermalZoneQuery == null) {
            PerfDataUtil.updateQuery(this.thermalZoneCounter);
            tempK = PerfDataUtil.queryCounter(this.thermalZoneCounter);
        } else {
            WbemcliUtil.WmiResult<ThermalZoneProperty> result = WmiUtil.queryWMI(this.thermalZoneQuery);
            for (int i = 0; i < result.getResultCount(); ++i) {
                if (tempK != 0L && !result.getString(ThermalZoneProperty.NAME, i).toLowerCase().contains("cpu")) continue;
                tempK = result.getInteger(ThermalZoneProperty.TEMPERATURE, i).intValue();
            }
        }
        if (tempK > 2732L) {
            tempC = (double)tempK / 10.0 - 273.15;
        } else if (tempK > 274L) {
            tempC = (double)tempK - 273.0;
        }
        if (tempC < 0.0) {
            tempC = 0.0;
        }
        return tempC;
    }

    @Override
    public int[] getFanSpeeds() {
        WbemcliUtil.WmiResult<FanProperty> fan;
        String cpuIdentifier;
        WbemcliUtil.WmiResult<OhmHardwareProperty> ohmHardware = WmiUtil.queryWMI(OHM_HARDWARE_QUERY);
        if (ohmHardware.getResultCount() > 0 && (cpuIdentifier = ohmHardware.getString(OhmHardwareProperty.IDENTIFIER, 0)).length() > 0) {
            StringBuilder sb = new StringBuilder(BASE_SENSOR_CLASS);
            sb.append(" WHERE Parent = \"").append(cpuIdentifier);
            sb.append("\" AND SensorType=\"Fan\"");
            OHM_SENSOR_QUERY.setWmiClassName(sb.toString());
            WbemcliUtil.WmiResult<OhmSensorProperty> ohmSensors = WmiUtil.queryWMI(OHM_SENSOR_QUERY);
            if (ohmSensors.getResultCount() > 0) {
                int[] fanSpeeds = new int[ohmSensors.getResultCount()];
                for (int i = 0; i < ohmSensors.getResultCount(); ++i) {
                    fanSpeeds[i] = ohmSensors.getFloat(OhmSensorProperty.VALUE, i).intValue();
                }
                return fanSpeeds;
            }
        }
        if ((fan = WmiUtil.queryWMI(FAN_QUERY)).getResultCount() > 1) {
            int[] fanSpeeds = new int[fan.getResultCount()];
            for (int i = 0; i < fan.getResultCount(); ++i) {
                fanSpeeds[i] = fan.getInteger(FanProperty.DESIREDSPEED, i);
            }
            return fanSpeeds;
        }
        return new int[1];
    }

    @Override
    public double getCpuVoltage() {
        int decivolts;
        WbemcliUtil.WmiResult<VoltProperty> voltage;
        WbemcliUtil.WmiResult<OhmHardwareProperty> ohmHardware = WmiUtil.queryWMI(OHM_VOLTAGE_QUERY);
        if (ohmHardware.getResultCount() > 0) {
            String voltIdentifierStr = null;
            for (int i = 0; i < ohmHardware.getResultCount(); ++i) {
                String id = ohmHardware.getString(OhmHardwareProperty.IDENTIFIER, i);
                if (!id.toLowerCase().contains("cpu")) continue;
                voltIdentifierStr = id;
                break;
            }
            if (voltIdentifierStr == null) {
                voltIdentifierStr = ohmHardware.getString(OhmHardwareProperty.IDENTIFIER, 0);
            }
            StringBuilder sb = new StringBuilder(BASE_SENSOR_CLASS);
            sb.append(" WHERE Parent = \"").append(voltIdentifierStr);
            sb.append("\" AND SensorType=\"Voltage\"");
            OHM_SENSOR_QUERY.setWmiClassName(sb.toString());
            WbemcliUtil.WmiResult<OhmSensorProperty> ohmSensors = WmiUtil.queryWMI(OHM_SENSOR_QUERY);
            if (ohmSensors.getResultCount() > 0) {
                return ohmSensors.getFloat(OhmSensorProperty.VALUE, 0).floatValue();
            }
        }
        if ((voltage = WmiUtil.queryWMI(VOLT_QUERY)).getResultCount() > 1 && (decivolts = voltage.getInteger(VoltProperty.CURRENTVOLTAGE, 0).intValue()) > 0) {
            if ((decivolts & 0x80) == 0) {
                decivolts = voltage.getInteger(VoltProperty.VOLTAGECAPS, 0);
                if ((decivolts & 1) > 0) {
                    return 5.0;
                }
                if ((decivolts & 2) > 0) {
                    return 3.3;
                }
                if ((decivolts & 4) > 0) {
                    return 2.9;
                }
            } else {
                return (double)(decivolts & 0x7F) / 10.0;
            }
        }
        return 0.0;
    }

    static enum FanProperty {
        DESIREDSPEED;

    }

    static enum OhmHardwareProperty {
        IDENTIFIER;

    }

    static enum OhmSensorProperty {
        VALUE;

    }

    static enum ThermalZoneProperty {
        NAME,
        TEMPERATURE;

    }

    static enum VoltProperty {
        CURRENTVOLTAGE,
        VOLTAGECAPS;

    }
}

