/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.participant;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Collaboration;
import org.eclipse.bpmn2.LaneSet;
import org.eclipse.bpmn2.MessageFlow;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNEdge;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.features.BaseElementFeatureContainer;
import org.eclipse.bpmn2.modeler.core.features.CreateConnectionReferenceFeature;
import org.eclipse.bpmn2.modeler.core.features.MultiUpdateFeature;
import org.eclipse.bpmn2.modeler.core.features.containers.LayoutContainerFeature;
import org.eclipse.bpmn2.modeler.core.features.containers.UpdateContainerLabelFeature;
import org.eclipse.bpmn2.modeler.core.features.containers.participant.AddParticipantFeature;
import org.eclipse.bpmn2.modeler.core.features.containers.participant.CreateParticipantReferenceFeature;
import org.eclipse.bpmn2.modeler.core.features.containers.participant.DirectEditParticipantFeature;
import org.eclipse.bpmn2.modeler.core.features.containers.participant.ResizeParticipantFeature;
import org.eclipse.bpmn2.modeler.core.features.containers.participant.UpdateParticipantFeature;
import org.eclipse.bpmn2.modeler.core.features.containers.participant.UpdateParticipantMultiplicityFeature;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.bpmn2.modeler.ui.features.activity.subprocess.AbstractPushPullFeature;
import org.eclipse.bpmn2.modeler.ui.features.activity.subprocess.PullupFeature;
import org.eclipse.bpmn2.modeler.ui.features.activity.subprocess.PushdownFeature;
import org.eclipse.bpmn2.modeler.ui.features.choreography.AddChoreographyMessageFeature;
import org.eclipse.bpmn2.modeler.ui.features.choreography.BlackboxFeature;
import org.eclipse.bpmn2.modeler.ui.features.choreography.RemoveChoreographyMessageFeature;
import org.eclipse.bpmn2.modeler.ui.features.choreography.RemoveChoreographyParticipantFeature;
import org.eclipse.bpmn2.modeler.ui.features.choreography.ShowDiagramPageFeature;
import org.eclipse.bpmn2.modeler.ui.features.choreography.WhiteboxFeature;
import org.eclipse.bpmn2.modeler.ui.features.participant.CreateParticipantFeature;
import org.eclipse.bpmn2.modeler.ui.features.participant.DeleteParticipantFeature;
import org.eclipse.bpmn2.modeler.ui.features.participant.MoveParticipantFeature;
import org.eclipse.bpmn2.modeler.ui.features.participant.RotatePoolFeature;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IDirectEditingFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.ILayoutFeature;
import org.eclipse.graphiti.features.IMoveShapeFeature;
import org.eclipse.graphiti.features.IReconnectionFeature;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.IMoveContext;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.features.context.IReconnectionContext;
import org.eclipse.graphiti.features.context.IResizeContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.CreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.CustomContext;
import org.eclipse.graphiti.features.context.impl.LayoutContext;
import org.eclipse.graphiti.features.context.impl.ReconnectionContext;
import org.eclipse.graphiti.features.context.impl.ResizeShapeContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FixPointAnchor;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;

public class ParticipantFeatureContainer
extends BaseElementFeatureContainer {
    public Object getApplyObject(IContext context) {
        if (context instanceof IUpdateContext || context instanceof ILayoutContext || context instanceof IMoveContext || context instanceof IResizeContext) {
            PictogramElement pe = ((IPictogramElementContext)context).getPictogramElement();
            if (FeatureSupport.isLabelShape((PictogramElement)pe)) {
                pe = (PictogramElement)pe.eContainer();
            }
            if (FeatureSupport.isChoreographyParticipantBand((PictogramElement)pe)) {
                return null;
            }
        }
        Object o = super.getApplyObject(context);
        return o;
    }

    public boolean canApplyTo(Object o) {
        return super.canApplyTo(o) && o instanceof Participant;
    }

    public ICreateFeature getCreateFeature(IFeatureProvider fp) {
        return new CreateParticipantFeature(fp);
    }

    public IAddFeature getAddFeature(IFeatureProvider fp) {
        return new AddParticipantFeature(fp);
    }

    public IUpdateFeature getUpdateFeature(IFeatureProvider fp) {
        MultiUpdateFeature multiUpdate = new MultiUpdateFeature(fp);
        multiUpdate.addFeature((IUpdateFeature)new UpdateParticipantFeature(fp));
        multiUpdate.addFeature((IUpdateFeature)new UpdateParticipantMultiplicityFeature(fp));
        multiUpdate.addFeature((IUpdateFeature)new UpdateContainerLabelFeature(fp));
        return multiUpdate;
    }

    public IDirectEditingFeature getDirectEditingFeature(IFeatureProvider fp) {
        return new DirectEditParticipantFeature(fp);
    }

    public ILayoutFeature getLayoutFeature(IFeatureProvider fp) {
        return new LayoutContainerFeature(fp);
    }

    public IMoveShapeFeature getMoveFeature(IFeatureProvider fp) {
        return new MoveParticipantFeature(fp);
    }

    public IResizeShapeFeature getResizeFeature(IFeatureProvider fp) {
        return new ResizeParticipantFeature(fp);
    }

    public IDeleteFeature getDeleteFeature(IFeatureProvider fp) {
        return new DeleteParticipantFeature(fp);
    }

    public IRemoveFeature getRemoveFeature(IFeatureProvider fp) {
        return new RemoveChoreographyParticipantFeature(fp);
    }

    public ICustomFeature[] getCustomFeatures(IFeatureProvider fp) {
        ICustomFeature[] superFeatures = super.getCustomFeatures(fp);
        ICustomFeature[] thisFeatures = new ICustomFeature[8 + superFeatures.length];
        thisFeatures[0] = new ShowDiagramPageFeature(fp);
        int i = 0;
        while (i < superFeatures.length) {
            thisFeatures[i + 1] = superFeatures[i];
            ++i;
        }
        thisFeatures[++i] = new AddChoreographyMessageFeature(fp);
        thisFeatures[++i] = new RemoveChoreographyMessageFeature(fp);
        thisFeatures[++i] = new RotatePoolFeature(fp);
        thisFeatures[++i] = new WhiteboxFeature(fp);
        thisFeatures[++i] = new BlackboxFeature(fp);
        thisFeatures[++i] = new ParticipantPushdownFeature(fp);
        thisFeatures[++i] = new ParticipantPullupFeature(fp);
        return thisFeatures;
    }

    protected static void updateParticipant(IFeatureProvider fp, ContainerShape containerShape) {
        UpdateContext updateContext = new UpdateContext((PictogramElement)containerShape);
        updateContext.putProperty((Object)"force.update.all", (Object)Boolean.TRUE);
        IUpdateFeature updateFeature = fp.getUpdateFeature((IUpdateContext)updateContext);
        updateFeature.update((IUpdateContext)updateContext);
        LayoutContext layoutContext = new LayoutContext((PictogramElement)containerShape);
        ILayoutFeature layoutFeature = fp.getLayoutFeature((ILayoutContext)layoutContext);
        layoutFeature.layout((ILayoutContext)layoutContext);
    }

    public static class ParticipantPullupFeature
    extends PullupFeature {
        public ParticipantPullupFeature(IFeatureProvider fp) {
            super(fp);
        }

        @Override
        public void execute(ICustomContext context) {
            super.execute(context);
            int laneCount = 0;
            for (LaneSet ls : this.businessObject.getLaneSets()) {
                laneCount += ls.getLanes().size();
            }
            if (laneCount == 0) {
                IDimension dim = GraphicsUtil.calculateSize((PictogramElement)this.containerShape);
                boolean resizeNeeded = false;
                if (dim.getWidth() < this.boundingRectangle.width) {
                    resizeNeeded = true;
                    dim.setWidth(this.boundingRectangle.width);
                }
                if (dim.getHeight() < this.boundingRectangle.height) {
                    resizeNeeded = true;
                    dim.setHeight(this.boundingRectangle.height);
                }
                if (resizeNeeded) {
                    ResizeShapeContext resizeContext = new ResizeShapeContext((Shape)this.containerShape);
                    resizeContext.setHeight(dim.getHeight());
                    resizeContext.setWidth(dim.getWidth());
                    ILocation loc = Graphiti.getPeService().getLocationRelativeToDiagram((Shape)this.containerShape);
                    resizeContext.setLocation(loc.getX(), loc.getY());
                    IResizeShapeFeature resizeFeature = this.getFeatureProvider().getResizeShapeFeature((IResizeShapeContext)resizeContext);
                    resizeFeature.resizeShape((IResizeShapeContext)resizeContext);
                }
            }
            ParticipantFeatureContainer.updateParticipant(this.getFeatureProvider(), this.containerShape);
        }

        @Override
        protected Point getChildOffset(ContainerShape targetContainerShape) {
            boolean horz = FeatureSupport.isHorizontal((ContainerShape)targetContainerShape);
            if (horz) {
                return GraphicsUtil.createPoint((int)30, (int)0);
            }
            return GraphicsUtil.createPoint((int)0, (int)30);
        }

        @Override
        protected void collectShapes(ContainerShape source) {
            ArrayList<Shape> deleted = new ArrayList<Shape>();
            this.childShapes.addAll(source.getChildren());
            for (Shape s : this.childShapes) {
                if (!this.isReferenceShape(this.oldDiagram, (PictogramElement)s)) continue;
                deleted.add(s);
                deleted.add(FeatureSupport.getLabelShape((PictogramElement)s));
            }
            this.childShapes.removeAll(deleted);
        }

        @Override
        protected void moveConnections(ContainerShape source, ContainerShape target) {
            super.moveConnections(source, target);
            ILocation loc = Graphiti.getPeService().getLocationRelativeToDiagram((Shape)this.containerShape);
            for (Map.Entry e : this.externalConnections.entrySet()) {
                IReconnectionFeature rf;
                ReconnectionContext rc;
                FixPointAnchor anchor;
                Connection oldConnection = (Connection)e.getKey();
                Connection newConnection = null;
                AbstractPushPullFeature.SourceTarget st = (AbstractPushPullFeature.SourceTarget)e.getValue();
                BaseElement connectionBusinessObject = BusinessObjectUtil.getFirstBaseElement((PictogramElement)oldConnection);
                newConnection = this.findReferencedConnection(oldConnection, this.newDiagram);
                AnchorContainer sourceShape = null;
                AnchorContainer targetShape = null;
                if (newConnection == null) {
                    if (st.localShape == oldConnection.getStart().getParent()) {
                        sourceShape = st.localShape;
                        targetShape = this.findReferencedShape(st.target, this.newDiagram);
                    } else if (st.localShape == oldConnection.getEnd().getParent()) {
                        sourceShape = this.findReferencedShape(st.source, this.newDiagram);
                        targetShape = st.localShape;
                    }
                    if (sourceShape != null && targetShape != null) {
                        FixPointAnchor sourceAnchor = AnchorUtil.createAnchor((AnchorContainer)sourceShape, (Point)GraphicsUtil.getShapeCenter((AnchorContainer)sourceShape));
                        FixPointAnchor targetAnchor = AnchorUtil.createAnchor((AnchorContainer)targetShape, (Point)GraphicsUtil.getShapeCenter((AnchorContainer)targetShape));
                        CreateConnectionContext ccc = new CreateConnectionContext();
                        ccc.setSourcePictogramElement((PictogramElement)sourceShape);
                        ccc.setTargetPictogramElement((PictogramElement)targetShape);
                        ccc.setSourceAnchor((Anchor)sourceAnchor);
                        ccc.setTargetAnchor((Anchor)targetAnchor);
                        BPMNEdge bpmnEdge = DIUtils.findBPMNEdge((BPMNDiagram)this.oldBpmnDiagram, (EObject)connectionBusinessObject);
                        CreateConnectionReferenceFeature ccf = new CreateConnectionReferenceFeature(this.getFeatureProvider(), bpmnEdge, connectionBusinessObject);
                        newConnection = ccf.create((ICreateConnectionContext)ccc);
                    }
                } else if (st.localShape == oldConnection.getStart().getParent()) {
                    sourceShape = st.localShape;
                    anchor = AnchorUtil.createAnchor((AnchorContainer)sourceShape, (Point)GraphicsUtil.getShapeCenter((AnchorContainer)sourceShape));
                    rc = new ReconnectionContext(newConnection, oldConnection.getStart(), (Anchor)anchor, loc);
                    rc.setReconnectType(ReconnectionContext.RECONNECT_SOURCE);
                    rc.setTargetPictogramElement((PictogramElement)sourceShape);
                    rf = this.getFeatureProvider().getReconnectionFeature((IReconnectionContext)rc);
                    rf.reconnect((IReconnectionContext)rc);
                } else if (st.localShape == oldConnection.getEnd().getParent()) {
                    targetShape = st.localShape;
                    anchor = AnchorUtil.createAnchor((AnchorContainer)targetShape, (Point)GraphicsUtil.getShapeCenter((AnchorContainer)targetShape));
                    rc = new ReconnectionContext(newConnection, oldConnection.getEnd(), (Anchor)anchor, loc);
                    rc.setReconnectType(ReconnectionContext.RECONNECT_TARGET);
                    rc.setTargetPictogramElement((PictogramElement)targetShape);
                    rf = this.getFeatureProvider().getReconnectionFeature((IReconnectionContext)rc);
                    rf.reconnect((IReconnectionContext)rc);
                }
                if (newConnection == null) continue;
                FeatureSupport.updateConnection((IFeatureProvider)this.getFeatureProvider(), (Connection)newConnection, (boolean)true);
            }
        }
    }

    public static class ParticipantPushdownFeature
    extends PushdownFeature {
        public ParticipantPushdownFeature(IFeatureProvider fp) {
            super(fp);
        }

        @Override
        public void execute(ICustomContext context) {
            super.execute(context);
            ParticipantFeatureContainer.updateParticipant(this.getFeatureProvider(), this.containerShape);
        }

        @Override
        protected void moveConnections(ContainerShape source, ContainerShape target) {
            ILocation loc = Graphiti.getPeService().getLocationRelativeToDiagram((Shape)this.containerShape);
            for (Map.Entry e : this.externalConnections.entrySet()) {
                IReconnectionFeature rf;
                ReconnectionContext rc;
                FixPointAnchor anchor;
                Connection c = (Connection)e.getKey();
                AbstractPushPullFeature.SourceTarget st = (AbstractPushPullFeature.SourceTarget)e.getValue();
                if (st.localShape == c.getStart().getParent()) {
                    anchor = AnchorUtil.createAnchor((AnchorContainer)this.containerShape, (Point)GraphicsUtil.getShapeCenter((AnchorContainer)this.containerShape));
                    rc = new ReconnectionContext(c, c.getStart(), (Anchor)anchor, loc);
                    rc.setReconnectType(ReconnectionContext.RECONNECT_SOURCE);
                    rc.setTargetPictogramElement((PictogramElement)this.containerShape);
                    rf = this.getFeatureProvider().getReconnectionFeature((IReconnectionContext)rc);
                    rf.reconnect((IReconnectionContext)rc);
                } else if (st.localShape == c.getEnd().getParent()) {
                    anchor = AnchorUtil.createAnchor((AnchorContainer)this.containerShape, (Point)GraphicsUtil.getShapeCenter((AnchorContainer)this.containerShape));
                    rc = new ReconnectionContext(c, c.getEnd(), (Anchor)anchor, loc);
                    rc.setReconnectType(ReconnectionContext.RECONNECT_TARGET);
                    rc.setTargetPictogramElement((PictogramElement)this.containerShape);
                    rf = this.getFeatureProvider().getReconnectionFeature((IReconnectionContext)rc);
                    rf.reconnect((IReconnectionContext)rc);
                }
                FeatureSupport.updateConnection((IFeatureProvider)this.getFeatureProvider(), (Connection)c, (boolean)true);
            }
            super.moveConnections(source, target);
            boolean isHorz = this.bpmnShape.isIsHorizontal();
            int nextX = 0;
            int nextY = 0;
            if (isHorz) {
                nextX = this.boundingRectangle.x;
                nextY = this.boundingRectangle.y + this.boundingRectangle.height + 80;
            } else {
                nextX = this.boundingRectangle.x + this.boundingRectangle.width + 80;
                nextY = this.boundingRectangle.y;
            }
            Hashtable<AnchorContainer, AnchorContainer> externalContainers = new Hashtable<AnchorContainer, AnchorContainer>();
            for (Map.Entry e : this.externalConnections.entrySet()) {
                AnchorContainer localContainer;
                AnchorContainer localShape;
                AbstractPushPullFeature.SourceTarget st;
                Connection externalConnection;
                block18: {
                    BPMNShape diagramElement;
                    Participant participant;
                    AnchorContainer externalContainer;
                    block20: {
                        BPMNDiagram bpmnDiagram;
                        BaseElement be;
                        block19: {
                            externalConnection = (Connection)e.getKey();
                            if (!(BusinessObjectUtil.getFirstBaseElement((PictogramElement)externalConnection) instanceof MessageFlow)) continue;
                            st = (AbstractPushPullFeature.SourceTarget)e.getValue();
                            externalContainer = null;
                            localShape = st.localShape;
                            if (st.localShape == st.source) {
                                externalContainer = st.target;
                            } else if (st.localShape == st.target) {
                                externalContainer = st.source;
                            }
                            localContainer = (AnchorContainer)externalContainers.get(externalContainer);
                            if (localContainer != null) break block18;
                            participant = null;
                            diagramElement = null;
                            be = BusinessObjectUtil.getFirstBaseElement((PictogramElement)externalContainer);
                            if (!(be instanceof Participant)) break block19;
                            diagramElement = (BPMNShape)BusinessObjectUtil.getFirstElementOfType((PictogramElement)externalContainer, BPMNShape.class);
                            if (diagramElement == null) break block20;
                            participant = (Participant)be;
                            break block20;
                        }
                        Diagram diagram = Graphiti.getPeService().getDiagramForPictogramElement((PictogramElement)externalContainer);
                        localContainer = (AnchorContainer)externalContainers.get(diagram);
                        if (localContainer == null && (be = (bpmnDiagram = (BPMNDiagram)BusinessObjectUtil.getFirstElementOfType((PictogramElement)diagram, BPMNDiagram.class)).getPlane().getBpmnElement()) instanceof Collaboration) {
                            for (Participant p : ((Collaboration)be).getParticipants()) {
                                if (FeatureSupport.hasBpmnDiagram((BaseElement)p)) continue;
                                participant = p;
                                break;
                            }
                        }
                    }
                    if (participant != null) {
                        CustomContext customContext = new CustomContext(new PictogramElement[]{this.newDiagram});
                        customContext.setX(nextX);
                        customContext.setY(nextY);
                        CreateParticipantReferenceFeature f = new CreateParticipantReferenceFeature(this.getFeatureProvider(), diagramElement, participant);
                        f.execute((ICustomContext)customContext);
                        Object o = customContext.getProperty((Object)"pictogram.element");
                        if (o instanceof AnchorContainer) {
                            localContainer = (AnchorContainer)o;
                            externalContainers.put(externalContainer, localContainer);
                            IDimension size = GraphicsUtil.calculateSize((PictogramElement)localContainer);
                            if (isHorz) {
                                nextX += size.getWidth() + 40;
                            } else {
                                nextY += size.getHeight() + 40;
                            }
                        }
                    }
                }
                if (localContainer == null) continue;
                Connection localConnection = null;
                BaseElement be = BusinessObjectUtil.getFirstBaseElement((PictogramElement)externalConnection);
                BPMNEdge bpmnEdge = DIUtils.findBPMNEdge((BPMNDiagram)this.oldBpmnDiagram, (EObject)be);
                CreateConnectionReferenceFeature ccf = new CreateConnectionReferenceFeature(this.getFeatureProvider(), bpmnEdge, be);
                AnchorContainer sourceShape = null;
                AnchorContainer targetShape = null;
                if (st.localShape == st.source) {
                    sourceShape = localShape;
                    targetShape = localContainer;
                } else {
                    sourceShape = localContainer;
                    targetShape = localShape;
                }
                if (sourceShape == null || targetShape == null) continue;
                FixPointAnchor sourceAnchor = AnchorUtil.createAnchor((AnchorContainer)sourceShape, (Point)GraphicsUtil.getShapeCenter((AnchorContainer)sourceShape));
                FixPointAnchor targetAnchor = AnchorUtil.createAnchor((AnchorContainer)targetShape, (Point)GraphicsUtil.getShapeCenter((AnchorContainer)targetShape));
                CreateConnectionContext ccc = new CreateConnectionContext();
                ccc.setSourcePictogramElement((PictogramElement)sourceShape);
                ccc.setTargetPictogramElement((PictogramElement)targetShape);
                ccc.setSourceAnchor((Anchor)sourceAnchor);
                ccc.setTargetAnchor((Anchor)targetAnchor);
                localConnection = ccf.create((ICreateConnectionContext)ccc);
                if (localConnection == null) continue;
                this.internalConnections.add(localConnection);
            }
        }
    }
}

