/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.collection.mutable.primitive;

import java.io.Serializable;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.LongByteToLongFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.iterator.MutableByteIterator;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableByteCollection;
import org.eclipse.collections.impl.lazy.primitive.LazyByteIterableAdapter;

public abstract class AbstractSynchronizedByteCollection
implements MutableByteCollection,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Object lock;
    private final MutableByteCollection collection;

    protected AbstractSynchronizedByteCollection(MutableByteCollection collection) {
        this(collection, null);
    }

    protected AbstractSynchronizedByteCollection(MutableByteCollection collection, Object newLock) {
        if (collection == null) {
            throw new IllegalArgumentException("Cannot create a AbstractSynchronizedByteCollection on a null collection");
        }
        this.collection = collection;
        this.lock = newLock == null ? this : newLock;
    }

    protected Object getLock() {
        return this.lock;
    }

    protected MutableByteCollection getByteCollection() {
        return this.collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean notEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.notEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.collection.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableByteCollection select(BytePredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableByteCollection reject(BytePredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableCollection<V> collect(ByteToObjectFunction<? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.collect((ByteToObjectFunction)function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableByteCollection with(byte element) {
        Object object = this.lock;
        synchronized (object) {
            this.add(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableByteCollection without(byte element) {
        Object object = this.lock;
        synchronized (object) {
            this.remove(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableByteCollection withAll(ByteIterable elements) {
        Object object = this.lock;
        synchronized (object) {
            this.addAll(elements);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableByteCollection withoutAll(ByteIterable elements) {
        Object object = this.lock;
        synchronized (object) {
            this.removeAll(elements);
        }
        return this;
    }

    @Override
    public MutableByteCollection asUnmodifiable() {
        return new UnmodifiableByteCollection(this);
    }

    @Override
    public MutableByteCollection asSynchronized() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableByteCollection toImmutable() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toImmutable();
        }
    }

    @Override
    public LazyByteIterable asLazy() {
        return new LazyByteIterableAdapter(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(byte value) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.contains(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(byte ... source) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.containsAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(ByteIterable source) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.containsAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAny(byte ... source) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.containsAny(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAny(ByteIterable source) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.containsAny(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsNone(byte ... source) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.containsNone(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsNone(ByteIterable source) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.containsNone(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(byte newItem) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.add(newItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(byte ... source) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.addAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(ByteIterable source) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.addAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(byte value) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.remove(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeIf(BytePredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.removeIf(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(ByteIterable source) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.removeAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(byte ... source) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.removeAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(ByteIterable source) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.retainAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(byte ... source) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.retainAll(source);
        }
    }

    @Override
    public MutableByteIterator byteIterator() {
        return this.collection.byteIterator();
    }

    @Override
    public void forEach(ByteProcedure procedure) {
        this.each(procedure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void each(ByteProcedure procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.collection.forEach(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int count(BytePredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.count(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean anySatisfy(BytePredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.anySatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean allSatisfy(BytePredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.allSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean noneSatisfy(BytePredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.noneSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.detectIfNone(predicate, ifNone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long sum() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.sum();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte max() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.max();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte min() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.min();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte minIfEmpty(byte defaultValue) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.minIfEmpty(defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte maxIfEmpty(byte defaultValue) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.maxIfEmpty(defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double average() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.average();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double median() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.median();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableByteList toSortedList() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toSortedList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] toSortedArray() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toSortedArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] toArray() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] toArray(byte[] target) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toArray(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String makeString() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.makeString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String makeString(String separator) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.makeString(separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String makeString(String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.makeString(start, separator, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendString(Appendable appendable) {
        Object object = this.lock;
        synchronized (object) {
            this.collection.appendString(appendable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendString(Appendable appendable, String separator) {
        Object object = this.lock;
        synchronized (object) {
            this.collection.appendString(appendable, separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            this.collection.appendString(appendable, start, separator, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableByteList toList() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableByteSet toSet() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableByteBag toBag() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toBag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.injectInto(injectedValue, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long reduce(LongByteToLongFunction accumulator) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.reduce(accumulator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long reduceIfEmpty(LongByteToLongFunction accumulator, long defaultValue) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.reduceIfEmpty(accumulator, defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RichIterable<ByteIterable> chunk(int size) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.chunk(size);
        }
    }
}

