/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.contenttype;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.contenttype.Messages;
import org.eclipse.jst.jsp.core.internal.contenttype.ServletAPIDescriptor;
import org.eclipse.jst.jsp.core.internal.util.CommonXML;
import org.eclipse.jst.jsp.core.internal.util.FacetModuleCoreSupport;
import org.eclipse.jst.jsp.core.internal.util.FileContentCache;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class DeploymentDescriptorPropertyCache {
    private static final PropertyGroup[] NO_PROPERTY_GROUPS = new PropertyGroup[0];
    private static final String JAKARTA_SERVLET = "jakarta.servlet";
    private static final String JAVAX_SERVLET = "javax.servlet";
    private static final DeploymentDescriptorPropertyCache _instance = new DeploymentDescriptorPropertyCache();
    private static final boolean _debugResolutionCache = false;
    static final float DEFAULT_WEBAPP_VERSION = 5.0f;
    static final String EL_IGNORED = "el-ignored";
    static final String ID = "id";
    static final String INCLUDE_CODA = "include-coda";
    static final String INCLUDE_PRELUDE = "include-prelude";
    static final String IS_XML = "is-xml";
    private static String JSP_PROPERTY_GROUP = "jsp-property-group";
    static final String PAGE_ENCODING = "page-encoding";
    static final String SCRIPTING_INVALID = "scripting-invalid";
    static final String URL_PATTERN = "url-pattern";
    private static final String SCHEMA_LOCATION = "xsi:schemaLocation";
    private static final String SERVLET_MAPPING = "servlet-mapping";
    private static final String WEB_APP_ELEMENT_LOCAL_NAME = ":web-app";
    private static final String WEB_APP_ELEMENT_NAME = "web-app";
    private static final String WEB_APP_VERSION_NAME = "version";
    private static final String WEB_INF = "WEB-INF";
    private static final String WEB_XML = "web.xml";
    private static final String SLASH_WEB_INF_WEB_XML = String.valueOf(Path.ROOT.toString()) + "WEB-INF" + '/' + "web.xml";
    private ResourceErrorHandler errorHandler;
    private Map<IPath, Reference<DeploymentDescriptor>> fDeploymentDescriptors = new HashMap<IPath, Reference<DeploymentDescriptor>>();
    private IResourceChangeListener fResourceChangeListener = new ResourceChangeListener();
    private EntityResolver resolver;
    Map<String, Map<IPath, IPath>> resolvedMap = new HashMap<String, Map<IPath, IPath>>();
    Map<String, Reference<ServletAPIDescriptor>> apiVersions = new HashMap<String, Reference<ServletAPIDescriptor>>();
    static final Object LOCK = new Object();

    static String getContainedText(Node parent) {
        NodeList children = parent.getChildNodes();
        if (children.getLength() == 1) {
            return children.item(0).getNodeValue().trim();
        }
        StringBuffer s = new StringBuffer();
        Node child = parent.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 5) {
                String reference = ((EntityReference)child).getNodeValue();
                if (reference == null && child.getNodeName() != null) {
                    reference = "&" + child.getNodeName() + ";";
                }
                if (reference != null) {
                    s.append(reference.trim());
                }
            } else {
                s.append(child.getNodeValue().trim());
            }
            child = child.getNextSibling();
        }
        return s.toString().trim();
    }

    public static DeploymentDescriptorPropertyCache getInstance() {
        return _instance;
    }

    public static void start() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(DeploymentDescriptorPropertyCache.getInstance().fResourceChangeListener, 1);
    }

    public static void stop() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(DeploymentDescriptorPropertyCache.getInstance().fResourceChangeListener);
    }

    private DeploymentDescriptorPropertyCache() {
    }

    private void _parseDocument(IPath path, Float[] version, List<PropertyGroup> groupList, List<StringMatcher> urlPatterns, SubProgressMonitor subMonitor, Document document) {
        Element webapp = document.getDocumentElement();
        if (webapp != null && (webapp.getTagName().equals(WEB_APP_ELEMENT_NAME) || webapp.getNodeName().endsWith(WEB_APP_ELEMENT_LOCAL_NAME))) {
            DocumentType doctype;
            String schemaLocations;
            if (webapp.hasAttribute(WEB_APP_VERSION_NAME)) {
                String versionValue = webapp.getAttribute(WEB_APP_VERSION_NAME);
                if ((versionValue = versionValue.trim()).length() > 0) {
                    try {
                        version[0] = Float.valueOf(versionValue);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            if (version[0] == null && (schemaLocations = webapp.getAttribute(SCHEMA_LOCATION)) != null && schemaLocations.length() > 0) {
                if (schemaLocations.contains("/web-app_5_0.xsd")) {
                    version[0] = Float.valueOf(5.0f);
                } else if (schemaLocations.contains("/web-app_4_0.xsd")) {
                    version[0] = Float.valueOf(4.0f);
                } else if (schemaLocations.contains("/web-app_3_1.xsd")) {
                    version[0] = Float.valueOf(3.1f);
                } else if (schemaLocations.contains("/web-app_3_0.xsd")) {
                    version[0] = Float.valueOf(3.0f);
                }
            }
            if (version[0] == null && (doctype = document.getDoctype()) != null) {
                String systemId = doctype.getSystemId();
                String publicId = doctype.getPublicId();
                if (systemId != null && systemId.endsWith("web-app_2_3.dtd") || publicId != null && publicId.indexOf("Web Application 2.3") > 0) {
                    version[0] = Float.valueOf(2.3f);
                } else if (systemId != null && systemId.endsWith("web-app_2_2.dtd") || publicId != null && publicId.indexOf("Web Application 2.2") > 0) {
                    version[0] = Float.valueOf(2.2f);
                } else if (systemId != null && systemId.endsWith("web-app_2_1.dtd") || publicId != null && publicId.indexOf("Web Application 2.1") > 0) {
                    version[0] = Float.valueOf(2.1f);
                }
            }
        }
        if (version[0] == null) {
            version[0] = Float.valueOf(5.0f);
        }
        NodeList propertyGroupElements = document.getElementsByTagName(JSP_PROPERTY_GROUP);
        int length = propertyGroupElements.getLength();
        subMonitor.beginTask("Reading Property Groups", length);
        int i = 0;
        while (i < length) {
            PropertyGroup group = PropertyGroup.createFrom(path, propertyGroupElements.item(i), i);
            subMonitor.worked(1);
            if (group != null) {
                groupList.add(group);
            }
            ++i;
        }
        NodeList urlPatternElements = document.getElementsByTagName(URL_PATTERN);
        int urlPatternElementCount = urlPatternElements.getLength();
        int i2 = 0;
        while (i2 < urlPatternElementCount) {
            String urlPattern;
            Node urlPatternElement = urlPatternElements.item(i2);
            if (SERVLET_MAPPING.equals(urlPatternElement.getParentNode().getNodeName()) && (urlPattern = DeploymentDescriptorPropertyCache.getContainedText(urlPatternElement)) != null && urlPattern.length() > 0) {
                urlPatterns.add(new StringMatcher(urlPattern));
            }
            ++i2;
        }
    }

    private float convertSpecVersions(float version) {
        if (version > 0.0f) {
            if (version == 5.0f) {
                return 3.0f;
            }
            if (version == 4.0f) {
                return 2.3f;
            }
            if (version == 3.1f) {
                return 2.3f;
            }
            if (version == 3.0f) {
                return 2.2f;
            }
            if (version == 2.5f) {
                return 2.1f;
            }
            if (version == 2.4f) {
                return 2.0f;
            }
            if (version == 2.3f) {
                return 1.2f;
            }
            if (version == 2.2f) {
                return 1.1f;
            }
            if (version == 2.1f) {
                return 1.0f;
            }
        }
        return this.convertSpecVersions(5.0f);
    }

    void deploymentDescriptorChanged(IPath fullPath) {
        if (this.fDeploymentDescriptors.containsKey(fullPath.makeAbsolute())) {
            this.updateCacheEntry(fullPath);
        }
    }

    private ServletAPIDescriptor discoverServletAPIVersion(IProject project) {
        IJavaProject javaProject;
        if (FacetModuleCoreSupport.isDynamicWebProject(project) || FacetModuleCoreSupport.isWebFragmentProject(project)) {
            float version = FacetModuleCoreSupport.getDynamicWebProjectVersion(project);
            if (version >= 5.0f) {
                return this.doCacheDescriptor(project.getName(), new ServletAPIDescriptor(JAKARTA_SERVLET, version));
            }
            if (version > 0.0f) {
                return this.doCacheDescriptor(project.getName(), new ServletAPIDescriptor(JAVAX_SERVLET, version));
            }
        }
        if (!(javaProject = JavaCore.create((IProject)project)).exists()) {
            return null;
        }
        try {
            int i;
            if (javaProject.findType("jakarta.servlet.GenericFilter") != null) {
                return this.doCacheDescriptor(project.getName(), new ServletAPIDescriptor(JAKARTA_SERVLET, 5.0f));
            }
            if (javaProject.findType("javax.servlet.GenericFilter") != null) {
                return this.doCacheDescriptor(project.getName(), new ServletAPIDescriptor(JAVAX_SERVLET, 4.0f));
            }
            if (javaProject.findType("javax.servlet.ReadListener") != null) {
                return this.doCacheDescriptor(project.getName(), new ServletAPIDescriptor(JAVAX_SERVLET, 3.1f));
            }
            if (javaProject.findType("javax.servlet.SessionCookieConfig") != null) {
                return this.doCacheDescriptor(project.getName(), new ServletAPIDescriptor(JAVAX_SERVLET, 3.0f));
            }
            IType servletRequestType = javaProject.findType("javax.servlet.http.HttpServletRequest");
            if (servletRequestType != null) {
                IMethod[] methods = servletRequestType.getMethods();
                i = 0;
                while (i < methods.length) {
                    if ("getContextPath".equals(methods[i].getElementName())) {
                        return this.doCacheDescriptor(project.getName(), new ServletAPIDescriptor(JAVAX_SERVLET, 2.5f));
                    }
                    ++i;
                }
            }
            if (javaProject.findType("javax.servlet.ServletRequestAttributeEvent") != null) {
                return this.doCacheDescriptor(project.getName(), new ServletAPIDescriptor(JAVAX_SERVLET, 2.4f));
            }
            if (javaProject.findType("javax.servlet.Filter") != null) {
                return this.doCacheDescriptor(project.getName(), new ServletAPIDescriptor(JAVAX_SERVLET, 2.3f));
            }
            if (javaProject.findType("javax.servlet.http.HttpServletResponse") != null && servletRequestType != null) {
                IField[] fields = servletRequestType.getFields();
                i = 0;
                while (i < fields.length) {
                    if ("SC_REQUESTED_RANGE_NOT_SATISFIABLE".equals(fields[i].getElementName())) {
                        return this.doCacheDescriptor(project.getName(), new ServletAPIDescriptor(JAVAX_SERVLET, 2.2f));
                    }
                    ++i;
                }
            }
        }
        catch (JavaModelException e) {
            Logger.logException(e);
        }
        return null;
    }

    private ServletAPIDescriptor doCacheDescriptor(String projectName, ServletAPIDescriptor descriptor) {
        SoftReference<ServletAPIDescriptor> reference = new SoftReference<ServletAPIDescriptor>(descriptor);
        this.apiVersions.put(projectName, reference);
        return descriptor;
    }

    private DeploymentDescriptor fetchDescriptor(IPath path, IProgressMonitor monitor) {
        Float[] version;
        ArrayList<StringMatcher> urlPatterns;
        PropertyGroup[] groups;
        IFile file;
        block19: {
            monitor.beginTask(Messages.DeploymentDescriptorPropertyCache_1, 3);
            file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            groups = null;
            IStructuredModel model = null;
            ArrayList<PropertyGroup> propertyGroupList = new ArrayList<PropertyGroup>();
            urlPatterns = new ArrayList<StringMatcher>();
            version = new Float[1];
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 2);
            DocumentBuilder builder = CommonXML.getDocumentBuilder(false);
            builder.setEntityResolver(this.getEntityNonResolver());
            builder.setErrorHandler(this.getErrorHandler(path));
            try {
                InputSource inputSource = new InputSource();
                String s = FileContentCache.getInstance().getContents(path);
                if (s != null) {
                    inputSource.setCharacterStream(new StringReader(s));
                    inputSource.setSystemId(path.toString());
                    Document document = builder.parse(inputSource);
                    this._parseDocument(path, version, propertyGroupList, urlPatterns, subMonitor, document);
                }
            }
            catch (SAXException sAXException) {
                block18: {
                    try {
                        try {
                            model = StructuredModelManager.getModelManager().getModelForRead(file);
                            monitor.worked(1);
                            if (model instanceof IDOMModel) {
                                IDOMDocument document = ((IDOMModel)model).getDocument();
                                this._parseDocument(path, version, propertyGroupList, urlPatterns, subMonitor, (Document)document);
                            }
                        }
                        catch (Exception e) {
                            Logger.logException(e);
                            if (model != null) {
                                model.releaseFromRead();
                            }
                            break block18;
                        }
                    }
                    catch (Throwable throwable) {
                        if (model != null) {
                            model.releaseFromRead();
                        }
                        throw throwable;
                    }
                    if (model != null) {
                        model.releaseFromRead();
                    }
                }
                groups = propertyGroupList.toArray(new PropertyGroup[propertyGroupList.size()]);
                subMonitor.done();
                break block19;
            }
            catch (IOException iOException) {
                try {
                    break block19;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    groups = propertyGroupList.toArray(new PropertyGroup[propertyGroupList.size()]);
                    subMonitor.done();
                }
            }
            groups = propertyGroupList.toArray(new PropertyGroup[propertyGroupList.size()]);
            subMonitor.done();
        }
        if (groups == null) {
            groups = NO_PROPERTY_GROUPS;
        }
        DeploymentDescriptor deploymentDescriptor = new DeploymentDescriptor();
        deploymentDescriptor.modificationStamp = file.getModificationStamp();
        deploymentDescriptor.groups = groups;
        deploymentDescriptor.urlPatterns = urlPatterns.toArray(new StringMatcher[urlPatterns.size()]);
        deploymentDescriptor.version = version[0];
        monitor.done();
        this.fDeploymentDescriptors.put(path, new SoftReference<DeploymentDescriptor>(deploymentDescriptor));
        return deploymentDescriptor;
    }

    private DeploymentDescriptor getCachedDescriptor(IPath jspFilePath) {
        IPath webxmlPath = this.getRelevantWebXMLPath(jspFilePath);
        if (webxmlPath == null) {
            return null;
        }
        IFile webxmlFile = ResourcesPlugin.getWorkspace().getRoot().getFile(webxmlPath);
        if (!webxmlFile.isAccessible()) {
            return null;
        }
        Reference<DeploymentDescriptor> descriptorHolder = this.fDeploymentDescriptors.get(webxmlPath);
        DeploymentDescriptor descriptor = null;
        if (descriptorHolder == null || (descriptor = descriptorHolder.get()) == null || descriptor.modificationStamp == -1L || descriptor.modificationStamp != webxmlFile.getModificationStamp()) {
            descriptor = this.fetchDescriptor(webxmlPath, (IProgressMonitor)new NullProgressMonitor());
        }
        return descriptor;
    }

    private EntityResolver getEntityNonResolver() {
        if (this.resolver == null) {
            this.resolver = new NoEntityResolver();
        }
        return this.resolver;
    }

    private ErrorHandler getErrorHandler(IPath path) {
        if (this.errorHandler == null) {
            this.errorHandler = new ResourceErrorHandler(false);
        }
        this.errorHandler.setPath(path);
        return this.errorHandler;
    }

    public float getJSPVersion(IPath fullPath) {
        float version = 5.0f;
        DeploymentDescriptor descriptor = this.getCachedDescriptor(fullPath);
        if (descriptor != null && descriptor.version != null) {
            version = descriptor.version.floatValue();
            return this.convertSpecVersions(version);
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(fullPath.segment(0));
        float facetVersion = FacetModuleCoreSupport.getDynamicWebProjectVersion(project);
        if (facetVersion > 0.0f) {
            version = facetVersion;
        } else {
            ServletAPIDescriptor detected = this.getServletAPIVersion(project);
            if (detected != null) {
                return this.convertSpecVersions(detected.getAPIversion());
            }
        }
        return this.convertSpecVersions(version);
    }

    public PropertyGroup[] getPropertyGroups(IPath jspFilePath) {
        ArrayList<PropertyGroup> matchingGroups = new ArrayList<PropertyGroup>(1);
        DeploymentDescriptor descriptor = this.getCachedDescriptor(jspFilePath);
        if (descriptor == null) {
            return NO_PROPERTY_GROUPS;
        }
        int i = 0;
        while (i < descriptor.groups.length) {
            if (descriptor.groups[i].matches(FacetModuleCoreSupport.getRuntimePath(jspFilePath).toString(), false)) {
                matchingGroups.add(descriptor.groups[i]);
            }
            ++i;
        }
        if (matchingGroups.isEmpty()) {
            i = 0;
            while (i < descriptor.groups.length) {
                if (descriptor.groups[i].matches(FacetModuleCoreSupport.getRuntimePath(jspFilePath).toString(), true)) {
                    matchingGroups.add(descriptor.groups[i]);
                }
                ++i;
            }
        }
        return matchingGroups.toArray(new PropertyGroup[matchingGroups.size()]);
    }

    public ServletAPIDescriptor getServletAPIVersion(IProject project) {
        ServletAPIDescriptor descriptor;
        Reference<ServletAPIDescriptor> ref = this.apiVersions.get(project.getName());
        ServletAPIDescriptor servletAPIDescriptor = descriptor = ref != null ? ref.get() : null;
        if (descriptor == null) {
            descriptor = this.discoverServletAPIVersion(project);
            if (descriptor != null) {
                this.apiVersions.put(project.getName(), new SoftReference<ServletAPIDescriptor>(descriptor));
            } else {
                this.apiVersions.put(project.getName(), new WeakReference<ServletAPIDescriptor>(ServletAPIDescriptor.DEFAULT));
                descriptor = ServletAPIDescriptor.DEFAULT;
            }
        }
        return descriptor;
    }

    public String getURLMapping(IPath fullPath, String reference) {
        DeploymentDescriptor descriptor = this.getCachedDescriptor(fullPath);
        if (descriptor == null) {
            return null;
        }
        StringMatcher[] mappings = descriptor.urlPatterns;
        int i = 0;
        while (i < mappings.length) {
            if (mappings[i].match(reference)) {
                return mappings[i].pattern;
            }
            ++i;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPath getRelevantWebXMLPath(IPath fullPath) {
        IPath resolved = null;
        Map<IPath, IPath> mapForProject = null;
        Object object = LOCK;
        synchronized (object) {
            mapForProject = this.resolvedMap.get(fullPath.segment(0));
            if (mapForProject != null) {
                resolved = mapForProject.get(fullPath);
            } else {
                mapForProject = new HashMap<IPath, IPath>();
                this.resolvedMap.put(fullPath.segment(0), mapForProject);
            }
        }
        if (resolved == null) {
            resolved = FacetModuleCoreSupport.resolve(fullPath, SLASH_WEB_INF_WEB_XML);
            mapForProject.put(fullPath, resolved);
        }
        return resolved;
    }

    public IFile getWebXML(IPath fullPath) {
        IPath webxmlPath = this.getRelevantWebXMLPath(fullPath);
        if (webxmlPath == null) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFile(webxmlPath);
    }

    public void invalidate(String name) {
        DeploymentDescriptorPropertyCache.getInstance().resolvedMap.remove(name);
        DeploymentDescriptorPropertyCache.getInstance().apiVersions.remove(name);
    }

    private void updateCacheEntry(IPath fullPath) {
        this.fDeploymentDescriptors.remove(fullPath);
    }

    static class DeploymentDescriptor {
        PropertyGroup[] groups;
        long modificationStamp;
        StringMatcher[] urlPatterns;
        Float version = Float.valueOf(5.0f);

        DeploymentDescriptor() {
        }
    }

    static class NoEntityResolver
    implements EntityResolver {
        NoEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicID, String systemID) throws SAXException, IOException {
            InputSource result = new InputSource(new ByteArrayInputStream(new byte[0]));
            result.setPublicId(publicID);
            result.setSystemId(systemID != null ? systemID : "/_" + this.getClass().getName());
            return result;
        }
    }

    public static final class PropertyGroup {
        private boolean el_ignored;
        private String id;
        private IPath[] include_coda = new IPath[0];
        private IPath[] include_prelude = new IPath[0];
        private boolean is_xml;
        private StringMatcher[] urlMatchers;
        private String page_encoding;
        private boolean scripting_invalid;
        String[] url_patterns;
        private IPath webxmlPath;
        int number;

        static PropertyGroup createFrom(IPath path, Node propertyGroupNode, int groupNumber) {
            PropertyGroup group = new PropertyGroup(path, groupNumber);
            Node propertyGroupID = propertyGroupNode.getAttributes().getNamedItem(DeploymentDescriptorPropertyCache.ID);
            if (propertyGroupID != null) {
                group.setId(propertyGroupID.getNodeValue());
            }
            Node node = propertyGroupNode.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == 1) {
                    String name = node.getLocalName();
                    if (name == null) {
                        name = node.getNodeName();
                    }
                    if (DeploymentDescriptorPropertyCache.IS_XML.equals(name)) {
                        group.setIsXML(DeploymentDescriptorPropertyCache.getContainedText(node));
                    } else if (DeploymentDescriptorPropertyCache.EL_IGNORED.equals(name)) {
                        group.setElignored(DeploymentDescriptorPropertyCache.getContainedText(node));
                    } else if (DeploymentDescriptorPropertyCache.INCLUDE_CODA.equals(name)) {
                        group.addCoda(DeploymentDescriptorPropertyCache.getContainedText(node));
                    } else if (DeploymentDescriptorPropertyCache.INCLUDE_PRELUDE.equals(name)) {
                        group.addPrelude(DeploymentDescriptorPropertyCache.getContainedText(node));
                    } else if (DeploymentDescriptorPropertyCache.SCRIPTING_INVALID.equals(name)) {
                        group.setScriptingInvalid(DeploymentDescriptorPropertyCache.getContainedText(node));
                    } else if (DeploymentDescriptorPropertyCache.PAGE_ENCODING.equals(name)) {
                        group.setPageEncoding(DeploymentDescriptorPropertyCache.getContainedText(node));
                    } else if (DeploymentDescriptorPropertyCache.URL_PATTERN.equals(name)) {
                        group.addUrlPattern(DeploymentDescriptorPropertyCache.getContainedText(node));
                    }
                }
                node = node.getNextSibling();
            }
            return group;
        }

        private PropertyGroup(IPath path, int number) {
            this.webxmlPath = path;
            this.number = number;
        }

        void addCoda(String containedText) {
            if (containedText.length() > 0) {
                IPath[] codas = new IPath[this.include_coda.length + 1];
                System.arraycopy(this.include_coda, 0, codas, 0, this.include_coda.length);
                codas[this.include_coda.length] = this.webxmlPath.removeLastSegments(2).append(containedText);
                this.include_coda = codas;
            }
        }

        void addPrelude(String containedText) {
            if (containedText.length() > 0) {
                IPath[] preludes = new IPath[this.include_prelude.length + 1];
                System.arraycopy(this.include_prelude, 0, preludes, 0, this.include_prelude.length);
                preludes[this.include_prelude.length] = this.webxmlPath.removeLastSegments(2).append(containedText);
                this.include_prelude = preludes;
            }
        }

        void addUrlPattern(String pattern) {
            if (this.url_patterns == null) {
                this.url_patterns = new String[1];
            } else {
                String[] patterns = new String[this.url_patterns.length + 1];
                System.arraycopy(this.url_patterns, 0, patterns, 0, this.url_patterns.length);
                this.url_patterns = patterns;
            }
            this.url_patterns[this.url_patterns.length - 1] = pattern;
            if (this.urlMatchers == null) {
                this.urlMatchers = new StringMatcher[1];
            } else {
                StringMatcher[] matchers = new StringMatcher[this.urlMatchers.length + 1];
                System.arraycopy(this.urlMatchers, 0, matchers, 0, this.urlMatchers.length);
            }
            this.urlMatchers[this.urlMatchers.length - 1] = new StringMatcher(pattern);
        }

        public String getId() {
            return this.id;
        }

        public IPath[] getIncludeCoda() {
            return this.include_coda;
        }

        public IPath[] getIncludePrelude() {
            return this.include_prelude;
        }

        public String getPageEncoding() {
            return this.page_encoding;
        }

        public String[] getUrlPatterns() {
            return this.url_patterns;
        }

        public boolean isELignored() {
            return this.el_ignored;
        }

        public boolean isIsXML() {
            return this.is_xml;
        }

        public boolean isScriptingInvalid() {
            return this.scripting_invalid;
        }

        boolean matches(String pattern, boolean optimistic) {
            if (this.urlMatchers == null) {
                return optimistic;
            }
            int i = 0;
            while (i < this.urlMatchers.length) {
                if (this.urlMatchers[i].match(pattern)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        void setElignored(String el_ignored) {
            this.el_ignored = Boolean.valueOf(el_ignored);
        }

        void setId(String id) {
            this.id = id;
        }

        void setIsXML(String is_xml) {
            this.is_xml = Boolean.valueOf(is_xml);
        }

        void setPageEncoding(String page_encoding) {
            this.page_encoding = page_encoding;
        }

        void setScriptingInvalid(String scripting_invalid) {
            this.scripting_invalid = Boolean.valueOf(scripting_invalid);
        }

        void setUrlPatterns(String[] url_patterns) {
            this.url_patterns = url_patterns;
            if (url_patterns != null && url_patterns.length > 0) {
                this.urlMatchers = new StringMatcher[url_patterns.length];
                int i = 0;
                while (i < url_patterns.length) {
                    this.urlMatchers[i] = new StringMatcher(url_patterns[i]);
                    ++i;
                }
            }
        }

        public String toString() {
            return String.valueOf(this.number) + ":" + this.url_patterns;
        }
    }

    static class ResourceChangeListener
    implements IResourceChangeListener {
        ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            if (event.getType() != 1) {
                return;
            }
            if (delta.getKind() == 4 && (delta.getFlags() == 0x100000 || delta.getFlags() == 131072)) {
                return;
            }
            ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
            try {
                delta.accept((IResourceDeltaVisitor)visitor);
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        }
    }

    static class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        ResourceDeltaVisitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean visit(IResourceDelta delta) {
            IResource resource = delta.getResource();
            if (resource.getType() == 1) {
                if (delta.getKind() == 4 && (delta.getFlags() == 0x100000 || delta.getFlags() == 131072)) {
                    return false;
                }
                IPath path = resource.getFullPath();
                int segmentCount = path.segmentCount();
                if (segmentCount > 1 && path.lastSegment().equals(DeploymentDescriptorPropertyCache.WEB_XML) && path.segment(segmentCount - 2).equals(DeploymentDescriptorPropertyCache.WEB_INF)) {
                    DeploymentDescriptorPropertyCache.getInstance().deploymentDescriptorChanged(path);
                }
                if ("org.eclipse.wst.common.project.facet.core.xml".equalsIgnoreCase(path.lastSegment())) {
                    Object object = LOCK;
                    synchronized (object) {
                        DeploymentDescriptorPropertyCache.getInstance().invalidate(path.segment(0));
                    }
                }
            } else if (resource.getType() == 4 && (delta.getKind() == 1 || delta.getKind() == 2)) {
                String name = resource.getName();
                Object object = LOCK;
                synchronized (object) {
                    DeploymentDescriptorPropertyCache.getInstance().invalidate(name);
                }
            }
            return true;
        }
    }

    private static class ResourceErrorHandler
    implements ErrorHandler {
        private boolean fDoLogExceptions = false;
        private IPath fPath;

        ResourceErrorHandler(boolean logExceptions) {
            this.fDoLogExceptions = logExceptions;
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            if (this.fDoLogExceptions) {
                Logger.log(2, "SAXParseException with " + this.fPath + " (error) while reading descriptor: " + exception.getMessage());
            }
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            if (this.fDoLogExceptions) {
                Logger.log(2, "SAXParseException with " + this.fPath + " (fatalError) while reading descriptor: " + exception.getMessage());
            }
        }

        public void setPath(IPath path) {
            this.fPath = path;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            if (this.fDoLogExceptions) {
                Logger.log(2, "SAXParseException with " + this.fPath + " (warning) while reading descriptor: " + exception.getMessage());
            }
        }
    }

    private static class StringMatcher {
        private static final char SINGLE_WILD_CARD = '\u0000';
        private int bound = 0;
        private boolean hasLeadingStar;
        private boolean hasTrailingStar;
        final String pattern;
        private final int patternLength;
        private String[] segments;

        StringMatcher(String pattern) {
            if (pattern == null) {
                throw new IllegalArgumentException();
            }
            this.pattern = pattern;
            this.patternLength = pattern.length();
            this.parseWildCards();
        }

        private int findPosition(String text, int start, int end, String p) {
            boolean hasWildCard = p.indexOf(0) >= 0;
            int plen = p.length();
            int i = start;
            int max = end - plen;
            while (i <= max) {
                if (hasWildCard ? this.regExpRegionMatches(text, i, p, 0, plen) : text.regionMatches(true, i, p, 0, plen)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        /*
         * Unable to fully structure code
         */
        public boolean match(String text) {
            if (text == null) {
                return false;
            }
            end = text.length();
            segmentCount = this.segments.length;
            if (segmentCount == 0 && (this.hasLeadingStar || this.hasTrailingStar)) {
                return true;
            }
            if (end == 0) {
                return this.patternLength == 0;
            }
            if (this.patternLength == 0) {
                return false;
            }
            currentTextPosition = 0;
            if (end - this.bound < 0) {
                return false;
            }
            segmentIndex = 0;
            current = this.segments[segmentIndex];
            if (!this.hasLeadingStar) {
                currentLength = current.length();
                if (!this.regExpRegionMatches(text, 0, current, 0, currentLength)) {
                    return false;
                }
                ++segmentIndex;
                currentTextPosition += currentLength;
            }
            if (segmentCount != 1 || this.hasLeadingStar || this.hasTrailingStar) ** GOTO lbl30
            return currentTextPosition == end;
lbl-1000:
            // 1 sources

            {
                current = this.segments[segmentIndex];
                currentMatch = this.findPosition(text, currentTextPosition, end, current);
                if (currentMatch < 0) {
                    return false;
                }
                currentTextPosition = currentMatch + current.length();
                ++segmentIndex;
lbl30:
                // 2 sources

                ** while (segmentIndex < segmentCount)
            }
lbl31:
            // 1 sources

            if (!this.hasTrailingStar && currentTextPosition != end) {
                currentLength = current.length();
                return this.regExpRegionMatches(text, end - currentLength, current, 0, currentLength);
            }
            return segmentIndex == segmentCount;
        }

        private void parseWildCards() {
            if (this.pattern.startsWith("*")) {
                this.hasLeadingStar = true;
            }
            if (this.pattern.endsWith("*") && this.patternLength > 1 && this.pattern.charAt(this.patternLength - 2) != '\\') {
                this.hasTrailingStar = true;
            }
            ArrayList<String> temp = new ArrayList<String>();
            int pos = 0;
            StringBuffer buf = new StringBuffer();
            block5: while (pos < this.patternLength) {
                char c = this.pattern.charAt(pos++);
                switch (c) {
                    case '\\': {
                        char next;
                        if (pos >= this.patternLength) {
                            buf.append(c);
                            break;
                        }
                        if ((next = this.pattern.charAt(pos++)) == '*' || next == '?' || next == '\\') {
                            buf.append(next);
                            break;
                        }
                        buf.append(c);
                        buf.append(next);
                        break;
                    }
                    case '*': {
                        if (buf.length() <= 0) continue block5;
                        temp.add(buf.toString());
                        this.bound += buf.length();
                        buf.setLength(0);
                        break;
                    }
                    case '?': {
                        buf.append('\u0000');
                        break;
                    }
                    default: {
                        buf.append(c);
                    }
                }
            }
            if (buf.length() > 0) {
                temp.add(buf.toString());
                this.bound += buf.length();
            }
            this.segments = temp.toArray(new String[temp.size()]);
        }

        private boolean regExpRegionMatches(String text, int tStart, String p, int pStart, int plen) {
            while (plen-- > 0) {
                char pchar;
                char tchar = text.charAt(tStart++);
                if ((pchar = p.charAt(pStart++)) == '\u0000' || pchar == tchar || Character.toUpperCase(tchar) == Character.toUpperCase(pchar) || Character.toLowerCase(tchar) == Character.toLowerCase(pchar)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return "StringMatcher: " + this.pattern;
        }
    }
}

