/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.tparsers;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.Messages;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.nodedata.ProbeNodeData;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.nodedata.ProbevarNodeData;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.tparsers.SharedParser;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.tparsers.TreeTapsetParser;
import org.eclipse.linuxtools.systemtap.structures.TreeDefinitionNode;
import org.eclipse.linuxtools.systemtap.structures.TreeNode;

public final class ProbeParser
extends TreeTapsetParser {
    public static final String PROBE_REGEX = "(?s)(?<!\\w)probe\\s+{0}\\s*\\+?=";
    private static final String TAPSET_PROBE_REGEX = "probe {0} \\+?=";
    private static final String PROBE_FORM_CHECK_REGEX = "\\w+((\\(\\w+\\))?(\\.\\w+)?)*( \\$?\\w+:\\w+)*";
    private static final Pattern PROBE_GROUP_PATTERN = Pattern.compile("[^\\.\\(]+");
    private static ProbeParser parser = null;

    public static ProbeParser getInstance() {
        if (parser != null) {
            return parser;
        }
        parser = new ProbeParser();
        return parser;
    }

    private ProbeParser() {
        super(Messages.ProbeParser_name);
    }

    @Override
    protected boolean isValidTree(TreeNode tree) {
        return super.isValidTree(tree) && tree.getChildByName(Messages.ProbeParser_staticProbes) != null && tree.getChildByName(Messages.ProbeParser_aliasProbes) != null;
    }

    @Override
    protected int runAction(IProgressMonitor monitor) {
        int result = this.addStaticProbes(monitor);
        if (result == 0) {
            result = this.addProbeAliases(monitor);
        }
        return result;
    }

    private int addStaticProbes(IProgressMonitor monitor) {
        TreeNode statics = new TreeNode((Object)Messages.ProbeParser_staticProbes, false);
        this.tree.add(statics);
        if (monitor.isCanceled()) {
            return 8;
        }
        String probeDump = this.runStap(new String[]{"--dump-probe-types"}, null, false);
        int result = this.verifyRunResult(probeDump);
        if (result != 0) {
            return result;
        }
        if (!this.doQuickErrorCheck(probeDump)) {
            return 4;
        }
        boolean canceled = false;
        Throwable throwable = null;
        Object var7_8 = null;
        try (Scanner st = new Scanner(probeDump);){
            TreeNode groupNode = null;
            while (st.hasNextLine()) {
                if (monitor.isCanceled()) {
                    canceled = true;
                    break;
                }
                String tokenString = st.nextLine();
                groupNode = this.addOrFindProbeGroup(this.extractProbeGroupName(tokenString), groupNode, statics);
                groupNode.add(this.makeStaticProbeNode(tokenString));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        statics.sortTree();
        return !canceled ? 0 : 8;
    }

    private int addProbeAliases(IProgressMonitor monitor) {
        TreeNode statics = this.tree.getChildByName(Messages.ProbeParser_staticProbes);
        if (statics == null) {
            return 4;
        }
        TreeNode aliases = new TreeNode((Object)Messages.ProbeParser_aliasProbes, false);
        this.tree.add(aliases);
        if (monitor.isCanceled()) {
            return 8;
        }
        String probeDump = this.runStap(new String[]{"-L"}, "**", false);
        int result = this.verifyRunResult(probeDump);
        if (result != 0) {
            return result;
        }
        if (!this.doQuickErrorCheck(probeDump)) {
            return 4;
        }
        boolean canceled = false;
        Throwable throwable = null;
        Object var8_9 = null;
        try (Scanner st = new Scanner(probeDump);){
            TreeNode groupNode = null;
            while (st.hasNextLine()) {
                String groupName;
                if (monitor.isCanceled()) {
                    canceled = true;
                    break;
                }
                String tokenString = st.nextLine();
                if (tokenString.startsWith("_") || statics.getChildByName(groupName = this.extractProbeGroupName(tokenString)) != null) continue;
                groupNode = this.addSingleProbeAlias(tokenString, aliases, groupNode, groupName, null);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        aliases.sortTree();
        return !canceled ? 0 : 8;
    }

    private boolean doQuickErrorCheck(String probeDump) {
        if (probeDump == null) {
            return false;
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (Scanner scanner = new Scanner(probeDump);){
            return Pattern.matches(PROBE_FORM_CHECK_REGEX, scanner.nextLine());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private TreeNode addSingleProbeAlias(String probeLine, TreeNode aliases, TreeNode groupNode, String groupName, String definition) {
        StringTokenizer probeTokenizer = new StringTokenizer(probeLine);
        String probeName = probeTokenizer.nextToken();
        TreeNode probeNode = this.makeProbeAliasNode(probeName, definition == null ? this.findDefinitionOf(probeName) : definition);
        groupNode = this.addOrFindProbeGroup(groupName == null ? this.extractProbeGroupName(probeName) : groupName, groupNode, aliases);
        groupNode.add(probeNode);
        this.addAllVarNodesToProbeNode(probeTokenizer, probeNode);
        return groupNode;
    }

    private TreeNode addOrFindProbeGroup(String groupName, TreeNode groupNode, TreeNode category) {
        if (groupNode == null || !groupNode.toString().equals(groupName)) {
            groupNode = category.getChildByName(groupName);
        }
        if (groupNode == null) {
            groupNode = new TreeNode((Object)groupName, true);
            category.add(groupNode);
        }
        return groupNode;
    }

    private String extractProbeGroupName(String probeName) {
        Matcher m = PROBE_GROUP_PATTERN.matcher(probeName);
        return m.find() ? m.group() : probeName;
    }

    private TreeNode makeStaticProbeNode(String probeName) {
        return new TreeNode((Object)new ProbeNodeData(probeName), probeName, true);
    }

    private TreeNode makeProbeAliasNode(String probeName, String definition) {
        return new TreeDefinitionNode((Object)new ProbeNodeData(probeName), probeName, definition, true);
    }

    private String findDefinitionOf(String probeName) {
        String tapsetContents = SharedParser.getInstance().getTapsetContents();
        if (tapsetContents == null) {
            return null;
        }
        Matcher probeMatcher = Pattern.compile(MessageFormat.format(TAPSET_PROBE_REGEX, Pattern.quote(probeName))).matcher(tapsetContents);
        if (!probeMatcher.find()) {
            return null;
        }
        int fileLocIndex = tapsetContents.substring(0, probeMatcher.start()).lastIndexOf("# file ");
        Throwable throwable = null;
        Object var6_7 = null;
        try (Scanner scanner = new Scanner(tapsetContents.substring(fileLocIndex));){
            return SharedParser.findFileNameInTag(scanner.nextLine());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void addAllVarNodesToProbeNode(StringTokenizer varTokenizer, TreeNode probeNode) {
        StringBuilder prev = new StringBuilder("");
        while (varTokenizer.hasMoreTokens()) {
            String token = varTokenizer.nextToken();
            if (token.contains(":") && prev.length() > 0) {
                prev.setLength(prev.length() - 1);
                this.addVarNodeToProbeNode(prev.toString(), probeNode);
                prev.setLength(0);
            }
            prev.append(String.valueOf(token) + " ");
        }
        if (prev.length() > 0) {
            prev.setLength(prev.length() - 1);
            this.addVarNodeToProbeNode(prev.toString(), probeNode);
        }
        probeNode.sortLevel();
    }

    private void addVarNodeToProbeNode(String info, TreeNode probeNode) {
        probeNode.add(new TreeNode((Object)new ProbevarNodeData(info), info, false));
    }

    @Override
    protected int delTapsets(String[] tapsets, IProgressMonitor monitor) {
        TreeNode aliases = this.tree.getChildByName(Messages.ProbeParser_aliasProbes);
        int i = 0;
        while (i < tapsets.length) {
            int g = 0;
            int gn = aliases.getChildCount();
            while (g < gn) {
                if (monitor.isCanceled()) {
                    return 8;
                }
                TreeNode group = aliases.getChildAt(g);
                int p = 0;
                int pn = group.getChildCount();
                while (p < pn) {
                    String definition = ((TreeDefinitionNode)group.getChildAt(p)).getDefinition();
                    if (definition != null && definition.startsWith(tapsets[i])) {
                        group.remove(p--);
                        --pn;
                    }
                    ++p;
                }
                if (group.getChildCount() == 0) {
                    aliases.remove(g--);
                    --gn;
                }
                ++g;
            }
            ++i;
        }
        return 0;
    }

    @Override
    protected int addTapsets(String tapsetContents, String[] additions, IProgressMonitor monitor) {
        boolean canceled = false;
        TreeNode aliases = this.tree.getChildByName(Messages.ProbeParser_aliasProbes);
        HashMap fileToItemMap = new HashMap();
        int i = 0;
        while (i < additions.length) {
            int firstTagIndex = 0;
            while ((firstTagIndex = tapsetContents.indexOf(SharedParser.makeFileTag(additions[i]), firstTagIndex)) != -1) {
                String filename;
                int nextTagIndex = tapsetContents.indexOf("# file ", firstTagIndex + 1);
                String fileContents = nextTagIndex != -1 ? tapsetContents.substring(firstTagIndex, nextTagIndex) : tapsetContents.substring(firstTagIndex);
                Throwable throwable = null;
                Object var13_17 = null;
                try (Scanner st = new Scanner(fileContents);){
                    filename = SharedParser.findFileNameInTag(st.nextLine());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                ArrayList<String> newItems = new ArrayList<String>();
                Matcher matcher = Pattern.compile(MessageFormat.format(TAPSET_PROBE_REGEX, "(\\S+)")).matcher(fileContents);
                while (matcher.find()) {
                    newItems.add(matcher.group(1));
                }
                if (!newItems.isEmpty()) {
                    fileToItemMap.put(filename, newItems);
                }
                tapsetContents = tapsetContents.substring(0, firstTagIndex).concat(tapsetContents.substring(firstTagIndex + fileContents.length()));
            }
            ++i;
        }
        block8: for (Map.Entry entry : fileToItemMap.entrySet()) {
            for (String newitem : (ArrayList)entry.getValue()) {
                if (canceled || monitor.isCanceled()) {
                    canceled = true;
                    continue block8;
                }
                this.addSingleProbeAlias(this.runStap(new String[]{"-L"}, newitem, false), aliases, null, null, (String)entry.getKey());
            }
        }
        aliases.sortTree();
        return !canceled ? 0 : 8;
    }
}

